/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.AuthenticatedUserPrincipalId;
import world.respect.datalayer.respect.model.SchoolDirectoryEntry;
import world.respect.shared.domain.account.RespectAccount$;
import world.respect.shared.util.di.RespectAccountScopeId;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB7\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006)"}, d2={"Lworld/respect/shared/domain/account/RespectAccount;", "", "userGuid", "", "school", "Lworld/respect/datalayer/respect/model/SchoolDirectoryEntry;", "startedViaParent", "", "<init>", "(Ljava/lang/String;Lworld/respect/datalayer/respect/model/SchoolDirectoryEntry;Z)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lworld/respect/datalayer/respect/model/SchoolDirectoryEntry;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getUserGuid", "()Ljava/lang/String;", "getSchool", "()Lworld/respect/datalayer/respect/model/SchoolDirectoryEntry;", "getStartedViaParent", "()Z", "scopeId", "getScopeId", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$respect_lib_shared_debug", "$serializer", "Companion", "respect-lib-shared_debug"})
@StabilityInferred(parameters=0)
public final class RespectAccount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String userGuid;
    @NotNull
    private final SchoolDirectoryEntry school;
    private final boolean startedViaParent;
    public static final int $stable = 8;

    public RespectAccount(@NotNull String userGuid, @NotNull SchoolDirectoryEntry school, boolean startedViaParent) {
        Intrinsics.checkNotNullParameter((Object)userGuid, (String)"userGuid");
        Intrinsics.checkNotNullParameter((Object)school, (String)"school");
        this.userGuid = userGuid;
        this.school = school;
        this.startedViaParent = startedViaParent;
    }

    public /* synthetic */ RespectAccount(String string2, SchoolDirectoryEntry schoolDirectoryEntry, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string2, schoolDirectoryEntry, bl);
    }

    @NotNull
    public final String getUserGuid() {
        return this.userGuid;
    }

    @NotNull
    public final SchoolDirectoryEntry getSchool() {
        return this.school;
    }

    public final boolean getStartedViaParent() {
        return this.startedViaParent;
    }

    @NotNull
    public final String getScopeId() {
        return new RespectAccountScopeId(this.school.getSelf(), new AuthenticatedUserPrincipalId(this.userGuid)).getScopeId();
    }

    @NotNull
    public final String component1() {
        return this.userGuid;
    }

    @NotNull
    public final SchoolDirectoryEntry component2() {
        return this.school;
    }

    public final boolean component3() {
        return this.startedViaParent;
    }

    @NotNull
    public final RespectAccount copy(@NotNull String userGuid, @NotNull SchoolDirectoryEntry school, boolean startedViaParent) {
        Intrinsics.checkNotNullParameter((Object)userGuid, (String)"userGuid");
        Intrinsics.checkNotNullParameter((Object)school, (String)"school");
        return new RespectAccount(userGuid, school, startedViaParent);
    }

    public static /* synthetic */ RespectAccount copy$default(RespectAccount respectAccount, String string2, SchoolDirectoryEntry schoolDirectoryEntry, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = respectAccount.userGuid;
        }
        if ((n & 2) != 0) {
            schoolDirectoryEntry = respectAccount.school;
        }
        if ((n & 4) != 0) {
            bl = respectAccount.startedViaParent;
        }
        return respectAccount.copy(string2, schoolDirectoryEntry, bl);
    }

    @NotNull
    public String toString() {
        return "RespectAccount(userGuid=" + this.userGuid + ", school=" + this.school + ", startedViaParent=" + this.startedViaParent + ")";
    }

    public int hashCode() {
        int result = this.userGuid.hashCode();
        result = result * 31 + this.school.hashCode();
        result = result * 31 + Boolean.hashCode(this.startedViaParent);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RespectAccount)) {
            return false;
        }
        RespectAccount respectAccount = (RespectAccount)other;
        if (!Intrinsics.areEqual((Object)this.userGuid, (Object)respectAccount.userGuid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.school, (Object)respectAccount.school)) {
            return false;
        }
        return this.startedViaParent == respectAccount.startedViaParent;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$respect_lib_shared_debug(RespectAccount self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.userGuid);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)SchoolDirectoryEntry.$serializer.INSTANCE, (Object)self.school);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.startedViaParent) {
            output.encodeBooleanElement(serialDesc, 2, self.startedViaParent);
        }
    }

    public /* synthetic */ RespectAccount(int seen0, String userGuid, SchoolDirectoryEntry school, boolean startedViaParent, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.userGuid = userGuid;
        this.school = school;
        this.startedViaParent = (seen0 & 4) == 0 ? false : startedViaParent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/shared/domain/account/RespectAccount$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lworld/respect/shared/domain/account/RespectAccount;", "respect-lib-shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<RespectAccount> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

