/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.clipboard;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.widget.Toast;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import world.respect.shared.domain.clipboard.SetClipboardStringUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lworld/respect/shared/domain/clipboard/SetClipboardStringUseCaseAndroid;", "Lworld/respect/shared/domain/clipboard/SetClipboardStringUseCase;", "appContext", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "clipboardManager", "Landroid/content/ClipboardManager;", "invoke", "", "content", "", "respect-lib-shared_debug"})
@StabilityInferred(parameters=0)
public final class SetClipboardStringUseCaseAndroid
implements SetClipboardStringUseCase {
    @NotNull
    private final Context appContext;
    @NotNull
    private final ClipboardManager clipboardManager;
    public static final int $stable = 8;

    public SetClipboardStringUseCaseAndroid(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.appContext = appContext;
        Object object = this.appContext.getSystemService("clipboard");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        this.clipboardManager = (ClipboardManager)object;
    }

    @Override
    public void invoke(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ClipData clipData = ClipData.newPlainText((CharSequence)"text", (CharSequence)content);
        this.clipboardManager.setPrimaryClip(clipData);
        Toast.makeText((Context)this.appContext, (CharSequence)"Copied", (int)1).show();
    }
}

