/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.style;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.util.ListUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/text/style/TextDecoration;", "", "mask", "", "<init>", "(I)V", "getMask", "()I", "plus", "decoration", "contains", "", "other", "toString", "", "equals", "hashCode", "Companion", "ui-text"})
@Immutable
public final class TextDecoration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int mask;
    public static final int $stable;
    @NotNull
    private static final TextDecoration None;
    @NotNull
    private static final TextDecoration Underline;
    @NotNull
    private static final TextDecoration LineThrough;

    public TextDecoration(int mask) {
        this.mask = mask;
    }

    public final int getMask() {
        return this.mask;
    }

    @NotNull
    public final TextDecoration plus(@NotNull TextDecoration decoration) {
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        return new TextDecoration(this.mask | decoration.mask);
    }

    public final boolean contains(@NotNull TextDecoration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (this.mask | other.mask) == this.mask;
    }

    @NotNull
    public String toString() {
        if (this.mask == 0) {
            return "TextDecoration.None";
        }
        List values = new ArrayList();
        if ((this.mask & TextDecoration.Underline.mask) != 0) {
            values.add("Underline");
        }
        if ((this.mask & TextDecoration.LineThrough.mask) != 0) {
            values.add("LineThrough");
        }
        if (values.size() == 1) {
            return "TextDecoration." + values.get(0);
        }
        return "TextDecoration[" + ListUtilsKt.fastJoinToString$default((List)values, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextDecoration)) {
            return false;
        }
        return this.mask == ((TextDecoration)other).mask;
    }

    public int hashCode() {
        return this.mask;
    }

    static {
        None = new TextDecoration(0);
        Underline = new TextDecoration(1);
        LineThrough = new TextDecoration(2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/text/style/TextDecoration$Companion;", "", "<init>", "()V", "None", "Landroidx/compose/ui/text/style/TextDecoration;", "getNone$annotations", "getNone", "()Landroidx/compose/ui/text/style/TextDecoration;", "Underline", "getUnderline$annotations", "getUnderline", "LineThrough", "getLineThrough$annotations", "getLineThrough", "combine", "decorations", "", "ui-text"})
    @SourceDebugExtension(value={"SMAP\nTextDecoration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextDecoration.kt\nandroidx/compose/ui/text/style/TextDecoration$Companion\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,103:1\n270#2,2:104\n35#2,5:106\n272#2:111\n*S KotlinDebug\n*F\n+ 1 TextDecoration.kt\nandroidx/compose/ui/text/style/TextDecoration$Companion\n*L\n51#1:104,2\n51#1:106,5\n51#1:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextDecoration getNone() {
            return None;
        }

        @Stable
        public static /* synthetic */ void getNone$annotations() {
        }

        @NotNull
        public final TextDecoration getUnderline() {
            return Underline;
        }

        @Stable
        public static /* synthetic */ void getUnderline$annotations() {
        }

        @NotNull
        public final TextDecoration getLineThrough() {
            return LineThrough;
        }

        @Stable
        public static /* synthetic */ void getLineThrough$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TextDecoration combine(@NotNull List<TextDecoration> decorations) {
            void $this$fastFold$iv;
            Intrinsics.checkNotNullParameter(decorations, (String)"decorations");
            List<TextDecoration> list = decorations;
            Integer initial$iv = 0;
            boolean $i$f$fastFold = false;
            Integer accumulator$iv = null;
            accumulator$iv = initial$iv;
            void $this$fastForEach$iv$iv = $this$fastFold$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                void decoration;
                Object item$iv$iv;
                Object e$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                TextDecoration textDecoration = (TextDecoration)e$iv;
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl2 = false;
                accumulator$iv = acc | decoration.getMask();
            }
            int mask = ((Number)accumulator$iv).intValue();
            return new TextDecoration(mask);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

