/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.cbor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCtapCanonicalCborSerializer<T>
extends StdSerializer<T> {
    private final transient List<FieldSerializationRule<T, ?>> rules;

    protected AbstractCtapCanonicalCborSerializer(@NotNull Class<T> t, @NotNull List<FieldSerializationRule<T, ?>> rules) {
        super(t);
        this.rules = rules;
    }

    @Override
    public void serialize(@NotNull T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) throws IOException {
        List nonNullValues = this.rules.stream().map(rule -> {
            Object fieldValue = rule.getGetter().apply(value);
            return new KeyValue(rule.getName(), fieldValue);
        }).filter(item2 -> item2.value != null).collect(Collectors.toList());
        ((CBORGenerator)gen).writeStartObject(nonNullValues.size());
        for (KeyValue nonNullValue : nonNullValues) {
            if (nonNullValue.name instanceof String) {
                gen.writeFieldName((String)nonNullValue.name);
            } else {
                gen.writeFieldId(((Integer)nonNullValue.name).intValue());
            }
            gen.writeObject(nonNullValue.value);
        }
        gen.writeEndObject();
    }

    private static class KeyValue {
        @NotNull
        private final Object name;
        @Nullable
        private final Object value;

        public KeyValue(@NotNull Object name, @Nullable Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class FieldSerializationRule<T, R> {
        @NotNull
        private final Object name;
        @NotNull
        private final Function<T, R> getter;

        public FieldSerializationRule(int name, @NotNull Function<T, @Nullable R> getter2) {
            this.name = name;
            this.getter = getter2;
        }

        public FieldSerializationRule(@NotNull String name, @NotNull Function<T, @Nullable R> getter2) {
            this.name = name;
            this.getter = getter2;
        }

        @NotNull
        public Object getName() {
            return this.name;
        }

        @NotNull
        public @NotNull Function<T, @NotNull R> getGetter() {
            return this.getter;
        }
    }
}

