/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.verifier.exception.BadRpIdException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class RpIdHashVerifier {
    RpIdHashVerifier() {
    }

    public void verify(@NotNull byte[] rpIdHash, @NotNull CoreServerProperty serverProperty) {
        AssertUtil.notNull(rpIdHash, "rpIdHash must not be null");
        AssertUtil.notNull(serverProperty, "serverProperty must not be null");
        String rpId = serverProperty.getRpId();
        AssertUtil.notNull(rpId, "rpId must not be null");
        MessageDigest messageDigest = MessageDigestUtil.createSHA256();
        byte[] relyingPartyRpIdBytes = rpId.getBytes(StandardCharsets.UTF_8);
        byte[] relyingPartyRpIdHash = messageDigest.digest(relyingPartyRpIdBytes);
        if (!Arrays.equals(rpIdHash, relyingPartyRpIdHash)) {
            throw new BadRpIdException("rpIdHash doesn't match the hash of preconfigured rpId.");
        }
    }
}

