/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.annotationprocessor.core;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import com.ustadmobile.lib.annotationprocessor.core.DoorJdbcProcessorKt;
import com.ustadmobile.lib.annotationprocessor.core.DoorTarget;
import com.ustadmobile.lib.annotationprocessor.core.ext.ResolverExtKt;
import com.ustadmobile.lib.annotationprocessor.core.ext.SymbolProcessorEnvironmentExtKt;
import java.sql.Connection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ustadmobile/lib/annotationprocessor/core/DoorJdbcProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "dbConnection", "Ljava/sql/Connection;", "getDbConnection$door_compiler", "()Ljava/sql/Connection;", "setDbConnection$door_compiler", "(Ljava/sql/Connection;)V", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "Companion", "door-compiler"})
@SourceDebugExtension(value={"SMAP\nDoorJdbcProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoorJdbcProcessor.kt\ncom/ustadmobile/lib/annotationprocessor/core/DoorJdbcProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1322:1\n1313#2,2:1323\n1313#2,2:1325\n*S KotlinDebug\n*F\n+ 1 DoorJdbcProcessor.kt\ncom/ustadmobile/lib/annotationprocessor/core/DoorJdbcProcessor\n*L\n1270#1:1323,2\n1291#1:1325,2\n*E\n"})
public final class DoorJdbcProcessor
implements SymbolProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SymbolProcessorEnvironment environment;
    public Connection dbConnection;
    @NotNull
    private static final List<DoorTarget> JDBC_TARGETS;
    @NotNull
    public static final String SUFFIX_JDBC_IMPL = "_JdbcImpl";
    @NotNull
    public static final String SUFFIX_JS_IMPLEMENTATION_CLASSES = "JsImplementations";
    @NotNull
    public static final String TRIGGER_TEMPLATE_TABLE_AND_FIELD_NAMES = "%TABLE_AND_FIELD_NAMES%";
    @NotNull
    public static final String TRIGGER_TEMPLATE_NEW_VALUES = "%NEW_VALUES%";
    @NotNull
    public static final String TRIGGER_TEMPLATE_NEW_LAST_MODIFIED_GREATER_THAN_EXISTING = "%NEW_LAST_MODIFIED_GREATER_THAN_EXISTING%";
    @NotNull
    public static final String TRIGGER_TEMPLATE_NEW_ETAG_NOT_EQUAL_TO_EXISTING = "%NEW_ETAG_NOT_EQUAL_TO_EXISTING%";

    public DoorJdbcProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
    }

    @NotNull
    public final Connection getDbConnection$door_compiler() {
        Connection connection = this.dbConnection;
        if (connection != null) {
            return connection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dbConnection");
        return null;
    }

    public final void setDbConnection$door_compiler(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<set-?>");
        this.dbConnection = connection;
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Sequence<KSClassDeclaration> dbSymbols2 = ResolverExtKt.getDatabaseSymbolsToProcess(resolver);
        Sequence<KSClassDeclaration> daoSymbols2 = ResolverExtKt.getDaoSymbolsToProcess(resolver);
        DoorTarget target = SymbolProcessorEnvironmentExtKt.doorTarget(this.environment, resolver);
        Sequence<KSClassDeclaration> $this$forEach$iv = dbSymbols2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSClassDeclaration dbKSClass = (KSClassDeclaration)element$iv;
            boolean bl = false;
            OriginatingKSFilesKt.writeTo$default((FileSpec)DoorJdbcProcessorKt.access$addDatabaseMetadataType(FileSpec.Companion.builder(dbKSClass.getPackageName().asString(), dbKSClass.getSimpleName().asString() + "_DoorMetadata"), dbKSClass, resolver, target).build(), (CodeGenerator)this.environment.getCodeGenerator(), (boolean)false, null, (int)4, null);
            if (JDBC_TARGETS.contains((Object)target)) {
                OriginatingKSFilesKt.writeTo$default((FileSpec)DoorJdbcProcessorKt.addJdbcDbImplType(FileSpec.Companion.builder(dbKSClass.getPackageName().asString(), dbKSClass.getSimpleName().asString() + SUFFIX_JDBC_IMPL), dbKSClass, target, resolver).build(), (CodeGenerator)this.environment.getCodeGenerator(), (boolean)false, null, (int)4, null);
            }
            if (target != DoorTarget.JS) continue;
            OriginatingKSFilesKt.writeTo$default((FileSpec)DoorJdbcProcessorKt.access$addJsImplementationsClassesObject(FileSpec.Companion.builder(dbKSClass.getPackageName().asString(), dbKSClass.getSimpleName().asString() + SUFFIX_JS_IMPLEMENTATION_CLASSES), dbKSClass).build(), (CodeGenerator)this.environment.getCodeGenerator(), (boolean)false, null, (int)4, null);
        }
        if (JDBC_TARGETS.contains((Object)target)) {
            $this$forEach$iv = daoSymbols2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KSClassDeclaration daoKSClass = (KSClassDeclaration)element$iv;
                boolean bl = false;
                OriginatingKSFilesKt.writeTo$default((FileSpec)DoorJdbcProcessorKt.addDaoJdbcImplType(FileSpec.Companion.builder(daoKSClass.getPackageName().asString(), daoKSClass.getSimpleName().asString() + SUFFIX_JDBC_IMPL), daoKSClass, resolver, this.environment, target).build(), (CodeGenerator)this.environment.getCodeGenerator(), (boolean)false, null, (int)4, null);
            }
        }
        return CollectionsKt.emptyList();
    }

    static {
        DoorTarget[] doorTargetArray = new DoorTarget[]{DoorTarget.JVM, DoorTarget.JS};
        JDBC_TARGETS = CollectionsKt.listOf((Object[])doorTargetArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/lib/annotationprocessor/core/DoorJdbcProcessor$Companion;", "", "()V", "JDBC_TARGETS", "", "Lcom/ustadmobile/lib/annotationprocessor/core/DoorTarget;", "getJDBC_TARGETS", "()Ljava/util/List;", "SUFFIX_JDBC_IMPL", "", "SUFFIX_JS_IMPLEMENTATION_CLASSES", "TRIGGER_TEMPLATE_NEW_ETAG_NOT_EQUAL_TO_EXISTING", "TRIGGER_TEMPLATE_NEW_LAST_MODIFIED_GREATER_THAN_EXISTING", "TRIGGER_TEMPLATE_NEW_VALUES", "TRIGGER_TEMPLATE_TABLE_AND_FIELD_NAMES", "door-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DoorTarget> getJDBC_TARGETS() {
            return JDBC_TARGETS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

