/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.annotationprocessor.core;

import androidx.paging.PagingSource;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.ustadmobile.door.jdbc.TypesKmp;
import com.ustadmobile.lib.annotationprocessor.core.DoorJdbcProcessorKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u000e"}, d2={"isNullableAsSelectReturnResult", "", "Lcom/squareup/kotlinpoet/TypeName;", "(Lcom/squareup/kotlinpoet/TypeName;)Z", "defaultTypeValueCode", "Lcom/squareup/kotlinpoet/CodeBlock;", "isArrayType", "isAsynchronousReturnType", "isFlow", "isHttpQueryQueryParam", "isListOrArray", "isPagingSource", "toSqlTypesInt", "", "door-compiler"})
public final class TypeNameExtKt {
    public static final int toSqlTypesInt(@NotNull TypeName $this$toSqlTypesInt) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toSqlTypesInt, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)TypeNames.BOOLEAN)) {
            n = TypesKmp.INSTANCE.getBOOLEAN();
        } else if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)TypeNames.BYTE)) {
            n = TypesKmp.INSTANCE.getSMALLINT();
        } else if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)TypeNames.SHORT)) {
            n = TypesKmp.INSTANCE.getSMALLINT();
        } else if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)TypeNames.INT)) {
            n = TypesKmp.INSTANCE.getINTEGER();
        } else if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)TypeNames.LONG)) {
            n = TypesKmp.INSTANCE.getBIGINT();
        } else if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)TypeNames.FLOAT)) {
            n = TypesKmp.INSTANCE.getFLOAT();
        } else if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)TypeNames.DOUBLE)) {
            n = TypesKmp.INSTANCE.getDOUBLE();
        } else if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class)))) {
            n = TypesKmp.INSTANCE.getLONGVARCHAR();
        } else if (Intrinsics.areEqual((Object)$this$toSqlTypesInt, (Object)TypeName.copy$default((TypeName)((TypeName)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class))), (boolean)true, null, (int)2, null))) {
            n = TypesKmp.INSTANCE.getLONGVARCHAR();
        } else {
            throw new IllegalArgumentException("Could not get sqlTypeInt for: " + $this$toSqlTypesInt);
        }
        return n;
    }

    public static final boolean isPagingSource(@NotNull TypeName $this$isPagingSource) {
        Intrinsics.checkNotNullParameter((Object)$this$isPagingSource, (String)"<this>");
        return $this$isPagingSource instanceof ParameterizedTypeName && Intrinsics.areEqual((Object)((ParameterizedTypeName)$this$isPagingSource).getRawType(), (Object)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(PagingSource.class)));
    }

    public static final boolean isFlow(@NotNull TypeName $this$isFlow) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlow, (String)"<this>");
        return $this$isFlow instanceof ParameterizedTypeName && Intrinsics.areEqual((Object)((ParameterizedTypeName)$this$isFlow).getRawType(), (Object)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Flow.class)));
    }

    public static final boolean isAsynchronousReturnType(@NotNull TypeName $this$isAsynchronousReturnType) {
        Intrinsics.checkNotNullParameter((Object)$this$isAsynchronousReturnType, (String)"<this>");
        return $this$isAsynchronousReturnType instanceof ParameterizedTypeName && (TypeNameExtKt.isPagingSource($this$isAsynchronousReturnType) || TypeNameExtKt.isFlow($this$isAsynchronousReturnType));
    }

    public static final boolean isListOrArray(@NotNull TypeName $this$isListOrArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isListOrArray, (String)"<this>");
        return $this$isListOrArray instanceof ClassName && Intrinsics.areEqual((Object)((ClassName)$this$isListOrArray).getCanonicalName(), (Object)"kotlin.Array") || $this$isListOrArray instanceof ParameterizedTypeName && Intrinsics.areEqual((Object)((ParameterizedTypeName)$this$isListOrArray).getRawType(), (Object)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(List.class)));
    }

    public static final boolean isNullableAsSelectReturnResult(@NotNull TypeName $this$isNullableAsSelectReturnResult) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableAsSelectReturnResult, (String)"<this>");
        return !Intrinsics.areEqual((Object)$this$isNullableAsSelectReturnResult, (Object)TypeNames.UNIT) && !CollectionsKt.contains((Iterable)DoorJdbcProcessorKt.getPRIMITIVE(), (Object)$this$isNullableAsSelectReturnResult) && !($this$isNullableAsSelectReturnResult instanceof ParameterizedTypeName);
    }

    public static final boolean isHttpQueryQueryParam(@NotNull TypeName $this$isHttpQueryQueryParam) {
        Intrinsics.checkNotNullParameter((Object)$this$isHttpQueryQueryParam, (String)"<this>");
        return DoorJdbcProcessorKt.getQUERY_SINGULAR_TYPES().contains($this$isHttpQueryQueryParam) || $this$isHttpQueryQueryParam instanceof ParameterizedTypeName && Intrinsics.areEqual((Object)((ParameterizedTypeName)$this$isHttpQueryQueryParam).getRawType(), (Object)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(List.class))) && DoorJdbcProcessorKt.getQUERY_SINGULAR_TYPES().contains(((ParameterizedTypeName)$this$isHttpQueryQueryParam).getTypeArguments().get(0));
    }

    @NotNull
    public static final CodeBlock defaultTypeValueCode(@NotNull TypeName $this$defaultTypeValueCode) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultTypeValueCode, (String)"<this>");
        CodeBlock.Builder codeBlock = CodeBlock.Companion.builder();
        TypeName kotlinType = DoorJdbcProcessorKt.javaToKotlinType($this$defaultTypeValueCode);
        if (Intrinsics.areEqual((Object)kotlinType, (Object)TypeNames.INT)) {
            codeBlock.add("0", new Object[0]);
        } else if (Intrinsics.areEqual((Object)kotlinType, (Object)TypeNames.LONG)) {
            codeBlock.add("0L", new Object[0]);
        } else if (Intrinsics.areEqual((Object)kotlinType, (Object)TypeNames.BYTE)) {
            codeBlock.add("0.toByte()", new Object[0]);
        } else if (Intrinsics.areEqual((Object)kotlinType, (Object)TypeNames.FLOAT)) {
            codeBlock.add("0.toFloat()", new Object[0]);
        } else if (Intrinsics.areEqual((Object)kotlinType, (Object)TypeNames.DOUBLE)) {
            codeBlock.add("0.toDouble()", new Object[0]);
        } else if (Intrinsics.areEqual((Object)kotlinType, (Object)TypeNames.BOOLEAN)) {
            codeBlock.add("false", new Object[0]);
        } else if (Intrinsics.areEqual((Object)kotlinType, (Object)TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class)))) {
            codeBlock.add("null as String?", new Object[0]);
        } else if (kotlinType instanceof ParameterizedTypeName && Intrinsics.areEqual((Object)((ParameterizedTypeName)kotlinType).getRawType(), (Object)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(List.class)))) {
            Object[] objectArray = new Object[]{((ParameterizedTypeName)kotlinType).getTypeArguments().get(0)};
            codeBlock.add("mutableListOf<%T>()", objectArray);
        } else {
            Object[] objectArray = new Object[]{$this$defaultTypeValueCode};
            codeBlock.add("null as %T?", objectArray);
        }
        return codeBlock.build();
    }

    public static final boolean isArrayType(@NotNull TypeName $this$isArrayType) {
        Intrinsics.checkNotNullParameter((Object)$this$isArrayType, (String)"<this>");
        return $this$isArrayType instanceof ParameterizedTypeName && Intrinsics.areEqual((Object)((ParameterizedTypeName)$this$isArrayType).getRawType().getCanonicalName(), (Object)"kotlin.Array");
    }
}

