package com.ustadmobile.door.annotation

/**
 * Indicates that the given field (must be a string) contains the MD5 for the attachment. The MD5
 * sum is used as a 'token' by the endpoint to verify that the client has sufficient privileges
 * to access the data itself.
 *
 * This field will be controlled by code generated by Door.
 *
 * This annotated field itself must be a string and will be set to the MD5 hex.
 */
@Retention(AnnotationRetention.BINARY)
@Target(AnnotationTarget.FIELD)
annotation class AttachmentMd5()
