package androidx.room

/**
 * Marks a field in an [Entity] as the primary key.
 *
 *
 * If you would like to define a composite primary key, you should use [Entity.primaryKeys]
 * method.
 *
 *
 * Each [Entity] must declare a primary key unless one of its super classes declares a
 * primary key. If both an [Entity] and its super class defines a `PrimaryKey`, the
 * child's `PrimaryKey` definition will override the parent's `PrimaryKey`.
 *
 *
 * If `PrimaryKey` annotation is used on a [Embedded]d field, all columns inherited
 * from that embedded field becomes the composite primary key (including its grand children
 * fields).
 */
@Target(AnnotationTarget.FIELD, AnnotationTarget.FUNCTION, AnnotationTarget.PROPERTY_GETTER, AnnotationTarget.PROPERTY_SETTER)
@Retention(AnnotationRetention.RUNTIME)
annotation class PrimaryKey(
        /**
         * Set to true to let SQLite generate the unique id.
         *
         *
         * When set to `true`, the SQLite type affinity for the field should be `INTEGER`.
         *
         *
         * If the field type is `long` or `int` (or its TypeConverter converts it to a
         * `long` or `int`), [Insert] methods treat `0` as not-set while
         * inserting the item.
         *
         *
         * If the field's type is [Integer] or [Long] (or its TypeConverter converts it to
         * an [Integer] or a [Long]), [Insert] methods treat `null` as
         * not-set while inserting the item.
         *
         * @return Whether the primary key should be auto-generated by SQLite or not. Defaults
         * to false.
         */
        val autoGenerate: Boolean = false)