/*
 * Decompiled with CFR 0.152.
 */
package org.kmp.dom;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kmp.dom.KMPElement;
import org.kmp.dom.KMPNode;
import org.kmp.io.KMPPullParser;
import org.kmp.io.KMPSerializerParser;
import org.kmp.io.KMPXmlParser;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/kmp/dom/KMPDocument;", "Lorg/kmp/dom/KMPNode;", "()V", "encoding", "", "name", "getName", "()Ljava/lang/String;", "rootElement", "Lorg/kmp/dom/KMPElement;", "getRootElement", "()Lorg/kmp/dom/KMPElement;", "rootIndex", "", "standalone", "", "getStandalone", "()Ljava/lang/Boolean;", "setStandalone", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "addChild", "", "index", "type", "child", "", "parse", "parser", "Lorg/kmp/io/KMPXmlParser;", "removeChild", "idx", "write", "writer", "Lorg/kmp/io/KMPSerializerParser;", "kmpxmlpullparser"})
public final class KMPDocument
extends KMPNode {
    private int rootIndex = -1;
    private String encoding;
    @Nullable
    private Boolean standalone;

    @Nullable
    public final Boolean getStandalone() {
        return this.standalone;
    }

    public final void setStandalone(@Nullable Boolean bl) {
        this.standalone = bl;
    }

    @NotNull
    public final String getName() {
        return "#document";
    }

    @NotNull
    public final KMPElement getRootElement() {
        if (this.rootIndex == -1) {
            throw (Throwable)new RuntimeException("Document has no root element!");
        }
        Object object = this.getChild(this.rootIndex);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.kmp.dom.KMPElement");
        }
        return (KMPElement)object;
    }

    @Override
    public void addChild(int index, int type, @Nullable Object child) {
        if (type == KMPNode.Companion.getELEMENT()) {
            this.rootIndex = index;
        } else if (this.rootIndex >= index) {
            int n = this.rootIndex;
            this.rootIndex = n + 1;
        }
        super.addChild(index, type, child);
    }

    @Override
    public void parse(@NotNull KMPXmlParser parser) {
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        parser.require(KMPPullParser.Companion.getSTART_DOCUMENT(), null, null);
        parser.nextToken();
        String string = parser.getInputEncoding();
        if (string == null) {
            string = "";
        }
        this.encoding = string;
        this.standalone = (Boolean)parser.getProperty("http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone");
        super.parse(parser);
        if (parser.getEventType() != KMPPullParser.Companion.getEND_DOCUMENT()) {
            throw (Throwable)new RuntimeException("Document end expected!");
        }
    }

    @Override
    public void removeChild(int idx) {
        if (idx == this.rootIndex) {
            this.rootIndex = -1;
        } else if (idx < this.rootIndex) {
            int n = this.rootIndex;
            this.rootIndex = n + -1;
        }
        super.removeChild(idx);
    }

    @Override
    public void write(@NotNull KMPSerializerParser writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        String string = this.encoding;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"encoding");
        }
        writer.startDocument(string, this.standalone);
        this.writeChildren(writer);
        writer.endDocument();
    }
}

