/*
 * Decompiled with CFR 0.152.
 */
package org.kmp.dom;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kmp.dom.KMPElement;
import org.kmp.io.KMPPullParser;
import org.kmp.io.KMPSerializerParser;
import org.kmp.io.KMPXmlParser;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u000e\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u0004J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J \u0010\"\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u0004H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.H\u0016J\u000e\u0010/\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u00061"}, d2={"Lorg/kmp/dom/KMPNode;", "", "()V", "childCount", "", "getChildCount", "()I", "children", "", "getChildren$kmpxmlpullparser", "()Ljava/util/List;", "setChildren$kmpxmlpullparser", "(Ljava/util/List;)V", "types", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTypes", "()Ljava/lang/StringBuilder;", "setTypes", "(Ljava/lang/StringBuilder;)V", "addChild", "", "type", "child", "index", "createElement", "Lorg/kmp/dom/KMPElement;", "namespace", "", "name", "getChild", "getElement", "getText", "getType", "indexOf", "startIndex", "isText", "", "i", "parse", "parser", "Lorg/kmp/io/KMPXmlParser;", "removeChild", "idx", "write", "writer", "Lorg/kmp/io/KMPSerializerParser;", "writeChildren", "Companion", "kmpxmlpullparser"})
public class KMPNode {
    @Nullable
    private List<Object> children;
    @NotNull
    private StringBuilder types = new StringBuilder();
    private static final int DOCUMENT = 0;
    private static final int ELEMENT = 2;
    private static final int TEXT = 4;
    private static final int CDSECT = 5;
    private static final int ENTITY_REF = 6;
    private static final int IGNORABLE_WHITESPACE = 7;
    private static final int PROCESSING_INSTRUCTION = 8;
    private static final int COMMENT = 9;
    private static final int DOCDECL = 10;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final List<Object> getChildren$kmpxmlpullparser() {
        return this.children;
    }

    public final void setChildren$kmpxmlpullparser(@Nullable List<Object> list) {
        this.children = list;
    }

    @NotNull
    protected final StringBuilder getTypes() {
        return this.types;
    }

    protected final void setTypes(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)stringBuilder, (String)"<set-?>");
        this.types = stringBuilder;
    }

    public final int getChildCount() {
        int n;
        if (this.children == null) {
            n = 0;
        } else {
            List<Object> list = this.children;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            n = list.size();
        }
        return n;
    }

    public void addChild(int index, int type, @Nullable Object child) {
        if (child == null) {
            throw (Throwable)new NullPointerException();
        }
        if (this.children == null) {
            List list;
            KMPNode kMPNode = this;
            boolean bl = false;
            kMPNode.children = list = (List)new ArrayList();
            this.types = new StringBuilder();
        }
        if (type == ELEMENT) {
            if (!(child instanceof KMPElement)) {
                throw (Throwable)new RuntimeException("Element obj expected)");
            }
            ((KMPElement)child).setParent$kmpxmlpullparser(this);
        } else if (!(child instanceof String)) {
            throw (Throwable)new RuntimeException("String expected");
        }
        List<Object> list = this.children;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        list.add(index, child);
        StringsKt.append((StringBuilder)this.types, (Object[])new Object[]{index, Character.valueOf((char)type)});
    }

    public final void addChild(int type, @Nullable Object child) {
        this.addChild(this.getChildCount(), type, child);
    }

    @NotNull
    public KMPElement createElement(@Nullable String namespace, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        KMPElement e = new KMPElement();
        String string = namespace;
        if (string == null) {
            string = KMPPullParser.Companion.getNO_NAMESPACE();
        }
        e.setNamespace$kmpxmlpullparser(string);
        e.setName(name);
        return e;
    }

    @NotNull
    public final Object getChild(int index) {
        List<Object> list = this.children;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        List<Object> list2 = list;
        boolean bl = false;
        return list2.get(index);
    }

    @Nullable
    public final KMPElement getElement(int index) {
        Object child = this.getChild(index);
        return child instanceof KMPElement ? (KMPElement)child : null;
    }

    @Nullable
    public final KMPElement getElement(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        int i = this.indexOf(namespace, name, 0);
        int j = this.indexOf(namespace, name, i + 1);
        if (i == -1 || j != -1) {
            throw (Throwable)new RuntimeException("Element {" + namespace + "}" + name + (i == -1 ? " not found in " : " more than once in ") + this);
        }
        return this.getElement(i);
    }

    @Nullable
    public final String getText(int index) {
        String string;
        if (this.isText(index)) {
            Object object = this.getChild(index);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            string = (String)object;
        } else {
            string = null;
        }
        return string;
    }

    public final int getType(int index) {
        return this.types.charAt(index);
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(@Nullable String namespace, @NotNull String name, int startIndex) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        int len = this.getChildCount();
        int n = startIndex;
        int n2 = len;
        while (n < n2) {
            void i;
            KMPElement child = this.getElement((int)i);
            if (child != null && Intrinsics.areEqual((Object)name, (Object)child.getName()) && (namespace == null || Intrinsics.areEqual((Object)namespace, (Object)child.getNamespace()))) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public final boolean isText(int i) {
        int t = this.getType(i);
        return t == TEXT || t == IGNORABLE_WHITESPACE || t == CDSECT;
    }

    public void parse(@NotNull KMPXmlParser parser) {
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        boolean leave = false;
        do {
            int type;
            int n;
            if ((n = (type = parser.getEventType())) == KMPPullParser.Companion.getSTART_TAG()) {
                String string = parser.getNamespace();
                String string2 = parser.getName();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                KMPElement child = this.createElement(string, string2);
                this.addChild(ELEMENT, child);
                child.parse(parser);
                continue;
            }
            if (n == KMPPullParser.Companion.getEND_DOCUMENT() || n == KMPPullParser.Companion.getEND_TAG()) {
                leave = true;
                continue;
            }
            if (parser.getText() != null) {
                this.addChild(type == KMPPullParser.Companion.getENTITY_REF() ? TEXT : type, parser.getText());
            } else if (type == KMPPullParser.Companion.getENTITY_REF() && parser.getName() != null) {
                this.addChild(ENTITY_REF, parser.getName());
            }
            parser.nextToken();
        } while (!leave);
    }

    /*
     * WARNING - void declaration
     */
    public void removeChild(int idx) {
        List<Object> list = this.children;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        list.remove(idx);
        int n = this.types.length() - 1;
        int n2 = idx;
        int n3 = n;
        while (n2 < n3) {
            void i;
            StringsKt.append((StringBuilder)this.types, (Object[])new Object[]{(int)i, Character.valueOf(this.types.charAt((int)(i + true)))});
            ++i;
        }
    }

    public void write(@NotNull KMPSerializerParser writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.writeChildren(writer);
        writer.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void writeChildren(@NotNull KMPSerializerParser writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        if (this.children == null) {
            return;
        }
        List<Object> list = this.children;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        int len = list.size();
        int n = 0;
        int n2 = len;
        while (n < n2) {
            List<Object> list2;
            void i;
            int type = this.getType((int)i);
            if (this.children == null) {
                Intrinsics.throwNpe();
            }
            boolean bl = false;
            Object child = list2.get((int)i);
            int n3 = type;
            if (n3 == ELEMENT) {
                Object object = child;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.kmp.dom.KMPElement");
                }
                ((KMPElement)object).write(writer);
            } else if (n3 == TEXT) {
                Object object = child;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.text((String)object);
            } else if (n3 == IGNORABLE_WHITESPACE) {
                Object object = child;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.ignorableWhitespace((String)object);
            } else if (n3 == CDSECT) {
                Object object = child;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.cdsect((String)object);
            } else if (n3 == COMMENT) {
                Object object = child;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.comment((String)object);
            } else if (n3 == ENTITY_REF) {
                Object object = child;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.entityRef((String)object);
            } else if (n3 == PROCESSING_INSTRUCTION) {
                Object object = child;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.processingInstruction((String)object);
            } else if (n3 == DOCDECL) {
                Object object = child;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.docdecl((String)object);
            } else {
                throw (Throwable)new RuntimeException("Illegal type: " + type);
            }
            ++i;
        }
    }

    static {
        ELEMENT = 2;
        TEXT = 4;
        CDSECT = 5;
        ENTITY_REF = 6;
        IGNORABLE_WHITESPACE = 7;
        PROCESSING_INSTRUCTION = 8;
        COMMENT = 9;
        DOCDECL = 10;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/kmp/dom/KMPNode$Companion;", "", "()V", "CDSECT", "", "getCDSECT", "()I", "COMMENT", "getCOMMENT", "DOCDECL", "getDOCDECL", "DOCUMENT", "getDOCUMENT", "ELEMENT", "getELEMENT", "ENTITY_REF", "getENTITY_REF", "IGNORABLE_WHITESPACE", "getIGNORABLE_WHITESPACE", "PROCESSING_INSTRUCTION", "getPROCESSING_INSTRUCTION", "TEXT", "getTEXT", "kmpxmlpullparser"})
    public static final class Companion {
        public final int getDOCUMENT() {
            return DOCUMENT;
        }

        public final int getELEMENT() {
            return ELEMENT;
        }

        public final int getTEXT() {
            return TEXT;
        }

        public final int getCDSECT() {
            return CDSECT;
        }

        public final int getENTITY_REF() {
            return ENTITY_REF;
        }

        public final int getIGNORABLE_WHITESPACE() {
            return IGNORABLE_WHITESPACE;
        }

        public final int getPROCESSING_INSTRUCTION() {
            return PROCESSING_INSTRUCTION;
        }

        public final int getCOMMENT() {
            return COMMENT;
        }

        public final int getDOCDECL() {
            return DOCDECL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

