/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.model.XapiAgentManager;
import com.ustadmobile.nanolrs.core.model.XapiAgentProxy;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

public class XapiAgentEndpoint {
    public static XapiAgentProxy createOrUpdate(Object dbContext, JSONObject agentJSON) {
        XapiAgentManager manager;
        List<XapiAgentProxy> matchingAgents;
        String mbox = agentJSON.optString("mbox", null);
        String accountHomepage = null;
        String accountName = null;
        if (agentJSON.has("account")) {
            JSONObject accountObj = agentJSON.getJSONObject("account");
            accountHomepage = accountObj.getString("homePage");
            accountName = accountObj.getString("name");
        }
        if ((matchingAgents = (manager = PersistenceManager.getInstance().getAgentManager()).findAgentByParams(dbContext, mbox, accountName, accountHomepage)) != null && matchingAgents.size() > 0) {
            return matchingAgents.get(0);
        }
        XapiAgentProxy agent = manager.makeNew(dbContext);
        agent.setId(UUID.randomUUID().toString());
        agent.setMbox(mbox);
        agent.setAccountHomepage(accountHomepage);
        agent.setAccountName(accountName);
        manager.createOrUpdate(dbContext, agent);
        return agent;
    }

    public static XapiAgentProxy makeFromJson(Object dbContext, JSONObject agentJson) {
        return null;
    }
}

