/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.endpoints.XapiActivityEndpoint;
import com.ustadmobile.nanolrs.core.endpoints.XapiAgentEndpoint;
import com.ustadmobile.nanolrs.core.model.XapiActivityProxy;
import com.ustadmobile.nanolrs.core.model.XapiAgentProxy;
import com.ustadmobile.nanolrs.core.model.XapiStateManager;
import com.ustadmobile.nanolrs.core.model.XapiStateProxy;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.util.JsonUtil;
import java.io.IOException;
import java.util.UUID;
import org.json.JSONObject;

public class XapiStateEndpoint {
    public static XapiStateProxy createOrUpdateState(Object dbContext, String method, String contentType, String activityId, String agentJson, String registration, String stateId, byte[] stateContent) {
        XapiStateProxy state;
        JSONObject agentJsonObj = new JSONObject(agentJson);
        XapiAgentProxy agent = XapiAgentEndpoint.createOrUpdate(dbContext, agentJsonObj);
        JSONObject activityObj = new JSONObject();
        activityObj.put("id", (Object)activityId);
        XapiStateManager manager = PersistenceManager.getInstance().getStateManager();
        String agentMbox = agentJsonObj.optString("mbox", null);
        String agentAccountName = null;
        String agentAccountHopmepage = null;
        if (agentJsonObj.has("account")) {
            agentAccountName = agentJsonObj.getJSONObject("account").getString("name");
            agentAccountHopmepage = agentJsonObj.getJSONObject("account").getString("homePage");
        }
        if ((state = manager.findByActivityAndAgent(dbContext, activityId, agentMbox, agentAccountName, agentAccountHopmepage, registration, stateId)) == null) {
            state = manager.makeNew(dbContext);
            state.setId(UUID.randomUUID().toString());
            XapiActivityProxy activity = XapiActivityEndpoint.createOrUpdate(dbContext, activityId);
            state.setActivity(activity);
            state.setAgent(agent);
            state.setStateId(stateId);
            state.setRegistration(registration);
        }
        byte[] existingContent = state.getContent();
        if (contentType != null) {
            state.setContentType(contentType);
        }
        if (contentType != null && contentType.equals("application/json") && method.equalsIgnoreCase("post") && existingContent != null) {
            try {
                JSONObject existingJson = new JSONObject(new String(existingContent, "UTF-8"));
                JSONObject updatedJson = new JSONObject(new String(stateContent, "UTF-8"));
                JsonUtil.mergeJson(updatedJson, existingJson);
            }
            catch (IOException e) {
                System.err.println("Exception in createOrUpdateState JSON Merge");
                e.printStackTrace();
            }
        } else {
            state.setContent(stateContent);
        }
        manager.persist(dbContext, state);
        return state;
    }

    public static XapiStateProxy getState(Object dbContext, String activityId, String agentJson, String registration, String stateId) {
        JSONObject agentObject = new JSONObject(agentJson);
        JSONObject agentAccount = agentObject.optJSONObject("account");
        XapiStateManager manager = PersistenceManager.getInstance().getStateManager();
        XapiStateProxy stateProxy = manager.findByActivityAndAgent(dbContext, activityId, agentObject.optString("mbox", null), agentAccount != null ? agentAccount.optString("name", null) : null, agentAccount != null ? agentAccount.optString("homePage", null) : null, registration, stateId);
        return stateProxy;
    }
}

