/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.model.XapiStatementProxy;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.util.ParseUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.json.JSONObject;

public class XapiStatementsEndpoint {
    public static String putStatement(JSONObject stmt, Object dbContext) {
        XapiStatementProxy stmtProxy = PersistenceManager.getInstance().getStatementManager().createSync(dbContext);
        if (stmt.has("id")) {
            stmtProxy.setId(stmt.getString("id"));
        } else {
            stmtProxy.setId(UUID.randomUUID().toString());
            stmt.put("id", (Object)stmtProxy.getId());
        }
        if (stmt.has("timestamp")) {
            Calendar cal = ParseUtil.parse8601Timestamp(stmt.getString("timestamp"));
            stmtProxy.setTimestamp(cal.getTime().getTime());
        } else {
            stmtProxy.setTimestamp(new Date().getTime());
        }
        stmtProxy.setFullStatement(stmt.toString());
        PersistenceManager.getInstance().getStatementManager().persistSync(dbContext, stmtProxy);
        return stmtProxy.getId();
    }
}

