/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.http;

import com.ustadmobile.nanolrs.core.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.UUID;
import org.json.JSONObject;

public class HttpLrs {
    private String endpoint;

    public HttpLrs(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LrsResponse saveState(String method, String httpUsername, String httpPassword, String activityId, String agentJson, String registration, String stateId, String contentType, byte[] content) {
        LrsResponse response = new LrsResponse();
        String destURL = this.makeStateURL(this.endpoint, activityId, agentJson, registration, stateId);
        HttpURLConnection con = null;
        OutputStream out = null;
        try {
            URL url = new URL(destURL);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(method.toUpperCase());
            con.setFixedLengthStreamingMode(content.length);
            con.setDoOutput(true);
            this.setXapiHeaders(con, httpUsername, httpPassword);
            if (contentType != null) {
                con.setRequestProperty("Content-Type", contentType);
            }
            out = con.getOutputStream();
            out.write(content);
            out.flush();
            out.close();
            out = null;
            int statusCode = con.getResponseCode();
            response.setStatus(statusCode);
        }
        catch (IOException e) {
            System.err.println("saveState Exception");
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (con != null) {
                con.disconnect();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LrsResponse loadState(String httpUsername, String httpPassword, String activityId, String agentJson, String registration, String stateId) {
        LrsResponse response = new LrsResponse();
        String destURL = this.makeStateURL(this.endpoint, activityId, agentJson, registration, stateId);
        HttpURLConnection connection = null;
        InputStream in = null;
        try {
            int bytesRead;
            URL url = new URL(destURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            this.setXapiHeaders(connection, httpUsername, httpPassword);
            response.setStatus(connection.getResponseCode());
            in = response.getStatus() >= 200 && response.getStatus() <= 300 ? connection.getInputStream() : connection.getErrorStream();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((bytesRead = in.read(buf)) != -1) {
                bout.write(buf, 0, bytesRead);
            }
            bout.flush();
            response.setServerResponse(bout.toByteArray());
        }
        catch (IOException e) {
            System.err.println("Exception loading state");
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    private String makeStateURL(String xapiBaseURL, String activityId, String agentJson, String registration, String stateId) {
        String destURL = xapiBaseURL;
        if (!destURL.endsWith("/")) {
            destURL = destURL + "/";
        }
        try {
            destURL = destURL + "activities/state";
            destURL = destURL + "?activityid=" + URLEncoder.encode(activityId, "UTF-8");
            destURL = destURL + "&agent=" + URLEncoder.encode(agentJson, "UTF-8");
            if (registration != null) {
                destURL = destURL + "&registration=" + registration;
            }
            destURL = destURL + "&stateid=" + stateId;
            return destURL;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void setXapiHeaders(HttpURLConnection connection, String httpUsername, String httpPassword) throws IOException {
        connection.setRequestProperty("X-Experience-API-Version", "1.0.1");
        connection.setRequestProperty("Authorization", "Basic " + Base64Coder.encodeString(httpUsername + ":" + httpPassword));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LrsResponse putStatement(JSONObject stmt, String httpUsername, String httpPassword) {
        HttpURLConnection connection = null;
        String destURL = this.endpoint;
        LrsResponse response = new LrsResponse();
        try {
            if (!destURL.endsWith("/")) {
                destURL = destURL + "/";
            }
            if (!stmt.has("id")) {
                stmt.put("id", (Object)UUID.randomUUID().toString());
            }
            destURL = destURL + "statements?statementId=" + stmt.getString("id");
            URL url = new URL(destURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            byte[] payload = stmt.toString().getBytes();
            connection.setFixedLengthStreamingMode(payload.length);
            connection.setDoOutput(true);
            this.setXapiHeaders(connection, httpUsername, httpPassword);
            connection.setRequestProperty("Accept", "*/*");
            connection.setRequestProperty("Content-Type", "application/json");
            OutputStream out = connection.getOutputStream();
            out.write(payload);
            out.flush();
            out.close();
            out = null;
            int statusCode = connection.getResponseCode();
            response.setStatus(statusCode);
            if (statusCode >= 400) {
                InputStream errorStream = connection.getErrorStream();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int bytesRead = 0;
                while ((bytesRead = errorStream.read(buf)) != -1) {
                    bout.write(buf, 0, bytesRead);
                }
                response.setServerResponse(bout.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    public static class LrsResponse {
        private int status;
        private Exception exception;
        private byte[] serverResponse;

        public void setStatus(int status) {
            this.status = status;
        }

        public String getServerResponseAsString() {
            try {
                return new String(this.serverResponse, "UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] getServerResponse() {
            return this.serverResponse;
        }

        public void setServerResponse(byte[] serverResponse) {
            this.serverResponse = serverResponse;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

