/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.endpoints.XapiStatementsEndpoint;
import com.ustadmobile.nanolrs.core.model.XapiForwardingStatementManager;
import com.ustadmobile.nanolrs.core.model.XapiForwardingStatementProxy;
import com.ustadmobile.nanolrs.core.model.XapiStatementProxy;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class XapiStatementsForwardingEndpoint {
    public static final String LOGTAG = "XapiStatementsForwardingEndpoint";

    public static void putAndQueueStatement(Object dbContext, JSONObject statement, String destinationURL, String httpUser, String httpPassword) {
        String uuid = XapiStatementsEndpoint.putStatement(statement, dbContext);
        XapiStatementProxy statementProxy = PersistenceManager.getInstance().getStatementManager().findByUuidSync(dbContext, uuid);
        XapiStatementsForwardingEndpoint.queueStatement(dbContext, statementProxy, destinationURL, httpUser, httpPassword);
    }

    public static void queueStatement(Object dbContext, XapiStatementProxy statement, String destinationURL, String httpUser, String httpPassword) {
        XapiForwardingStatementManager manager = PersistenceManager.getInstance().getForwardingStatementManager();
        XapiForwardingStatementProxy fwdStmt = manager.createSync(dbContext, statement.getId());
        fwdStmt.setDestinationURL(destinationURL);
        fwdStmt.setHttpAuthUser(httpUser);
        fwdStmt.setHttpAuthPassword(httpPassword);
        fwdStmt.setStatement(statement);
        fwdStmt.setStatus(1);
        manager.persistSync(dbContext, fwdStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendQueue(Object dbContext) {
        XapiForwardingStatementManager manager = PersistenceManager.getInstance().getForwardingStatementManager();
        List<XapiForwardingStatementProxy> toForward = manager.getAllUnsentStatementsSync(dbContext);
        for (XapiForwardingStatementProxy stmt : toForward) {
            HttpURLConnection connection = null;
            String destURL = stmt.getDestinationURL();
            try {
                if (!destURL.endsWith("/")) {
                    destURL = destURL + "/";
                }
                destURL = destURL + "statements?statementId=" + stmt.getStatement().getId();
                URL url = new URL(destURL);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("PUT");
                byte[] payload = stmt.getStatement().getFullStatement().getBytes();
                connection.setFixedLengthStreamingMode(payload.length);
                connection.setDoOutput(true);
                connection.setRequestProperty("X-Experience-API-Version", "1.0.1");
                connection.setRequestProperty("Authorization", "Basic " + Base64Coder.encodeString(stmt.getHttpAuthUser() + ":" + stmt.getHttpAuthPassword()));
                connection.setRequestProperty("Accept", "*/*");
                connection.setRequestProperty("Content-Type", "application/json");
                OutputStream out = connection.getOutputStream();
                out.write(payload);
                out.flush();
                out.close();
                out = null;
                int statusCode = connection.getResponseCode();
                String serverSays = null;
                if (statusCode >= 400) {
                    InputStream errorStream = connection.getErrorStream();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    int bytesRead = 0;
                    while ((bytesRead = errorStream.read(buf)) != -1) {
                        bout.write(buf, 0, bytesRead);
                    }
                    serverSays = new String(bout.toByteArray());
                }
                if (statusCode == 204) {
                    stmt.setStatus(3);
                    stmt.setHttpAuthUser(null);
                    stmt.setHttpAuthPassword(null);
                } else {
                    stmt.setStatus(2);
                    stmt.setTryCount(stmt.getTryCount() + 1);
                }
                manager.persistSync(dbContext, stmt);
            }
            catch (IOException e) {
                Logger.getLogger(LOGTAG).log(Level.WARNING, "Exception sending statement", e);
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
    }
}

