/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core;

import com.ustadmobile.nanolrs.core.PrimaryKeyAnnotationClass;
import com.ustadmobile.nanolrs.core.mapping.ModelManagerMapping;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.json.JSONObject;

public class ProxyJsonSerializer {
    public static final String PROXY_CLASS_JSON_FIELD = "pCls";

    public static JSONObject toJson(NanoLrsModel object, Class proxyClass) {
        Method[] methods = proxyClass.getMethods();
        JSONObject returnVal = new JSONObject();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            int prefixLen = 0;
            if (methodName.startsWith("is")) {
                prefixLen = 2;
            } else if (methodName.startsWith("get")) {
                prefixLen = 3;
            }
            if (prefixLen == 0) continue;
            String propName = Character.toLowerCase(methodName.charAt(prefixLen)) + methodName.substring(prefixLen + 1);
            Method valGetterMethod = methods[i];
            Object invocationTarget = object;
            if (!methods[i].getReturnType().isPrimitive() && !methods[i].getReturnType().equals(String.class)) {
                try {
                    invocationTarget = methods[i].invoke((Object)object, new Object[0]);
                    Class<?> relatedClass = methods[i].getReturnType();
                    Method[] relatedClassMethods = relatedClass.getMethods();
                    valGetterMethod = null;
                    for (Method relatedMethod : relatedClassMethods) {
                        if (!relatedMethod.isAnnotationPresent(PrimaryKeyAnnotationClass.class)) continue;
                        valGetterMethod = relatedMethod;
                        break;
                    }
                    if (valGetterMethod == null) {
                        throw new RuntimeException("No Primary Key Annotation Class");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Object propValue;
                if (invocationTarget == null || (propValue = valGetterMethod.invoke(invocationTarget, new Object[0])) == null) continue;
                returnVal.put(propName, propValue);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        returnVal.put(PROXY_CLASS_JSON_FIELD, (Object)proxyClass.getName());
        return returnVal;
    }

    /*
     * WARNING - void declaration
     */
    public static NanoLrsModel toEntity(JSONObject entityJSON, Object context) {
        String proxyClassName = entityJSON.getString(PROXY_CLASS_JSON_FIELD);
        Class proxyClass = ModelManagerMapping.proxyNameToClassMap.get(proxyClassName);
        Class managerClass = ModelManagerMapping.proxyClassToManagerMap.get(proxyClass);
        Object manager = PersistenceManager.getInstance().getManager(managerClass);
        NanoLrsModel newObj = null;
        try {
            newObj = (NanoLrsModel)manager.makeNew();
            Iterator keys = entityJSON.keys();
            while (keys.hasNext()) {
                String keyName = (String)keys.next();
                if (keyName.equals(PROXY_CLASS_JSON_FIELD)) continue;
                Object value = entityJSON.get(keyName);
                Class<?> valueType = value.getClass();
                String methodPropName = Character.toUpperCase(keyName.charAt(0)) + keyName.substring(1);
                String methodName = "set" + methodPropName;
                String getterMethodName = (value instanceof Boolean ? "is" : "get") + methodPropName;
                Method getterMethod = proxyClass.getMethod(getterMethodName, new Class[0]);
                if (!getterMethod.getReturnType().isPrimitive() && !getterMethod.getReturnType().equals(String.class)) {
                    Class relatedProxyClass = ModelManagerMapping.proxyNameToClassMap.get(getterMethod.getReturnType().getName());
                    Class realtedManagerClass = ModelManagerMapping.proxyClassToManagerMap.get(relatedProxyClass);
                    Object relatedManager = PersistenceManager.getInstance().getManager(realtedManagerClass);
                    Object entity_id = value;
                    Class<?> relatedObjProxy = getterMethod.getReturnType();
                    Object relatedObj = relatedManager.findByPrimaryKey(context, (Object)value);
                    if (relatedObj == null) {
                        void var21_25;
                        Method[] relatedObjProxyMethods;
                        relatedObj = relatedManager.makeNew();
                        Object var21_23 = null;
                        Object relatedObjProxyPKSetter = null;
                        Object relatedObjEntityPKSetter = null;
                        relatedObj.getClass().getMethods();
                        for (Method everyProxyMethod : relatedObjProxyMethods = relatedObjProxy.getMethods()) {
                            if (!everyProxyMethod.isAnnotationPresent(PrimaryKeyAnnotationClass.class)) continue;
                            Method method = everyProxyMethod;
                            break;
                        }
                        String primaryKeyGetterName = null;
                        String primaryKeySetterName = null;
                        if (var21_25 != null) {
                            primaryKeyGetterName = var21_25.getName();
                            int prefixLen = 0;
                            if (primaryKeyGetterName.startsWith("is")) {
                                prefixLen = 2;
                            } else if (primaryKeyGetterName.startsWith("get")) {
                                prefixLen = 3;
                            }
                            primaryKeySetterName = "set" + Character.toUpperCase(primaryKeyGetterName.charAt(prefixLen)) + primaryKeyGetterName.substring(prefixLen + 1);
                            Method relatedObjPKMethod = relatedObj.getClass().getMethod(primaryKeySetterName, entity_id.getClass());
                            relatedObjPKMethod.invoke(relatedObj, value);
                            valueType = relatedObjProxy;
                        }
                    }
                    value = relatedObj;
                }
                Method[] methods = proxyClass.getMethods();
                Class<?> methodReturnType = null;
                Class<?> methodReturnClass = null;
                Object methodReturnClassClass = null;
                Object methodReturnTypeName = null;
                Object valueCasted = null;
                for (Method method : methods) {
                    if (!method.getName().equals(methodName)) continue;
                    methodReturnClass = methodReturnType = method.getParameterTypes()[0];
                    break;
                }
                if (methodReturnType == null) continue;
                valueCasted = methodReturnClass.getName().equals("long") ? Long.valueOf(Long.parseLong(value.toString())) : (methodReturnClass.getName().equals("float") ? Float.valueOf(Float.parseFloat(value.toString())) : (methodReturnClass.getName().equals("int") ? Integer.valueOf(Integer.parseInt(value.toString())) : (methodReturnClass.getName().equals("double") ? Double.valueOf(Double.parseDouble(value.toString())) : (methodReturnClass.getName().equals("short") ? Short.valueOf(Short.parseShort(value.toString())) : (methodReturnClass.getName().equals("char") ? Character.valueOf(value.toString().charAt(0)) : (methodReturnClass.getName().equals("boolean") ? Boolean.valueOf(Boolean.parseBoolean(value.toString())) : value))))));
                Method method = proxyClass.getMethod(methodName, methodReturnClass);
                String setterMethodName = method.getName();
                method.invoke(newObj, valueCasted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newObj;
    }
}

