/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.manager.XapiActivityManager;
import com.ustadmobile.nanolrs.core.model.XapiActivity;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.util.JsonUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class XapiActivityEndpoint {
    public static XapiActivity createOrUpdate(Object dbContext, JSONObject object) {
        XapiActivityManager manager = PersistenceManager.getInstance().getManager(XapiActivityManager.class);
        try {
            String jsonDef;
            String activityId = object.getString("id");
            XapiActivity data = manager.findByActivityId(dbContext, activityId);
            if (data == null) {
                data = manager.makeNew(dbContext);
                data.setActivityId(activityId);
            }
            JSONObject storedObject = (jsonDef = data.getCanonicalData()) == null ? new JSONObject() : new JSONObject(jsonDef);
            JsonUtil.mergeJson(object, storedObject);
            data.setCanonicalData(storedObject.toString());
            manager.createOrUpdate(dbContext, data);
            return data;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("No id in activity JSON object", e);
        }
    }

    public static XapiActivity createOrUpdate(Object dbContext, String activityId) {
        try {
            JSONObject activityObj = new JSONObject();
            activityObj.put("id", (Object)activityId);
            return XapiActivityEndpoint.createOrUpdate(dbContext, activityObj);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

