/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class XapiAgentEndpoint {
    public static XapiAgent createOrUpdate(Object dbContext, JSONObject agentJSON) {
        try {
            String mbox = agentJSON.optString("mbox", null);
            String accountHomepage = null;
            String accountName = null;
            if (agentJSON.has("account")) {
                JSONObject accountObj = agentJSON.getJSONObject("account");
                accountHomepage = accountObj.getString("homePage");
                accountName = accountObj.getString("name");
            }
            return XapiAgentEndpoint.createOrUpdate(dbContext, mbox, accountName, accountHomepage);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid Agent JSON supplied", e);
        }
    }

    public static XapiAgent createOrUpdate(Object dbContext, String mbox, String accountName, String accountHomepage) {
        User agentUser;
        XapiAgentManager manager = PersistenceManager.getInstance().getManager(XapiAgentManager.class);
        UserManager userManager = PersistenceManager.getInstance().getManager(UserManager.class);
        List<XapiAgent> matchingAgents = manager.findAgentByParams(dbContext, mbox, accountName, accountHomepage);
        if (matchingAgents != null && matchingAgents.size() > 0) {
            User agentUser2;
            XapiAgent mappedAgent = matchingAgents.get(0);
            if (mappedAgent.getUser() == null && (agentUser2 = userManager.findById(dbContext, accountName)) != null) {
                mappedAgent.setUser(agentUser2);
                manager.createOrUpdate(dbContext, mappedAgent);
            }
            return matchingAgents.get(0);
        }
        XapiAgent agent = manager.makeNew(dbContext);
        agent.setUuid(UUID.randomUUID().toString());
        agent.setMbox(mbox);
        agent.setAccountHomepage(accountHomepage);
        agent.setAccountName(accountName);
        if (accountName != null && (agentUser = userManager.findById(dbContext, accountName)) != null) {
            agent.setUser(agentUser);
        }
        manager.createOrUpdate(dbContext, agent);
        return agent;
    }

    public static XapiAgent makeFromJson(Object dbContext, JSONObject agentJson) {
        return null;
    }
}

