/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.endpoints.XapiActivityEndpoint;
import com.ustadmobile.nanolrs.core.endpoints.XapiAgentEndpoint;
import com.ustadmobile.nanolrs.core.manager.XapiStateManager;
import com.ustadmobile.nanolrs.core.model.XapiActivity;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.model.XapiState;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.util.JsonUtil;
import java.io.IOException;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class XapiStateEndpoint {
    public static XapiState createOrUpdateState(Object dbContext, String method, String contentType, String activityId, String agentJson, String registration, String stateId, byte[] stateContent) {
        try {
            XapiState state;
            JSONObject agentJsonObj = new JSONObject(agentJson);
            XapiAgent agent = XapiAgentEndpoint.createOrUpdate(dbContext, agentJsonObj);
            JSONObject activityObj = new JSONObject();
            activityObj.put("id", (Object)activityId);
            XapiStateManager manager = PersistenceManager.getInstance().getManager(XapiStateManager.class);
            String agentMbox = agentJsonObj.optString("mbox", null);
            String agentAccountName = null;
            String agentAccountHopmepage = null;
            if (agentJsonObj.has("account")) {
                agentAccountName = agentJsonObj.getJSONObject("account").getString("name");
                agentAccountHopmepage = agentJsonObj.getJSONObject("account").getString("homePage");
            }
            if ((state = manager.findByActivityAndAgent(dbContext, activityId, agentMbox, agentAccountName, agentAccountHopmepage, registration, stateId)) == null) {
                state = manager.makeNew(dbContext);
                state.setUuid(UUID.randomUUID().toString());
                XapiActivity activity = XapiActivityEndpoint.createOrUpdate(dbContext, activityId);
                state.setActivity(activity);
                state.setAgent(agent);
                state.setStateId(stateId);
                state.setRegistration(registration);
            }
            byte[] existingContent = state.getContent();
            if (contentType != null) {
                state.setContentType(contentType);
            }
            if (contentType != null && contentType.equals("application/json") && method.equalsIgnoreCase("post") && existingContent != null) {
                try {
                    JSONObject existingJson = new JSONObject(new String(existingContent, "UTF-8"));
                    JSONObject updatedJson = new JSONObject(new String(stateContent, "UTF-8"));
                    JsonUtil.mergeJson(updatedJson, existingJson);
                    stateContent = existingJson.toString().getBytes("UTF-8");
                }
                catch (IOException | JSONException e) {
                    System.err.println("Exception in createOrUpdateState JSON Merge");
                    e.printStackTrace();
                }
            }
            state.setContent(stateContent);
            manager.persist(dbContext, state);
            return state;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid JSON for createOrUpdateState", e);
        }
    }

    public static XapiState getState(Object dbContext, String activityId, String agentJson, String registration, String stateId) {
        try {
            JSONObject agentObject = new JSONObject(agentJson);
            JSONObject agentAccount = agentObject.optJSONObject("account");
            XapiStateManager manager = PersistenceManager.getInstance().getManager(XapiStateManager.class);
            XapiState stateProxy = manager.findByActivityAndAgent(dbContext, activityId, agentObject.optString("mbox", null), agentAccount != null ? agentAccount.optString("name", null) : null, agentAccount != null ? agentAccount.optString("homePage", null) : null, registration, stateId);
            return stateProxy;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid JSON to getState", e);
        }
    }

    public static boolean delete(Object dbContext, String activityId, String agentJson, String registration, String stateId) {
        XapiStateManager manager = PersistenceManager.getInstance().getManager(XapiStateManager.class);
        XapiState state = XapiStateEndpoint.getState(dbContext, activityId, agentJson, registration, stateId);
        if (state != null) {
            return manager.delete(dbContext, state);
        }
        return false;
    }
}

