/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.endpoints.XapiActivityEndpoint;
import com.ustadmobile.nanolrs.core.endpoints.XapiAgentEndpoint;
import com.ustadmobile.nanolrs.core.endpoints.XapiVerbEndpoint;
import com.ustadmobile.nanolrs.core.manager.XapiStatementManager;
import com.ustadmobile.nanolrs.core.model.XapiActivity;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.model.XapiStatement;
import com.ustadmobile.nanolrs.core.model.XapiVerb;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.util.ParseUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.json.JSONException;
import org.json.JSONObject;

public class XapiStatementsEndpoint {
    public static String putStatement(JSONObject stmt, Object dbContext) {
        try {
            String registration;
            XapiStatement stmtProxy = PersistenceManager.getInstance().getManager(XapiStatementManager.class).createSync(dbContext);
            XapiAgent agent = XapiAgentEndpoint.createOrUpdate(dbContext, stmt.getJSONObject("actor"));
            stmtProxy.setAgent(agent);
            if (stmt.has("id")) {
                stmtProxy.setUuid(stmt.getString("id"));
            } else {
                stmtProxy.setUuid(UUID.randomUUID().toString());
                stmt.put("id", (Object)stmtProxy.getUuid());
            }
            if (stmt.has("timestamp")) {
                Calendar cal = ParseUtil.parse8601Timestamp(stmt.getString("timestamp"));
                stmtProxy.setTimestamp(cal.getTime().getTime());
            } else {
                stmtProxy.setTimestamp(new Date().getTime());
                stmt.put("timestamp", (Object)ParseUtil.format8601Timestamp(Calendar.getInstance()));
            }
            XapiVerb verb = XapiVerbEndpoint.createOrUpdate(dbContext, stmt.getJSONObject("verb"));
            stmtProxy.setVerb(verb);
            XapiActivity activity = XapiActivityEndpoint.createOrUpdate(dbContext, stmt.getJSONObject("object"));
            stmtProxy.setActivity(activity);
            if (stmt.has("context") && (registration = stmt.getJSONObject("context").optString("registration", null)) != null) {
                stmtProxy.setContextRegistration(registration);
            }
            if (stmt.has("result")) {
                JSONObject extensions;
                JSONObject result = stmt.getJSONObject("result");
                if (result.has("score")) {
                    JSONObject score = result.getJSONObject("score");
                    if (score.has("scaled")) {
                        stmtProxy.setResultScoreScaled((float)score.getDouble("scaled"));
                    }
                    if (score.has("raw")) {
                        stmtProxy.setResultScoreRaw((float)score.getDouble("raw"));
                    }
                    if (score.has("min")) {
                        stmtProxy.setResultScoreMin((float)score.getDouble("min"));
                    }
                    if (score.has("max")) {
                        stmtProxy.setResultScoreMax((float)score.getDouble("max"));
                    }
                }
                if (result.has("completion")) {
                    stmtProxy.setResultComplete(result.getBoolean("completion"));
                }
                if (result.has("success")) {
                    stmtProxy.setResultSuccess(result.getBoolean("success"));
                }
                if (result.has("duration")) {
                    Period durationPeriod = new Period((Object)result.getString("duration"));
                    long durationInMs = durationPeriod.toDurationFrom((ReadableInstant)new DateTime(0L)).getMillis();
                    stmtProxy.setResultDuration(durationInMs);
                }
                if (result.has("extensions") && (extensions = result.getJSONObject("extensions")).has("https://w3id.org/xapi/cmi5/result/extensions/progress")) {
                    stmtProxy.setResultProgress(extensions.getInt("https://w3id.org/xapi/cmi5/result/extensions/progress"));
                }
            }
            stmtProxy.setFullStatement(stmt.toString());
            PersistenceManager.getInstance().getManager(XapiStatementManager.class).persistSync(dbContext, stmtProxy);
            return stmtProxy.getUuid();
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid json for putstatement", e);
        }
    }

    public static List<? extends XapiStatement> getStatements(Object dbContext, String statementid, String voidedStatemendid, String agentJSON, String verb, String activity, String registration, boolean relatedActivities, boolean relatedAgents, long since, long until, int limit) {
        try {
            XapiAgent agent = agentJSON != null ? XapiAgentEndpoint.createOrUpdate(dbContext, new JSONObject(agentJSON)) : null;
            XapiStatementManager manager = PersistenceManager.getInstance().getManager(XapiStatementManager.class);
            return manager.findByParams(dbContext, statementid, voidedStatemendid, agent, verb, activity, registration, relatedActivities, relatedAgents, since, until, limit);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid JSON supplied", e);
        }
    }

    public static List<? extends XapiStatement> getStatements(Object dbContext, String statementid, String voidedStatemendid, String agentJSON, String verb, String activity, String registration, boolean relatedActivities, boolean relatedAgents, String since, String until, int limit) {
        long sinceLong = -1L;
        long untilLong = -1L;
        if (since != null) {
            sinceLong = ParseUtil.parse8601Timestamp(since).getTimeInMillis();
        }
        if (until != null) {
            untilLong = ParseUtil.parse8601Timestamp(until).getTimeInMillis();
        }
        return XapiStatementsEndpoint.getStatements(dbContext, statementid, voidedStatemendid, agentJSON, verb, activity, registration, relatedActivities, relatedAgents, sinceLong, untilLong, limit);
    }
}

