/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.endpoints;

import com.ustadmobile.nanolrs.core.endpoints.XapiStatementsEndpoint;
import com.ustadmobile.nanolrs.core.endpoints.XapiStatementsForwardingEvent;
import com.ustadmobile.nanolrs.core.endpoints.XapiStatementsForwardingListener;
import com.ustadmobile.nanolrs.core.http.HttpLrs;
import com.ustadmobile.nanolrs.core.manager.XapiForwardingStatementManager;
import com.ustadmobile.nanolrs.core.manager.XapiStatementManager;
import com.ustadmobile.nanolrs.core.model.XapiForwardingStatement;
import com.ustadmobile.nanolrs.core.model.XapiStatement;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class XapiStatementsForwardingEndpoint {
    public static final String LOGTAG = "XapiStatementsForwardingEndpoint";
    public static List<XapiStatementsForwardingListener> queueStatusListeners = Collections.synchronizedList(new ArrayList());

    public static void addQueueStatusListener(XapiStatementsForwardingListener listener) {
        queueStatusListeners.add(listener);
    }

    public static void removeQueueStatusListener(XapiStatementsForwardingListener listener) {
        queueStatusListeners.remove(listener);
    }

    public static void putAndQueueStatement(Object dbContext, JSONObject statement, String destinationURL, String httpUser, String httpPassword) {
        String uuid = XapiStatementsEndpoint.putStatement(statement, dbContext);
        XapiStatement statementProxy = PersistenceManager.getInstance().getManager(XapiStatementManager.class).findByUuidSync(dbContext, uuid);
        XapiStatementsForwardingEndpoint.queueStatement(dbContext, statementProxy, destinationURL, httpUser, httpPassword);
    }

    public static void queueStatement(Object dbContext, XapiStatement statement, String destinationURL, String httpUser, String httpPassword) {
        XapiStatementsForwardingEndpoint.queueStatements(dbContext, new XapiStatement[]{statement}, destinationURL, httpUser, httpPassword);
        XapiStatementsForwardingEndpoint.fireStatementQueuedEvent(statement);
    }

    public static void queueStatements(Object dbContext, XapiStatement[] statements, String destinationURL, String httpUser, String httpPassword) {
        XapiForwardingStatementManager manager = PersistenceManager.getInstance().getManager(XapiForwardingStatementManager.class);
        for (int i = 0; i < statements.length; ++i) {
            XapiForwardingStatement fwdStmt = manager.createSync(dbContext, statements[i].getUuid());
            fwdStmt.setDestinationURL(destinationURL);
            fwdStmt.setHttpAuthUser(httpUser);
            fwdStmt.setHttpAuthPassword(httpPassword);
            fwdStmt.setStatement(statements[i]);
            fwdStmt.setStatus(1);
            manager.persistSync(dbContext, fwdStmt);
        }
        XapiStatementsForwardingEndpoint.fireQueueStatusUpdated(new XapiStatementsForwardingEvent(manager.getUnsentStatementCount(dbContext)));
    }

    public static int sendQueue(Object dbContext) {
        XapiForwardingStatementManager manager = PersistenceManager.getInstance().getManager(XapiForwardingStatementManager.class);
        List<XapiForwardingStatement> toForward = manager.getAllUnsentStatementsSync(dbContext);
        int statementsSent = 0;
        for (XapiForwardingStatement stmt : toForward) {
            try {
                HttpLrs.LrsResponse response = new HttpLrs(stmt.getDestinationURL()).putStatement(new JSONObject(stmt.getStatement().getFullStatement()), stmt.getHttpAuthUser(), stmt.getHttpAuthPassword());
                if (response.getStatus() == 204 || response.getStatus() == 409) {
                    stmt.setStatus(3);
                    ++statementsSent;
                    stmt.setHttpAuthUser(null);
                    stmt.setHttpAuthPassword(null);
                    manager.persistSync(dbContext, stmt);
                    XapiStatementsForwardingEndpoint.fireStatementSentEvent(stmt.getStatement());
                    continue;
                }
                stmt.setStatus(2);
                stmt.setTryCount(stmt.getTryCount() + 1);
                manager.persistSync(dbContext, stmt);
            }
            catch (Exception e) {
                System.err.println("Exception attempting to forward statement");
                e.printStackTrace(System.err);
            }
        }
        if (statementsSent > 0) {
            XapiStatementsForwardingEndpoint.fireQueueStatusUpdated(new XapiStatementsForwardingEvent(manager.getUnsentStatementCount(dbContext)));
        }
        return statementsSent;
    }

    protected static void fireStatementQueuedEvent(XapiStatement statement) {
        if (queueStatusListeners.isEmpty()) {
            return;
        }
        XapiStatementsForwardingEvent event = new XapiStatementsForwardingEvent(statement);
        for (int i = 0; i < queueStatusListeners.size(); ++i) {
            queueStatusListeners.get(i).statementQueued(event);
        }
    }

    protected static void fireStatementSentEvent(XapiStatement statement) {
        if (queueStatusListeners.isEmpty()) {
            return;
        }
        XapiStatementsForwardingEvent event = new XapiStatementsForwardingEvent(statement);
        for (int i = 0; i < queueStatusListeners.size(); ++i) {
            queueStatusListeners.get(i).queueStatementSent(event);
        }
    }

    protected static void fireQueueStatusUpdated(XapiStatementsForwardingEvent event) {
        for (int i = 0; i < queueStatusListeners.size(); ++i) {
            queueStatusListeners.get(i).queueStatusUpdated(event);
        }
    }
}

