/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.sync;

import com.ustadmobile.nanolrs.core.ProxyJsonSerializer;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.NanoLrsModelSyncable;
import com.ustadmobile.nanolrs.core.sync.UMSyncInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class UMSyncData {
    private List<NanoLrsModel> entities;
    private List<UMSyncInfo> info;
    private List<NanoLrsModel> conflicts;

    public UMSyncData(List<NanoLrsModel> entities) {
        this.entities = entities;
        this.info = new ArrayList<UMSyncInfo>();
        this.conflicts = new ArrayList<NanoLrsModel>();
    }

    public UMSyncData(List<NanoLrsModel> entities, List<UMSyncInfo> info) {
        this.entities = entities;
        this.info = info;
        this.conflicts = new ArrayList<NanoLrsModel>();
    }

    public UMSyncData(JSONObject syncJSON, Object dbContext) throws ClassNotFoundException {
        JSONArray entitiesJSON = syncJSON.getJSONArray("data");
        JSONArray entitiesInfoJSON = syncJSON.getJSONArray("info");
        this.entities = new ArrayList<NanoLrsModel>();
        this.info = new ArrayList<UMSyncInfo>();
        this.setInfo(entitiesInfoJSON);
        this.setEntities(entitiesJSON, dbContext);
    }

    public List<NanoLrsModel> getEntities() {
        return this.entities;
    }

    public void setEntities(List<NanoLrsModel> entities) {
        this.entities = entities;
    }

    public void setEntities(JSONArray entitiesJSON, Object dbContext) {
        List allNewEntitiesMap = null;
        for (int i = 0; i < entitiesJSON.length(); ++i) {
            System.out.println(" -->JSON->Object");
            JSONObject entityJSON = entitiesJSON.getJSONObject(i);
            NanoLrsModel thisEntity = ProxyJsonSerializer.toEntity(entityJSON, dbContext);
            allNewEntitiesMap.add(thisEntity);
            System.out.println("   ->OK.");
        }
        this.entities = allNewEntitiesMap;
    }

    public List<UMSyncInfo> getInfo() {
        return this.info;
    }

    public void setInfo(List<UMSyncInfo> info) {
        this.info = info;
    }

    public void addInfo(Class thisType, int thisCount) {
        UMSyncInfo thisInfo = new UMSyncInfo(thisType, thisCount);
        this.info.add(thisInfo);
    }

    public JSONArray getInfoJSON() {
        JSONArray infoJSON = new JSONArray();
        for (UMSyncInfo thisInfo : this.info) {
            infoJSON.put((Object)thisInfo.toJSON());
        }
        return infoJSON;
    }

    public void setInfo(JSONArray infoJSON) throws ClassNotFoundException {
        for (int i = 0; i < infoJSON.length(); ++i) {
            JSONObject thisInfoJSON = infoJSON.getJSONObject(i);
            UMSyncInfo thisInfo = new UMSyncInfo(thisInfoJSON);
            this.info.add(thisInfo);
        }
    }

    public List<NanoLrsModel> getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(List<NanoLrsModel> conflicts) {
        this.conflicts = conflicts;
    }

    public Class getProxyFromEntity(NanoLrsModelSyncable entity) {
        Class<?>[] allInterfaces;
        if (entity.getClass().getInterfaces() == null) {
            return null;
        }
        Class<?> proxy = entity.getClass().getInterfaces()[0];
        for (Class<?> thisInterface : allInterfaces = entity.getClass().getInterfaces()) {
            if (!thisInterface.getName().contains("model")) continue;
            proxy = thisInterface;
            break;
        }
        return proxy;
    }

    public JSONObject toSyncJSON() {
        JSONArray entitiesData = new JSONArray();
        JSONArray entitiesInfo = new JSONArray();
        HashMap<Class, Integer> typeToCount = new HashMap<Class, Integer>();
        List<NanoLrsModel> pendingEntitesToBeSynced = this.entities;
        if (pendingEntitesToBeSynced != null && !pendingEntitesToBeSynced.isEmpty()) {
            for (NanoLrsModelSyncable nanoLrsModelSyncable : pendingEntitesToBeSynced) {
                Class thisEntityProxyType = this.getProxyFromEntity(nanoLrsModelSyncable);
                JSONObject thisEntityInJSON = ProxyJsonSerializer.toJson(nanoLrsModelSyncable, thisEntityProxyType);
                entitiesData.put((Object)thisEntityInJSON);
                if (typeToCount.get(thisEntityProxyType) == null) {
                    typeToCount.put(thisEntityProxyType, 1);
                    continue;
                }
                int updatedCount = (Integer)typeToCount.get(thisEntityProxyType) + 1;
                typeToCount.put(thisEntityProxyType, updatedCount);
            }
        }
        for (Map.Entry entry : typeToCount.entrySet()) {
            Class thisType = (Class)entry.getKey();
            int thisCount = (Integer)entry.getValue();
            this.addInfo(thisType, thisCount);
        }
        entitiesInfo = this.getInfoJSON();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("info", (Object)entitiesInfo);
        jSONObject.put("data", (Object)entitiesData);
        return jSONObject;
    }
}

