/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.sync;

import com.ustadmobile.nanolrs.core.PrimaryKeyAnnotationClass;
import com.ustadmobile.nanolrs.core.ProxyJsonSerializer;
import com.ustadmobile.nanolrs.core.manager.ChangeSeqManager;
import com.ustadmobile.nanolrs.core.manager.NanoLrsManagerSyncable;
import com.ustadmobile.nanolrs.core.manager.NodeManager;
import com.ustadmobile.nanolrs.core.manager.SyncStatusManager;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.mapping.ModelManagerMapping;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.NanoLrsModelSyncable;
import com.ustadmobile.nanolrs.core.model.Node;
import com.ustadmobile.nanolrs.core.model.SyncStatus;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.sync.UMSyncData;
import com.ustadmobile.nanolrs.core.sync.UMSyncResult;
import com.ustadmobile.nanolrs.core.util.Base64CoderNanoLrs;
import com.ustadmobile.nanolrs.core.util.JsonUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class UMSyncEndpoint {
    public static final String REQUEST_CONTENT_LENGTH = "Content-Length";
    public static final String REQUEST_CONTENT_TYPE = "Content-Type";
    public static final String REQUEST_ACCEPT = "Accept";
    public static final String REQUEST_AUTHORIZATION = "Authorization";
    public static final String HEADER_NODE_NAME = "X-UM-nodename";
    public static final String HEADER_NODE_HOST = "X-UM-nodehost";
    public static final String HEADER_NODE_URL = "X-UM-nodeurl";
    public static final String HEADER_NODE_UUID = "X-UM-nodeuuid";
    public static final String HEADER_NODE_ROLE = "X-UM-noderole";
    public static final String HEADER_NODE_ISMASTER = "X-UM-nodeismaster";
    public static final String HEADER_NODE_ISPROXY = "X-UM-nodeisproxy";
    public static final String HEADER_USER_USERNAME = "X-UM-username";
    public static final String HEADER_USER_PASSWORD = "X-UM-password";
    public static final String HEADER_USER_UUID = "X-UM-useruuid";
    public static final String HEADER_USER_IS_NEW = "X-UM-isnewuser";
    public static final String RESPONSE_CHANGE_USERNAME = "X-UM-changeusernameto";
    public static final String RESPONSE_SEND_USER_AGAIN = "X-UM-senduseragain";
    public static final String RESPONSE_SYNCED_STATUS = "X-UM-syncstatus";
    public static final String RESPONSE_SYNC_OK = "OK";
    public static final String RESPONSE_SYNC_FAIL = "FAIL";
    public static final String RESPONSE_ENTITIES_DATA = "data";
    public static final String RESPONSE_ENTITIES_INFO = "info";
    public static final String RESPONSE_CONFLICT = "conflict";
    public static final String ENTITY_INFO_CLASS_NAME = "pCls";
    public static final String ENTITY_INFO_TABLE_NAME = "tableName";
    public static final String ENTITY_INFO_COUNT = "count";
    public static final String ENTITY_INFO_PRIMARY_KEY = "pk";
    public static final String JSON_MIMETYPE = "application/json";
    public static final String UTF_ENCODING = "UTF-8";

    public static String getPrimaryKeyFromClass(Class syncableEntity) {
        Method[] allEntityMethods = syncableEntity.getMethods();
        String pkMethod = null;
        for (Method method : allEntityMethods) {
            if (!method.isAnnotationPresent(PrimaryKeyAnnotationClass.class)) continue;
            pkMethod = method.getName();
            break;
        }
        int prefixLen = 0;
        if (pkMethod.startsWith("is")) {
            prefixLen = 2;
        } else if (pkMethod.startsWith("get")) {
            prefixLen = 3;
        }
        String pkField = Character.toLowerCase(pkMethod.charAt(3)) + pkMethod.substring(prefixLen + 1);
        return pkField;
    }

    public static String getPrimaryKeyMethodFromClass(Class syncableEntity) {
        Method[] allEntityMethods = syncableEntity.getMethods();
        String pkMethod = null;
        for (Method method : allEntityMethods) {
            if (!method.isAnnotationPresent(PrimaryKeyAnnotationClass.class)) continue;
            pkMethod = method.getName();
            break;
        }
        return pkMethod;
    }

    public static NanoLrsManagerSyncable getManagerFromProxyClass(Class syncableEntity) {
        Class managerClass = ModelManagerMapping.proxyClassToManagerMap.get(syncableEntity);
        NanoLrsManagerSyncable syncableEntityManager = (NanoLrsManagerSyncable)PersistenceManager.getInstance().getManager(managerClass);
        return syncableEntityManager;
    }

    public static NanoLrsManagerSyncable getManagerFromProxyName(String thisProxyClassName) {
        Class thisProxyClass = ModelManagerMapping.proxyNameToClassMap.get(thisProxyClassName);
        return UMSyncEndpoint.getManagerFromProxyClass(thisProxyClass);
    }

    public static String getTableNameFromClass(Class syncableEntity) {
        String tableName = UMSyncEndpoint.convertCamelCaseNameToUnderscored(Character.toLowerCase(syncableEntity.getSimpleName().charAt(0)) + syncableEntity.getSimpleName().substring(1));
        if (tableName != null && !tableName.isEmpty()) {
            tableName = tableName.toUpperCase();
        }
        return tableName;
    }

    public static String convertStreamToString2(InputStream is, String encoding) throws IOException {
        int rsz;
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, encoding);
        while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
            out.append(buffer, 0, rsz);
        }
        return out.toString();
    }

    public static Map<Class, Long> getAllEntitiesSeqNum(Object dbContext) throws SQLException {
        HashMap<Class, Long> allEntitiesSeqMap = new HashMap<Class, Long>();
        ChangeSeqManager changeSeqManager = PersistenceManager.getInstance().getManager(ChangeSeqManager.class);
        for (Class thisEntity : ModelManagerMapping.SYNCABLE_ENTITIES) {
            String tableName = UMSyncEndpoint.getTableNameFromClass(thisEntity);
            long preSyncEntitySeqNum = changeSeqManager.getNextChangeByTableName(tableName, dbContext);
            allEntitiesSeqMap.put(thisEntity, preSyncEntitySeqNum);
        }
        return allEntitiesSeqMap;
    }

    public static Map<NanoLrsModelSyncable, String> entitiesJSONToEntitiesMap(JSONArray entitiesJSON, Object dbContext) {
        HashMap<NanoLrsModelSyncable, String> allNewEntitiesMap = new HashMap<NanoLrsModelSyncable, String>();
        for (int i = 0; i < entitiesJSON.length(); ++i) {
            JSONObject entityJSON = entitiesJSON.getJSONObject(i);
            NanoLrsModel thisEntity = ProxyJsonSerializer.toEntity(entityJSON, dbContext);
            String thisProxyClass = entityJSON.getString(ENTITY_INFO_CLASS_NAME);
            allNewEntitiesMap.put((NanoLrsModelSyncable)thisEntity, thisProxyClass);
        }
        return allNewEntitiesMap;
    }

    public static Map<String, Long> getEntityChangeSeqAndIncrementItForInfo(JSONArray entitiesInfoJSON, Object dbContext) throws SQLException {
        ChangeSeqManager changeSeqManager = PersistenceManager.getInstance().getManager(ChangeSeqManager.class);
        HashMap<String, Long> preSyncEntitySeqNumMap = new HashMap<String, Long>();
        for (int j = 0; j < entitiesInfoJSON.length(); ++j) {
            JSONObject thisEntityInfoJSON = entitiesInfoJSON.getJSONObject(j);
            String proxyClassName = thisEntityInfoJSON.getString(ENTITY_INFO_CLASS_NAME);
            String tableName = thisEntityInfoJSON.getString(ENTITY_INFO_TABLE_NAME);
            tableName = tableName.toUpperCase();
            int count = thisEntityInfoJSON.getInt(ENTITY_INFO_COUNT);
            long preSyncEntitySeqNum = changeSeqManager.getNextChangeByTableName(tableName, dbContext);
            preSyncEntitySeqNumMap.put(proxyClassName, preSyncEntitySeqNum);
            changeSeqManager.getNextChangeAddSeqByTableName(tableName, count, dbContext);
        }
        return preSyncEntitySeqNumMap;
    }

    public static UMSyncResult returnEmptyUMSyncResult(int resultStatus) throws UnsupportedEncodingException {
        HashMap responseHeaders = new HashMap();
        return UMSyncEndpoint.returnEmptyUMSyncResultWithHeader(resultStatus, responseHeaders);
    }

    public static UMSyncResult returnEmptyUMSyncResultWithHeader(int resultStatus, Map responseHeaders) throws UnsupportedEncodingException {
        String emptyResponseString = "";
        ByteArrayInputStream responseData = new ByteArrayInputStream(emptyResponseString.getBytes(UTF_ENCODING));
        long responseLength = 0L;
        UMSyncResult resultResponse = new UMSyncResult(resultStatus, responseHeaders, responseData, responseLength);
        return resultResponse;
    }

    public static String convertCamelCaseNameToUnderscored(String propertyName) {
        String underScoredName = "";
        for (int i = 0; i < propertyName.length(); ++i) {
            if (Character.isUpperCase(propertyName.charAt(i)) && (i == 0 || Character.isLowerCase(propertyName.charAt(i - 1)))) {
                underScoredName = underScoredName + "_";
            }
            underScoredName = underScoredName + Character.toLowerCase(propertyName.charAt(i));
        }
        return underScoredName;
    }

    public static JSONObject createJSONInfoFromClass(Class syncableEntity, int count) {
        JSONObject thisEntityInfo = new JSONObject();
        String tableName = UMSyncEndpoint.getTableNameFromClass(syncableEntity);
        String pkField = UMSyncEndpoint.getPrimaryKeyFromClass(syncableEntity);
        thisEntityInfo.put(ENTITY_INFO_CLASS_NAME, (Object)syncableEntity.getName());
        thisEntityInfo.put(ENTITY_INFO_TABLE_NAME, (Object)tableName);
        thisEntityInfo.put(ENTITY_INFO_COUNT, count);
        thisEntityInfo.put(ENTITY_INFO_PRIMARY_KEY, (Object)pkField);
        return thisEntityInfo;
    }

    public static long getLatestSeqNumFromEntityArray(List<NanoLrsModel> pendingEntitesToBeSynced) {
        long latestSeqNum = -1L;
        if (pendingEntitesToBeSynced != null && !pendingEntitesToBeSynced.isEmpty()) {
            for (NanoLrsModelSyncable nanoLrsModelSyncable : pendingEntitesToBeSynced) {
                if (latestSeqNum == -1L) {
                    latestSeqNum = nanoLrsModelSyncable.getLocalSequence();
                    continue;
                }
                if (latestSeqNum >= nanoLrsModelSyncable.getLocalSequence()) continue;
                latestSeqNum = nanoLrsModelSyncable.getLocalSequence();
            }
        }
        if (latestSeqNum == -1L) {
            return 0L;
        }
        return latestSeqNum;
    }

    public static Map.Entry<JSONArray, JSONObject> createJSONDataFromEntityArray(List<NanoLrsModel> pendingEntitesToBeSynced, Class syncableEntity) {
        int count = 0;
        long latestSeqNumToUpdateSyncStatus = -1L;
        JSONArray entitiesData = new JSONArray();
        JSONObject thisEntityInfo = new JSONObject();
        HashMap<JSONArray, JSONObject> entitiesDataInfoMap = new HashMap<JSONArray, JSONObject>();
        if (pendingEntitesToBeSynced != null && !pendingEntitesToBeSynced.isEmpty()) {
            for (NanoLrsModelSyncable nanoLrsModelSyncable : pendingEntitesToBeSynced) {
                JSONObject thisEntityInJSON = ProxyJsonSerializer.toJson(nanoLrsModelSyncable, syncableEntity);
                entitiesData.put((Object)thisEntityInJSON);
                ++count;
            }
        }
        thisEntityInfo = UMSyncEndpoint.createJSONInfoFromClass(syncableEntity, count);
        entitiesDataInfoMap.put(entitiesData, thisEntityInfo);
        Map.Entry<JSONArray, JSONObject> entitiesDataInfoEntry = entitiesDataInfoMap.entrySet().iterator().next();
        return entitiesDataInfoEntry;
    }

    public static Map<String, String> createSyncHeader(User user, Node node) {
        return UMSyncEndpoint.createSyncHeader(user, user.getPassword(), node);
    }

    public static Map<String, String> createSyncHeader(User user, String cred, Node node) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (user != null) {
            headers.put(HEADER_USER_USERNAME, user.getUsername());
            headers.put(HEADER_USER_PASSWORD, cred);
            headers.put(HEADER_USER_UUID, user.getUuid());
            String isNewUser = "false";
            if (user.getMasterSequence() < 0L) {
                isNewUser = "true";
            }
            headers.put(HEADER_USER_IS_NEW, isNewUser);
        }
        if (node != null) {
            headers.put(HEADER_NODE_UUID, node.getUUID());
            headers.put(HEADER_NODE_HOST, node.getHost());
            headers.put(HEADER_NODE_URL, node.getUrl());
            String thisNodeRole = "client";
            if (node.isMaster()) {
                thisNodeRole = "master";
            }
            if (node.isProxy()) {
                thisNodeRole = "proxy";
            }
            headers.put(HEADER_NODE_ROLE, thisNodeRole);
            headers.put(RESPONSE_SYNCED_STATUS, RESPONSE_SYNC_OK);
        }
        return headers;
    }

    public static Map<String, String> createSyncParameters(User user, Node node) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("someparameter", "somevalue");
        return parameters;
    }

    private static void setHeaders(HttpURLConnection connection, Map headers) throws IOException {
        Iterator it = headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            if (pair.getKey() == null || pair.getValue() == null) continue;
            connection.setRequestProperty(pair.getKey().toString(), pair.getValue().toString());
            it.remove();
        }
    }

    public static Map.Entry<UMSyncData, Map<Class, Long>> getSyncInfo(User thisUser, Node node, Map<Class, Long> fromSeq, Map<Class, Long> toSeq, Object dbContext) throws SQLException, IOException {
        SyncStatusManager syncStatusManager = PersistenceManager.getInstance().getManager(SyncStatusManager.class);
        HashMap<Class, Long> latestChangeSeqMap = new HashMap<Class, Long>();
        ArrayList<NanoLrsModel> entities = new ArrayList<NanoLrsModel>();
        for (Class syncableEntity : ModelManagerMapping.SYNCABLE_ENTITIES) {
            NanoLrsManagerSyncable syncableEntityManager = UMSyncEndpoint.getManagerFromProxyClass(syncableEntity);
            long fromSyncSeq = fromSeq != null && !fromSeq.isEmpty() ? fromSeq.get(syncableEntity).longValue() : syncStatusManager.getSentStatus(node.getHost(), syncableEntity, dbContext);
            long toSyncSeq = toSeq != null && !toSeq.isEmpty() ? toSeq.get(syncableEntity) : -1L;
            List<NanoLrsModel> pendingEntitesToBeSynced = syncableEntityManager.getAllSinceTwoSequenceNumber(thisUser, node.getHost(), fromSyncSeq, toSyncSeq, dbContext);
            long latestSeqNumToUpdateSyncStatus = UMSyncEndpoint.getLatestSeqNumFromEntityArray(pendingEntitesToBeSynced);
            if (latestSeqNumToUpdateSyncStatus > 0L) {
                latestChangeSeqMap.put(syncableEntity, latestSeqNumToUpdateSyncStatus);
            }
            Iterator<NanoLrsModel> pendingIterator = pendingEntitesToBeSynced.iterator();
            while (pendingIterator.hasNext()) {
                entities.add(pendingIterator.next());
            }
        }
        UMSyncData syncData = new UMSyncData(entities);
        HashMap<UMSyncData, HashMap<Class, Long>> syncInfoMap = new HashMap<UMSyncData, HashMap<Class, Long>>();
        syncInfoMap.put(syncData, latestChangeSeqMap);
        Map.Entry<UMSyncData, Map<Class, Long>> syncInfo = syncInfoMap.entrySet().iterator().next();
        return syncInfo;
    }

    public static Map.Entry<JSONObject, Map<Class, Long>> getNewEntriesJSON(User thisUser, Node node, Map<Class, Long> fromSeq, Map<Class, Long> toSeq, Object dbContext) throws SQLException, IOException {
        SyncStatusManager syncStatusManager = PersistenceManager.getInstance().getManager(SyncStatusManager.class);
        HashMap<Class, Long> entityToLatestLocalSeqNum = new HashMap<Class, Long>();
        JSONArray pendingJSONEntites = new JSONArray();
        JSONArray pendingJSONInfo = new JSONArray();
        JSONObject pendingEntitiesWithInfo = new JSONObject();
        for (Class syncableEntity : ModelManagerMapping.SYNCABLE_ENTITIES) {
            NanoLrsManagerSyncable syncableEntityManager = UMSyncEndpoint.getManagerFromProxyClass(syncableEntity);
            long fromSyncSeq = fromSeq != null && !fromSeq.isEmpty() ? fromSeq.get(syncableEntity).longValue() : syncStatusManager.getSentStatus(node.getHost(), syncableEntity, dbContext);
            long toSyncSeq = toSeq != null && !toSeq.isEmpty() ? toSeq.get(syncableEntity) : -1L;
            List<NanoLrsModel> pendingEntitesToBeSynced = syncableEntityManager.getAllSinceTwoSequenceNumber(thisUser, node.getHost(), fromSyncSeq, toSyncSeq, dbContext);
            Map.Entry<JSONArray, JSONObject> entityEntriesAndInfo = UMSyncEndpoint.createJSONDataFromEntityArray(pendingEntitesToBeSynced, syncableEntity);
            pendingJSONEntites = JsonUtil.addTheseTwoJSONArrays(pendingJSONEntites, entityEntriesAndInfo.getKey());
            pendingJSONInfo.put((Object)entityEntriesAndInfo.getValue());
            long latestSeqNumToUpdateSyncStatus = UMSyncEndpoint.getLatestSeqNumFromEntityArray(pendingEntitesToBeSynced);
            if (latestSeqNumToUpdateSyncStatus <= 0L) continue;
            entityToLatestLocalSeqNum.put(syncableEntity, latestSeqNumToUpdateSyncStatus);
        }
        pendingEntitiesWithInfo.put(RESPONSE_ENTITIES_DATA, (Object)pendingJSONEntites);
        pendingEntitiesWithInfo.put(RESPONSE_ENTITIES_INFO, (Object)pendingJSONInfo);
        HashMap<JSONObject, HashMap<Class, Long>> newEntitiesJSONAndLatestSeqNum = new HashMap<JSONObject, HashMap<Class, Long>>();
        newEntitiesJSONAndLatestSeqNum.put(pendingEntitiesWithInfo, entityToLatestLocalSeqNum);
        Map.Entry<JSONObject, Map<Class, Long>> newEntitiesJSONAndLatestSeqNumEntry = newEntitiesJSONAndLatestSeqNum.entrySet().iterator().next();
        return newEntitiesJSONAndLatestSeqNumEntry;
    }

    public static Map<String, String> getHeadersFromRequest(HttpURLConnection conn) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entries : conn.getHeaderFields().entrySet()) {
            String values = "";
            for (String value : entries.getValue()) {
                values = values + value + ",";
                headers.put(entries.getKey(), value);
            }
        }
        return headers;
    }

    public static String encodeBasicAuth(String username, String password) {
        return "Basic " + Base64CoderNanoLrs.encodeString(username + ':' + password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UMSyncResult makeSyncRequest(String destURL, String method, String username, String password, Map headers, Map parameters, JSONObject dataJSON, String contentType, byte[] content) {
        UMSyncResult response = new UMSyncResult();
        HttpURLConnection con = null;
        OutputStream out = null;
        String basicAuthString = null;
        if (username != null && password != null && username.length() > 0 && password.length() > 0) {
            basicAuthString = UMSyncEndpoint.encodeBasicAuth(username, password);
            System.out.print("got basic: " + basicAuthString);
            headers.put(REQUEST_AUTHORIZATION, basicAuthString);
        }
        try {
            byte[] payload;
            URL url = new URL(destURL);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(method.toUpperCase());
            con.setDoOutput(true);
            if (!headers.isEmpty()) {
                UMSyncEndpoint.setHeaders(con, headers);
            }
            if (contentType != null) {
                con.setRequestProperty(REQUEST_CONTENT_TYPE, contentType);
                con.setRequestProperty(REQUEST_ACCEPT, contentType);
            }
            if (dataJSON != null && dataJSON.length() > 0) {
                payload = dataJSON.toString().getBytes(UTF_ENCODING);
            } else if (content != null) {
                payload = content;
            } else if (parameters != null && method.equalsIgnoreCase("POST")) {
                String paramString = "";
                for (Map.Entry thisParameter : parameters.entrySet()) {
                    String amp = "";
                    if (paramString != "") {
                        amp = "&";
                    }
                    paramString = paramString + amp + thisParameter.getKey() + "=" + thisParameter.getValue();
                }
                payload = paramString.getBytes(UTF_ENCODING);
            } else {
                throw new IllegalArgumentException("Invalid arguments to makeSyncRequest");
            }
            con.setFixedLengthStreamingMode(payload.length);
            out = con.getOutputStream();
            out.write(payload);
            out.flush();
            int statusCode = con.getResponseCode();
            response.setHeaders(UMSyncEndpoint.getHeadersFromRequest(con));
            response.setStatus(statusCode);
            response.setResponseData(con.getInputStream());
            response.setResponseLength(con.getContentLength());
        }
        catch (IOException e) {
            System.err.println("saveState Exception");
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return response;
    }

    public static boolean jsonToDB(JSONObject entitiesWithInfoJSON, Node senderNode, Node thisNode, User thisUser, Object dbContext) throws SQLException {
        boolean allgoood = false;
        SyncStatusManager syncStatusManager = PersistenceManager.getInstance().getManager(SyncStatusManager.class);
        Map<Object, Object> allNewEntitiesMap = new HashMap();
        JSONArray entitiesJSON = entitiesWithInfoJSON.getJSONArray(RESPONSE_ENTITIES_DATA);
        JSONArray entitiesInfoJSON = entitiesWithInfoJSON.getJSONArray(RESPONSE_ENTITIES_INFO);
        allNewEntitiesMap = UMSyncEndpoint.entitiesJSONToEntitiesMap(entitiesJSON, dbContext);
        Map<String, Long> preSyncEntitySeqNumMap = UMSyncEndpoint.getEntityChangeSeqAndIncrementItForInfo(entitiesInfoJSON, dbContext);
        for (Map.Entry<Object, Object> thisNewEntityMap : allNewEntitiesMap.entrySet()) {
            SyncStatus ss;
            long currentSent;
            boolean doIPersist;
            User thisNewEntityUser;
            NanoLrsModelSyncable thisNewEntity = (NanoLrsModelSyncable)thisNewEntityMap.getKey();
            String thisProxyClassName = (String)thisNewEntityMap.getValue();
            Class thisProxyClass = ModelManagerMapping.proxyNameToClassMap.get(thisProxyClassName);
            if (thisProxyClass == User.class && !(thisNewEntityUser = (User)thisNewEntity).getUsername().equals(thisUser.getUsername())) {
                System.out.println("UMSync: jsonToDB: Skipping non User username. Remove me when all devices are up to date.");
                continue;
            }
            NanoLrsManagerSyncable thisManager = UMSyncEndpoint.getManagerFromProxyClass(thisProxyClass);
            long thisNewEntityNewSeq = preSyncEntitySeqNumMap.get(thisProxyClassName);
            if (thisNewEntity.getMasterSequence() < 0L) {
                thisNewEntity.setMasterSequence(0L);
            }
            preSyncEntitySeqNumMap.put(thisProxyClassName, thisNewEntityNewSeq);
            thisNewEntity.setLocalSequence(thisNewEntityNewSeq);
            if (thisNode != null && thisNode.isMaster()) {
                thisNewEntity.setMasterSequence(thisNewEntityNewSeq);
            }
            if (doIPersist = UMSyncEndpoint.shouldIPersistThisEntity(thisNewEntity, thisProxyClass, senderNode, thisNode, dbContext)) {
                thisManager.persist(dbContext, thisNewEntity, false);
                preSyncEntitySeqNumMap.put(thisProxyClassName, thisNewEntityNewSeq + 1L);
            }
            if (thisNewEntityNewSeq <= (currentSent = (ss = (SyncStatus)syncStatusManager.getSyncStatus(senderNode.getHost(), thisProxyClass, dbContext)).getSentSeq())) continue;
            ss.setSentSeq(thisNewEntityNewSeq);
            syncStatusManager.persist(dbContext, ss);
            System.out.println("Sync Status updated OK..");
        }
        allgoood = true;
        return allgoood;
    }

    public static UMSyncResult validateUMSyncStream(InputStream inputStream) throws UnsupportedEncodingException {
        try {
            String streamString = UMSyncEndpoint.convertStreamToString2(inputStream, UTF_ENCODING);
            return UMSyncEndpoint.validateUMSyncString(streamString);
        }
        catch (IOException e) {
            e.printStackTrace();
            return UMSyncEndpoint.returnEmptyUMSyncResult(400);
        }
    }

    public static UMSyncResult validateUMSyncString(String streamString) throws UnsupportedEncodingException {
        try {
            if (streamString.isEmpty()) {
                return UMSyncEndpoint.returnEmptyUMSyncResult(204);
            }
            if (!JsonUtil.isThisStringJSON(streamString)) {
                return UMSyncEndpoint.returnEmptyUMSyncResult(400);
            }
            JSONObject entitiesWithInfoJSON = new JSONObject(streamString);
            if (entitiesWithInfoJSON.optJSONArray(RESPONSE_ENTITIES_DATA) == null) {
                return UMSyncEndpoint.returnEmptyUMSyncResult(400);
            }
            if (entitiesWithInfoJSON.optJSONArray(RESPONSE_ENTITIES_INFO) == null) {
                return UMSyncEndpoint.returnEmptyUMSyncResult(400);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return UMSyncEndpoint.returnEmptyUMSyncResult(400);
        }
        return null;
    }

    public static boolean isThisUsernameAvailable(String username, Object dbContext) {
        UserManager userManager = PersistenceManager.getInstance().getManager(UserManager.class);
        User userAlreadyExists = userManager.findByUsername(dbContext, username);
        return userAlreadyExists == null;
    }

    public static String getNextAvailableUsername(String username, Object dbContext) {
        if (UMSyncEndpoint.isThisUsernameAvailable(username, dbContext)) {
            return username;
        }
        int appendValue = (int)Math.floor(Math.random() * 101.0);
        String newUsername = username + appendValue;
        while (UMSyncEndpoint.isThisUsernameAvailable(newUsername, dbContext)) {
            if (UMSyncEndpoint.isThisUsernameAvailable(newUsername, dbContext)) {
                return newUsername;
            }
            newUsername = username + ++appendValue;
        }
        return null;
    }

    public static String getHeader(Map<String, String> headers, String headerName) {
        String oldHeaderName = null;
        if (headerName.startsWith("X-UM-")) {
            oldHeaderName = headerName.substring("X-UM-".length(), headerName.length());
        }
        if (headers.get(headerName) == null && headers.get(headerName.toLowerCase()) == null) {
            String value = headers.get(oldHeaderName);
            if (value == null && oldHeaderName != null && headers.get(oldHeaderName.toLowerCase()) != null) {
                value = headers.get(oldHeaderName.toLowerCase());
            }
            return value;
        }
        String val = headers.get(headerName);
        if (val == null && headers.get(headerName.toLowerCase()) != null) {
            val = headers.get(headerName.toLowerCase());
        }
        return val;
    }

    public static String[] getCredFromAuthString(String authorization) {
        if (authorization != null && authorization.startsWith("Basic")) {
            String base64Credentials = authorization.substring("Basic".length()).trim();
            String credentials = Base64CoderNanoLrs.decodeString(base64Credentials);
            String[] values = credentials.split(":", 2);
            return values;
        }
        return null;
    }

    public static String getPasswordFromBasicAuthString(String authorization) {
        String[] credentials = UMSyncEndpoint.getCredFromAuthString(authorization);
        if (credentials != null && credentials.length > 0) {
            return credentials[1];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UMSyncResult handleIncomingSync(InputStream inputStream, Node node, Map headers, Map parameters, Object dbContext) throws SQLException, IOException {
        long responseLength;
        ByteArrayInputStream responseData;
        int resultStatus;
        String thisNodeHost;
        JSONObject entitiesWithInfoJSON;
        User thisUser;
        String isNew;
        String userPassword;
        Node thisNode;
        ArrayList conflictEntries;
        HashMap<Class, Long> preSyncAllEntitiesSeqMap;
        boolean emptyResponse;
        JSONArray conflictEntitiesJSON;
        JSONArray sendTheseInfoBack;
        JSONArray sendTheseEntitiesBack;
        JSONObject responseJSON;
        UserManager userManager;
        block36: {
            String userUsername;
            block37: {
                String userUUID;
                block35: {
                    NodeManager nodeManager = PersistenceManager.getInstance().getManager(NodeManager.class);
                    userManager = PersistenceManager.getInstance().getManager(UserManager.class);
                    responseJSON = new JSONObject();
                    sendTheseEntitiesBack = new JSONArray();
                    sendTheseInfoBack = new JSONArray();
                    conflictEntitiesJSON = new JSONArray();
                    emptyResponse = true;
                    HashMap allNewEntitiesMap = new HashMap();
                    preSyncAllEntitiesSeqMap = new HashMap();
                    conflictEntries = new ArrayList();
                    thisNode = nodeManager.getThisNode(dbContext);
                    userUsername = UMSyncEndpoint.getHeader(headers, HEADER_USER_USERNAME);
                    userPassword = UMSyncEndpoint.getHeader(headers, HEADER_USER_PASSWORD);
                    userUUID = UMSyncEndpoint.getHeader(headers, HEADER_USER_UUID);
                    isNew = UMSyncEndpoint.getHeader(headers, HEADER_USER_IS_NEW);
                    thisUser = null;
                    preSyncAllEntitiesSeqMap = UMSyncEndpoint.getAllEntitiesSeqNum(dbContext);
                    try {
                        String streamString = UMSyncEndpoint.convertStreamToString2(inputStream, UTF_ENCODING);
                        if (streamString.isEmpty()) {
                            return UMSyncEndpoint.returnEmptyUMSyncResult(204);
                        }
                        if (!JsonUtil.isThisStringJSON(streamString)) {
                            return UMSyncEndpoint.returnEmptyUMSyncResult(400);
                        }
                        entitiesWithInfoJSON = new JSONObject(streamString);
                        if (entitiesWithInfoJSON.optJSONArray(RESPONSE_ENTITIES_DATA) == null) {
                            return UMSyncEndpoint.returnEmptyUMSyncResult(400);
                        }
                        if (entitiesWithInfoJSON.optJSONArray(RESPONSE_ENTITIES_INFO) == null) {
                            return UMSyncEndpoint.returnEmptyUMSyncResult(400);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return UMSyncEndpoint.returnEmptyUMSyncResult(400);
                    }
                    if (!thisNode.isMaster() && !thisNode.isProxy()) {
                        System.out.println("\nSorry Client-Client not allowed.\n");
                        return UMSyncEndpoint.returnEmptyUMSyncResult(406);
                    }
                    if (thisNode.isProxy()) {
                        System.out.println("\nProxy here. I don't have the new user syncing with me.\nDon't think I'm going to accept user from client. I'll wait till I sync with master instead.\n");
                    }
                    String basicAuthCred = null;
                    String basicAuthString = UMSyncEndpoint.getHeader(headers, REQUEST_AUTHORIZATION);
                    if (basicAuthString != null && !basicAuthString.isEmpty() && (basicAuthCred = UMSyncEndpoint.getPasswordFromBasicAuthString(basicAuthString)) != null && !basicAuthCred.isEmpty()) {
                        userPassword = basicAuthCred;
                    }
                    if (!isNew.equals("true")) break block35;
                    if (userUsername != null && !userUsername.isEmpty()) {
                        User ifIExistChangeUsername = userManager.findByUsername(dbContext, userUsername);
                        if (ifIExistChangeUsername != null) {
                            System.out.println("\nUsername already exists for new user.\nChanging it rejecting incoming sync with new username header.\n");
                            String newAvailableUsername = UMSyncEndpoint.getNextAvailableUsername(userUsername, dbContext);
                            HashMap<String, String> changeYourUsernameHeader = new HashMap<String, String>();
                            changeYourUsernameHeader.put(RESPONSE_CHANGE_USERNAME, newAvailableUsername);
                            return UMSyncEndpoint.returnEmptyUMSyncResultWithHeader(409, changeYourUsernameHeader);
                        }
                        if (userPassword == null) return UMSyncEndpoint.returnEmptyUMSyncResult(400);
                        if (userPassword.isEmpty()) return UMSyncEndpoint.returnEmptyUMSyncResult(400);
                        thisUser = (User)userManager.makeNew();
                        thisUser.setUsername(userUsername);
                        if (userUUID != null && !userUUID.isEmpty()) {
                            thisUser.setUuid(userUUID);
                        } else {
                            thisUser.setUuid(UUID.randomUUID().toString());
                        }
                        try {
                            userPassword = userManager.hashPassword(userPassword);
                        }
                        catch (NoSuchAlgorithmException e) {
                            System.out.println("Could not hash password for new user in handleIncomingSync() : " + e);
                            e.printStackTrace();
                        }
                        thisUser.setPassword(userPassword);
                        userManager.persist(dbContext, thisUser, false);
                        break block36;
                    } else {
                        System.out.println("No username given. BAD REQUEST!");
                        return UMSyncEndpoint.returnEmptyUMSyncResult(400);
                    }
                }
                thisUser = userManager.findByUsername(dbContext, userUsername);
                if (thisUser != null) break block37;
                System.out.println("SYNCED USER DOES NOT EXIST HERE..");
                if (!thisNode.isMaster()) break block36;
                System.out.println("\nMaster here. I have a new user that's supposed to be with me,\n but i dont have it. I'll create it anyway.. \n");
                if (userPassword != null && !userPassword.isEmpty()) {
                    thisUser = (User)userManager.makeNew();
                    thisUser.setUsername(userUsername);
                    try {
                        userPassword = userManager.hashPassword(userPassword);
                    }
                    catch (NoSuchAlgorithmException e) {
                        System.out.println("Unable to hash password for master in handleIncomingSync() " + e);
                        e.printStackTrace();
                    }
                    thisUser.setPassword(userPassword);
                    if (userUUID != null && !userUUID.isEmpty()) {
                        thisUser.setUuid(userUUID);
                    } else {
                        thisUser.setUuid(UUID.randomUUID().toString());
                    }
                    userManager.persist(dbContext, thisUser, false);
                }
                break block36;
            }
            if (!userManager.authenticate(dbContext, userUsername, userPassword, true)) {
                System.out.println("Sorry, Username and password does not match for sync");
                return UMSyncEndpoint.returnEmptyUMSyncResult(401);
            }
        }
        try {
            thisNodeHost = thisNode.getHost();
        }
        catch (Exception e) {
            thisNodeHost = "Not set";
        }
        String thisUsername = "null";
        if (thisUser != null) {
            thisUsername = thisUser.getUsername();
        }
        System.out.println("UMSYNC: Incoming: Getting sync for user: " + thisUsername + " isNew?: " + isNew + " from Node:" + node.getHost() + " . I am Node: " + thisNodeHost);
        boolean allgood = UMSyncEndpoint.jsonToDB(entitiesWithInfoJSON, node, thisNode, thisUser, dbContext);
        if (thisUser.getMasterSequence() < 0L) {
            Long localSeq = thisUser.getLocalSequence();
            thisUser.setMasterSequence(0L);
            if (thisNode.isMaster() && localSeq != null && localSeq > 0L) {
                thisUser.setMasterSequence(localSeq);
            }
            userManager.persist(dbContext, thisUser, false);
        }
        Map.Entry<JSONObject, Map<Class, Long>> returnEntitiesMap = UMSyncEndpoint.getNewEntriesJSON(thisUser, node, null, preSyncAllEntitiesSeqMap, dbContext);
        sendTheseEntitiesBack = returnEntitiesMap.getKey().getJSONArray(RESPONSE_ENTITIES_DATA);
        sendTheseInfoBack = returnEntitiesMap.getKey().getJSONArray(RESPONSE_ENTITIES_INFO);
        Map<Class, Long> returnEntitiesChangeSeq = returnEntitiesMap.getValue();
        Map<String, String> responseHeaders = UMSyncEndpoint.createSyncHeader(thisUser, userPassword, node);
        if (allgood) {
            System.out.println("UMSync: Incoming: jsonToDB all good (for user:" + thisUser.getUsername() + ").");
            resultStatus = 200;
            responseHeaders.put(RESPONSE_SYNCED_STATUS, RESPONSE_SYNC_OK);
        } else {
            resultStatus = 500;
            responseHeaders.put(RESPONSE_SYNCED_STATUS, RESPONSE_SYNC_FAIL);
        }
        String emptyValidJSONString = "{\n    \"data\": [],\n    \"info\": []\n}";
        if (conflictEntries != null && conflictEntries.size() > 0) {
            for (NanoLrsModel thisConflictEntry : conflictEntries) {
                JSONObject thisConflictEntryJSON = ProxyJsonSerializer.toJson(thisConflictEntry, thisConflictEntry.getClass());
                conflictEntitiesJSON.put((Object)thisConflictEntryJSON);
            }
        }
        if (conflictEntitiesJSON != null && conflictEntitiesJSON.length() > 0) {
            responseJSON.put(RESPONSE_CONFLICT, (Object)conflictEntitiesJSON);
            emptyResponse = false;
        }
        if (sendTheseEntitiesBack != null && sendTheseEntitiesBack.length() > 0 && sendTheseInfoBack != null && sendTheseInfoBack.length() > 0) {
            responseJSON.put(RESPONSE_ENTITIES_DATA, (Object)sendTheseEntitiesBack);
            responseJSON.put(RESPONSE_ENTITIES_INFO, (Object)sendTheseInfoBack);
            emptyResponse = false;
        }
        if (emptyResponse) {
            responseData = new ByteArrayInputStream(emptyValidJSONString.getBytes(UTF_ENCODING));
            responseLength = emptyValidJSONString.length();
        } else {
            String resultForClient = responseJSON.toString();
            responseData = new ByteArrayInputStream(resultForClient.getBytes(UTF_ENCODING));
            responseLength = resultForClient.length();
        }
        long dataSize = entitiesWithInfoJSON.optJSONArray(RESPONSE_ENTITIES_DATA).length();
        return new UMSyncResult(resultStatus, responseHeaders, responseData, responseLength, returnEntitiesChangeSeq, dataSize);
    }

    public static boolean updateSyncStatus(UMSyncResult syncResult, Node node, Object dbContext) throws SQLException {
        SyncStatusManager syncStatusManager = PersistenceManager.getInstance().getManager(SyncStatusManager.class);
        Map<Class, Long> returnEntitiesChangeSeq = syncResult.getPostSyncChangeSeqMap();
        boolean allgood = false;
        for (Map.Entry<Class, Long> thisEntityToLatestLocalSeqNumEntry : returnEntitiesChangeSeq.entrySet()) {
            SyncStatus ss = (SyncStatus)syncStatusManager.getSyncStatus(node.getHost(), thisEntityToLatestLocalSeqNumEntry.getKey(), dbContext);
            long currentSentSeq = ss.getSentSeq();
            long latestSeqNumReturned = thisEntityToLatestLocalSeqNumEntry.getValue();
            if (latestSeqNumReturned <= currentSentSeq) continue;
            ss.setSentSeq(latestSeqNumReturned);
            syncStatusManager.persist(dbContext, ss);
        }
        allgood = true;
        return allgood;
    }

    public static UMSyncResult startSync(User thisUser, Node node, Object dbContext) throws SQLException, IOException {
        return UMSyncEndpoint.startSync(thisUser, null, node, dbContext);
    }

    public static UMSyncResult startSync(User thisUser, String thisUserCred, Node node, Object dbContext) throws SQLException, IOException {
        SyncStatusManager syncStatusManager = PersistenceManager.getInstance().getManager(SyncStatusManager.class);
        NodeManager nodeManager = PersistenceManager.getInstance().getManager(NodeManager.class);
        UserManager userManager = PersistenceManager.getInstance().getManager(UserManager.class);
        Node thisNode = nodeManager.getThisNode(dbContext);
        Map<Object, Object> entityToLatestLocalSeqNum = new HashMap();
        HashMap entityToLatestMasterSeqNum = new HashMap();
        Map<String, String> headers = UMSyncEndpoint.createSyncHeader(thisUser, thisUserCred, thisNode);
        Map<String, String> parameters = UMSyncEndpoint.createSyncParameters(thisUser, thisNode);
        boolean userWasNew = false;
        if (thisUser.getMasterSequence() < 0L) {
            userWasNew = true;
            thisUser.setMasterSequence(0L);
            userManager.persist(dbContext, thisUser, false);
        }
        Map.Entry<UMSyncData, Map<Class, Long>> syncInfo = UMSyncEndpoint.getSyncInfo(thisUser, node, null, null, dbContext);
        JSONObject pendingEntitiesWithInfo = syncInfo.getKey().toSyncJSON();
        entityToLatestLocalSeqNum = syncInfo.getValue();
        headers.put(RESPONSE_SYNCED_STATUS, RESPONSE_SYNC_OK);
        UMSyncResult syncResult = UMSyncEndpoint.makeSyncRequest(node.getUrl(), "POST", thisUser.getUsername(), thisUserCred, headers, parameters, pendingEntitiesWithInfo, JSON_MIMETYPE, null);
        syncResult.setEntitiesCount(syncInfo.getKey().getEntities().size());
        Map responseHeaders = syncResult.getHeaders();
        if (syncResult.getStatus() == 200) {
            String syncStatusHeader = UMSyncEndpoint.getHeader(syncResult.getHeaders(), RESPONSE_SYNCED_STATUS);
            if (syncStatusHeader != null && syncStatusHeader.equals(RESPONSE_SYNC_OK)) {
                for (Map.Entry<Object, Object> entityLatestChangeSeq : entityToLatestLocalSeqNum.entrySet()) {
                    syncStatusManager.updateSyncStatusSeqNum(node.getHost(), (Class)entityLatestChangeSeq.getKey(), (Long)entityLatestChangeSeq.getValue(), -1L, dbContext);
                }
                for (Map.Entry entityMasterSeqMap : entityToLatestMasterSeqNum.entrySet()) {
                    syncStatusManager.updateSyncStatusSeqNum(node.getHost(), (Class)entityMasterSeqMap.getKey(), -1L, (Long)entityMasterSeqMap.getValue(), dbContext);
                }
            } else if (userWasNew) {
                thisUser.setMasterSequence(-1L);
                userManager.persist(dbContext, thisUser, false);
            }
        } else if (syncResult.getStatus() == 500) {
            if (userWasNew) {
                thisUser.setMasterSequence(-1L);
                userManager.persist(dbContext, thisUser, false);
            }
        } else if (syncResult.getStatus() == 409) {
            if (responseHeaders == null) {
                System.out.println("Username update for existence failed.");
            } else {
                System.out.println("\nstartSync HTTP CONFLICT : RESPONSE HEADERS:\n" + responseHeaders);
                String newUsername = UMSyncEndpoint.getHeader(syncResult.getHeaders(), RESPONSE_CHANGE_USERNAME);
                if (newUsername != null && !newUsername.isEmpty()) {
                    if (userWasNew) {
                        thisUser.setMasterSequence(-1L);
                        userManager.persist(dbContext, thisUser, false);
                    }
                    userManager.updateUsername(newUsername, thisUser, dbContext);
                }
            }
        }
        JSONArray responseData = new JSONArray();
        JSONArray responseInfo = new JSONArray();
        JSONArray conflictData = new JSONArray();
        InputStream syncResultResponseStream = syncResult.getResponseData();
        String syncResultResponse = "";
        if (syncResultResponseStream != null) {
            syncResultResponse = UMSyncEndpoint.convertStreamToString2(syncResultResponseStream, UTF_ENCODING);
        }
        if (!syncResultResponse.isEmpty()) {
            JSONObject syncResultAllResponseJSON = new JSONObject(syncResultResponse);
            if (syncResultAllResponseJSON != null) {
                if (syncResultAllResponseJSON.optJSONArray(RESPONSE_ENTITIES_DATA) != null) {
                    responseData = syncResultAllResponseJSON.getJSONArray(RESPONSE_ENTITIES_DATA);
                }
                if (syncResultAllResponseJSON.optJSONArray(RESPONSE_ENTITIES_INFO) != null) {
                    responseInfo = syncResultAllResponseJSON.getJSONArray(RESPONSE_ENTITIES_INFO);
                }
                if (syncResultAllResponseJSON.optJSONArray(RESPONSE_CONFLICT) != null) {
                    conflictData = syncResultAllResponseJSON.getJSONArray(RESPONSE_CONFLICT);
                }
            }
            if (conflictData != null) {
                System.out.println("\n!!THERE WEERE CONFLICTS AFTER SERVER CHECK EVEN> \nPLEASE HANDLE THEM!\n");
            }
            JSONObject responseDataInfo = new JSONObject();
            responseDataInfo.put(RESPONSE_ENTITIES_DATA, (Object)responseData);
            responseDataInfo.put(RESPONSE_ENTITIES_INFO, (Object)responseInfo);
            UMSyncEndpoint.jsonToDB(responseDataInfo, node, thisNode, thisUser, dbContext);
        }
        return syncResult;
    }

    public static boolean shouldIPersistThisEntity(NanoLrsModelSyncable thisNewEntity, Class thisProxyClass, Node senderNode, Node thisNode, Object dbContext) throws SQLException {
        SyncStatusManager syncStatusManager = PersistenceManager.getInstance().getManager(SyncStatusManager.class);
        boolean doIPersist = true;
        NanoLrsManagerSyncable thisManager = UMSyncEndpoint.getManagerFromProxyClass(thisProxyClass);
        String pkField = UMSyncEndpoint.getPrimaryKeyFromClass(thisProxyClass);
        String pkMethodName = UMSyncEndpoint.getPrimaryKeyMethodFromClass(thisProxyClass);
        NanoLrsModelSyncable existingEntityToBeUpdated = null;
        try {
            Method pkMethod = thisProxyClass.getMethod(pkMethodName, new Class[0]);
            existingEntityToBeUpdated = (NanoLrsModelSyncable)thisManager.findByPrimaryKey(dbContext, pkMethod.invoke((Object)thisNewEntity, new Object[0]));
            System.out.println("ENTITY UPDATE: " + pkMethod.invoke((Object)thisNewEntity, new Object[0]) + " (" + thisProxyClass.getSimpleName() + ")");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        SyncStatus ss = (SyncStatus)syncStatusManager.getSyncStatus(senderNode.getHost(), thisProxyClass, dbContext);
        Long lastSyncSeq = syncStatusManager.getSentStatus(senderNode.getHost(), thisProxyClass, dbContext);
        if (existingEntityToBeUpdated != null) {
            long currentLatestMaster = existingEntityToBeUpdated.getMasterSequence();
            long thisNewEntityMaster = thisNewEntity.getMasterSequence();
            long currentStoredDate = existingEntityToBeUpdated.getStoredDate();
            long newStoredDate = thisNewEntity.getStoredDate();
            if (currentLatestMaster > 0L && thisNewEntityMaster > 0L) {
                if (thisNewEntityMaster < currentLatestMaster) {
                    System.out.println("Already have this update from master. Skipping.");
                    doIPersist = false;
                } else if (thisNewEntityMaster == currentLatestMaster) {
                    System.out.println("Sync Conflict. Both entities have the same master.\nWe cannot keep the update. We ignore this.\n");
                    doIPersist = false;
                }
            } else if (currentLatestMaster > 0L || thisNewEntityMaster > 0L) {
                if (currentLatestMaster > thisNewEntityMaster) {
                    System.out.println("Sync conflict resolution: Current Master is valid (not 0) and new master isn't.\n");
                    if (currentStoredDate > newStoredDate) {
                        System.out.println(" .. but current is newer. skipping");
                        doIPersist = false;
                    } else {
                        System.out.println(" .. but incoming is newer. Allowing..");
                        doIPersist = true;
                    }
                }
            } else if (senderNode.isProxy()) {
                if (thisNode.isProxy()) {
                    System.out.println("\nIncoming Sync Conflict:Sender is Proxy and I am a proxy too.\nNot updating this entry.\nTwo Proxy's cannot talk.");
                    doIPersist = false;
                } else if (thisNewEntity.getLocalSequence() < lastSyncSeq) {
                    System.out.println("\nIncoming Sync conflict:Sender is proxy.\nSender's are already in the system. \nThey shouldn't have been sent.\nNot updating this entry.\n");
                    doIPersist = false;
                } else if (thisNewEntity.getLocalSequence() > lastSyncSeq) {
                    System.out.println("\nIncoming Sync Resolution: Sender is From proxy\nRequest from proxy: is higher. Accepting..\n\n\n!!!!THIS SHOULD NOT HAPPEN!!\n\n");
                    doIPersist = true;
                }
            } else if (!thisNode.isProxy() && !thisNode.isMaster()) {
                System.out.println("\nIncoming Sync conflict:Sender and I are both clients.\nRejecting this.\n");
                doIPersist = false;
            } else if (newStoredDate < currentStoredDate) {
                System.out.println("\nIncoming Sync resultion:Sender is a client\nSenders entries are not more recent.\n Not updating it (I have a newer version).\n");
                doIPersist = false;
            }
        } else {
            doIPersist = true;
        }
        return doIPersist;
    }
}

