/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.sync;

import com.ustadmobile.nanolrs.core.sync.UMSyncEndpoint;
import org.json.JSONObject;

public class UMSyncInfo {
    public static final String ENTITY_INFO_CLASS_NAME = "pCls";
    public static final String ENTITY_INFO_TABLE_NAME = "tableName";
    public static final String ENTITY_INFO_COUNT = "count";
    public static final String ENTITY_INFO_PRIMARY_KEY = "pk";
    private Class entityClass;
    private int count;

    public UMSyncInfo(Class entityClass, int count) {
        this.entityClass = entityClass;
        this.count = count;
    }

    public UMSyncInfo(JSONObject infoJSON) throws ClassNotFoundException {
        Class<?> entityClass;
        String className = infoJSON.getString(ENTITY_INFO_CLASS_NAME);
        String tableNAme = infoJSON.getString(ENTITY_INFO_TABLE_NAME);
        int count = Integer.parseInt(infoJSON.getString(ENTITY_INFO_COUNT));
        String pkField = infoJSON.getString(ENTITY_INFO_PRIMARY_KEY);
        this.entityClass = entityClass = Class.forName(className);
        this.count = count;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void addCount(int addCount) {
        this.count += addCount;
    }

    public JSONObject toJSON() {
        JSONObject infoJSON = new JSONObject();
        String className = this.entityClass.getName();
        String tableName = UMSyncEndpoint.getTableNameFromClass(this.entityClass);
        String pkField = UMSyncEndpoint.getPrimaryKeyFromClass(this.entityClass);
        infoJSON.put(ENTITY_INFO_CLASS_NAME, (Object)className);
        infoJSON.put(ENTITY_INFO_TABLE_NAME, (Object)tableName);
        infoJSON.put(ENTITY_INFO_COUNT, this.count);
        infoJSON.put(ENTITY_INFO_PRIMARY_KEY, (Object)pkField);
        return infoJSON;
    }

    public UMSyncInfo fromJSON(JSONObject infoJSON) throws ClassNotFoundException {
        String className = infoJSON.getString(ENTITY_INFO_CLASS_NAME);
        String tableNAme = infoJSON.getString(ENTITY_INFO_TABLE_NAME);
        int count = Integer.parseInt(infoJSON.getString(ENTITY_INFO_COUNT));
        String pkField = infoJSON.getString(ENTITY_INFO_PRIMARY_KEY);
        Class<?> entityClass = Class.forName(className);
        UMSyncInfo thisInfo = new UMSyncInfo(entityClass, count);
        return thisInfo;
    }
}

