/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.core.util;

import java.util.Calendar;
import java.util.TimeZone;

public class ParseUtil {
    public static final int MS_PER_HOUR = 3600000;
    public static final int MS_PER_MIN = 60000;
    public static final char[] TZ_START_CHARS = new char[]{'+', '-', '\u2212'};
    public static final int TZ_START_CHARS_PLUS = 0;

    public static String format8601Duration(long duration) {
        int msPerHour = 3600000;
        int hours = (int)Math.floor(duration / (long)msPerHour);
        long durationRemaining = duration % (long)msPerHour;
        int msPerMin = 60000;
        int mins = (int)Math.floor(durationRemaining / (long)msPerMin);
        int msPerS = 1000;
        int secs = (int)Math.floor((durationRemaining %= (long)msPerMin) / (long)msPerS);
        String retVal = "PT" + hours + "H" + mins + "M" + secs + "S";
        return retVal;
    }

    private static String pad0(int num) {
        if (num < 10) {
            return "0" + num;
        }
        return String.valueOf(num);
    }

    public static String format8601Timestamp(Calendar cal) {
        StringBuffer sb = new StringBuffer();
        long timeInMillis = cal.getTimeInMillis();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        int zoneOffset = cal.get(15);
        cal.setTimeInMillis(timeInMillis - (long)zoneOffset);
        cal.set(15, 0);
        cal.getTime();
        sb.append(cal.get(1)).append('-');
        sb.append(ParseUtil.pad0(cal.get(2) + 1)).append('-');
        sb.append(ParseUtil.pad0(cal.get(5))).append('T');
        sb.append(ParseUtil.pad0(cal.get(11))).append(':');
        sb.append(ParseUtil.pad0(cal.get(12))).append(":");
        sb.append(ParseUtil.pad0(cal.get(13))).append("+00:00");
        return sb.toString();
    }

    public static Calendar parse8601Timestamp(String timestamp) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, Integer.parseInt(timestamp.substring(0, 4)));
        cal.set(2, Integer.parseInt(timestamp.substring(5, 7)) - 1);
        cal.set(5, Integer.parseInt(timestamp.substring(8, 10)));
        if (timestamp.length() < 12) {
            return cal;
        }
        cal.set(11, Integer.parseInt(timestamp.substring(11, 13)));
        cal.set(12, Integer.parseInt(timestamp.substring(14, 16)));
        cal.set(13, Integer.parseInt(timestamp.substring(17, 19)));
        if (timestamp.length() < 20 || timestamp.indexOf(90, 19) != -1) {
            cal.set(15, 0);
            return cal;
        }
        int tzStartPos = -1;
        int tzMultiplier = 1;
        for (int i = 0; i < TZ_START_CHARS.length; ++i) {
            tzStartPos = timestamp.indexOf(TZ_START_CHARS[i], 19);
            if (tzStartPos == -1) continue;
            tzMultiplier = i == 0 ? 1 : -1;
            break;
        }
        if (tzStartPos != -1) {
            int tzHourOffset = 0;
            int tzMinOffset = 0;
            tzHourOffset = Integer.parseInt(timestamp.substring(tzStartPos + 1, tzStartPos + 3));
            if (timestamp.length() > tzStartPos + 3) {
                int tzMinPosOffset = timestamp.charAt(tzStartPos + 4) == ':' ? 1 : 0;
                tzMinOffset = Integer.parseInt(timestamp.substring(tzStartPos + 4 + tzMinPosOffset, tzStartPos + 6 + tzMinPosOffset));
            }
            cal.set(15, (tzHourOffset * 3600000 + tzMinOffset * 60000) * tzMultiplier);
        }
        return cal;
    }
}

