/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.http;

import com.ustadmobile.nanolrs.core.manager.NodeManager;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.Node;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.sync.UMSyncEndpoint;
import com.ustadmobile.nanolrs.core.sync.UMSyncResult;
import com.ustadmobile.nanolrs.core.util.Base64CoderNanoLrs;
import com.ustadmobile.nanolrs.core.util.LrsIoUtils;
import com.ustadmobile.nanolrs.http.NanoLrsHttpd;
import com.ustadmobile.nanolrs.http.NanoLrsResponder;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SyncUriResponder
extends NanoLrsResponder {
    private String getFirstParamVal(NanoHTTPD.IHTTPSession session, String paramName) {
        if (session.getParameters().containsKey(paramName)) {
            return (String)((List)session.getParameters().get(paramName)).get(0);
        }
        return null;
    }

    public static String getUsernameFromBasicAuth(String basicAuth) {
        String[] credentials = SyncUriResponder.getCredentialStringFromBasicAuth(basicAuth);
        if (credentials != null && credentials.length > 0) {
            return credentials[0];
        }
        return null;
    }

    public static String getPasswordFromBasicAuth(String basicAuth) {
        String[] credentials = SyncUriResponder.getCredentialStringFromBasicAuth(basicAuth);
        if (credentials != null && credentials.length > 0) {
            return credentials[1];
        }
        return null;
    }

    public static String[] getCredentialStringFromBasicAuth(String authorization) {
        if (authorization != null && authorization.startsWith("Basic")) {
            String base64Credentials = authorization.substring("Basic".length()).trim();
            String credentials = Base64CoderNanoLrs.decodeString((String)base64Credentials);
            String[] values = credentials.split(":", 2);
            return values;
        }
        return null;
    }

    public static String convertStreamToString2(InputStream is, String encoding) throws IOException {
        int rsz;
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, encoding);
        while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
            out.append(buffer, 0, rsz);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getRequestContent(NanoHTTPD.IHTTPSession session) {
        byte[] content = null;
        FileInputStream fin = null;
        try {
            HashMap map = new HashMap();
            session.parseBody(map);
            if (map.containsKey("content")) {
                String tmpFileName = (String)map.get("content");
                fin = new FileInputStream(tmpFileName);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                LrsIoUtils.copy((InputStream)fin, (OutputStream)bout);
                bout.flush();
                content = bout.toByteArray();
            } else if (map.containsKey("postData")) {
                content = ((String)map.get("postData")).getBytes("UTF-8");
            }
        }
        catch (NanoHTTPD.ResponseException | IOException e) {
            System.err.println("Exception getRequestContent");
            e.printStackTrace();
        }
        finally {
            LrsIoUtils.closeQuietly(fin);
        }
        return content;
    }

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        return null;
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        return null;
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        User existingUser;
        Object dbContext = uriResource.initParameter(0, Object.class);
        String thisURL = "http://" + session.getRemoteHostName() + session.getUri();
        byte[] postBodyReceived = NanoLrsHttpd.getRequestContent(session);
        String userUuid = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-useruuid");
        String username = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-username");
        String password = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-password");
        String isNewUser = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-isnewuser");
        String nodeUuid = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-nodeuuid");
        String nodetHostName = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-nodehost");
        String nodeHostUrl = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-nodeurl");
        String nodeRole = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-noderole");
        String basicAuth = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"Authorization");
        String syncStatus = UMSyncEndpoint.getHeader((Map)session.getHeaders(), (String)"X-UM-syncstatus");
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        String authUsername = SyncUriResponder.getUsernameFromBasicAuth(basicAuth);
        String authPassword = SyncUriResponder.getPasswordFromBasicAuth(basicAuth);
        if (authUsername != null && authPassword != null) {
            username = authUsername;
            password = authPassword;
        }
        User newUser = null;
        if (!userManager.authenticate(dbContext, username, password, true) && (existingUser = userManager.findByUsername(dbContext, username)) == null && isNewUser.equals("true")) {
            try {
                newUser = (User)userManager.makeNew();
                newUser.setUuid(userUuid);
                newUser.setUsername(username);
                if (password != null && !password.isEmpty()) {
                    try {
                        password = userManager.hashPassword(password);
                    }
                    catch (NoSuchAlgorithmException e) {
                        System.out.println("Cannot hash password.: " + e);
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                newUser.setPassword(password);
                userManager.persist(dbContext, (NanoLrsModel)newUser);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        NodeManager nodeManager = (NodeManager)pm.getManager(NodeManager.class);
        Node node = null;
        try {
            node = (Node)nodeManager.findByPrimaryKey(dbContext, (Object)nodeUuid);
            if (node == null) {
                node = (Node)nodeManager.makeNew();
                node.setUUID(nodeUuid);
                node.setUrl(nodeHostUrl);
                node.setName(nodetHostName);
                node.setHost(nodetHostName);
                node.setRole(nodeRole);
                if (nodeRole.equals("proxy")) {
                    node.setProxy(true);
                }
                if (nodeRole.equals("main")) {
                    node.setMaster(true);
                }
                nodeManager.persist(dbContext, (NanoLrsModel)node);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("X-UM-useruuid", userUuid);
        reqHeaders.put("X-UM-username", username);
        reqHeaders.put("X-UM-password", password);
        reqHeaders.put("X-UM-isnewuser", isNewUser);
        reqHeaders.put("X-UM-nodeuuid", nodeUuid);
        reqHeaders.put("X-UM-nodehost", nodetHostName);
        reqHeaders.put("X-UM-nodeurl", nodeHostUrl);
        reqHeaders.put("X-UM-noderole", nodeRole);
        reqHeaders.put("X-UM-syncstatus", syncStatus);
        reqHeaders.put("Authorization", basicAuth);
        HashMap reqParams = new HashMap();
        ByteArrayInputStream sessionStream = new ByteArrayInputStream(postBodyReceived);
        UMSyncResult result = null;
        try {
            result = UMSyncEndpoint.handleIncomingSync((InputStream)sessionStream, (Node)node, reqHeaders, (Map)session.getParameters(), (Object)dbContext);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NanoHTTPD.Response.Status status = null;
        syncStatus = "FAIL";
        switch (result.getStatus()) {
            case 200: {
                status = NanoHTTPD.Response.Status.OK;
                syncStatus = "OK";
                break;
            }
            default: {
                status = NanoHTTPD.Response.Status.INTERNAL_ERROR;
                if (newUser == null) break;
                userManager.delete(dbContext, newUser);
            }
        }
        status = NanoHTTPD.Response.Status.lookup((int)result.getStatus());
        NanoHTTPD.Response added = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)status, (String)"application/json", (InputStream)result.getResponseData(), (long)result.getResponseLength());
        Map sessionHeaders = session.getHeaders();
        Iterator iterator = sessionHeaders.entrySet().iterator();
        long headerSize = 0L;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            headerSize = headerSize + (long)((String)entry.getKey()).length() + (long)((String)entry.getValue()).length();
        }
        added.addHeader("X-UM-syncstatus", syncStatus);
        return added;
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        return null;
    }
}

