/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.http;

import com.ustadmobile.nanolrs.core.endpoints.XapiStateEndpoint;
import com.ustadmobile.nanolrs.core.model.XapiState;
import com.ustadmobile.nanolrs.http.NanoLrsHttpd;
import com.ustadmobile.nanolrs.http.NanoLrsResponder;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class StateUriResponder
extends NanoLrsResponder
implements RouterNanoHTTPD.UriResponder {
    private String getFirstParamVal(NanoHTTPD.IHTTPSession session, String paramName) {
        if (session.getParameters().containsKey(paramName)) {
            return (String)((List)session.getParameters().get(paramName)).get(0);
        }
        return null;
    }

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        String activityId = this.getFirstParamVal(session, "activityId");
        String agentJson = this.getFirstParamVal(session, "agent");
        String registration = this.getFirstParamVal(session, "registration");
        String stateId = this.getFirstParamVal(session, "stateId");
        Object dbContext = uriResource.initParameter(0, Object.class);
        XapiState stateProxy = XapiStateEndpoint.getState((Object)dbContext, (String)activityId, (String)agentJson, (String)registration, (String)stateId);
        if (stateProxy == null) {
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"Not Found");
        }
        byte[] stateData = stateProxy.getContent();
        ByteArrayInputStream bin = new ByteArrayInputStream(stateData);
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)stateProxy.getContentType(), (InputStream)bin, (long)stateData.length);
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        return this.processSaveState(uriResource, urlParams, session);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        return this.processSaveState(uriResource, urlParams, session);
    }

    private NanoHTTPD.Response processSaveState(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        String activityId = this.getFirstParamVal(session, "activityId");
        String agentJson = this.getFirstParamVal(session, "agent");
        String registration = this.getFirstParamVal(session, "registration");
        String stateId = this.getFirstParamVal(session, "stateId");
        if (activityId == null || agentJson == null || stateId == null) {
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)("Missing required parameters: sent " + urlParams.toString()));
        }
        byte[] stateData = NanoLrsHttpd.getRequestContent(session);
        Object dbContext = uriResource.initParameter(0, Object.class);
        XapiStateEndpoint.createOrUpdateState((Object)dbContext, (String)session.getMethod().toString(), (String)((String)session.getHeaders().get("content-type")), (String)activityId, (String)agentJson, (String)registration, (String)stateId, (byte[])stateData);
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NO_CONTENT, (String)"application/json", null);
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        String activityId = this.getFirstParamVal(session, "activityId");
        String agentJson = this.getFirstParamVal(session, "agent");
        String registration = this.getFirstParamVal(session, "registration");
        String stateId = this.getFirstParamVal(session, "stateId");
        Object dbContext = uriResource.initParameter(0, Object.class);
        XapiStateEndpoint.delete((Object)dbContext, (String)activityId, (String)agentJson, (String)registration, (String)stateId);
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NO_CONTENT, (String)"application/json", null);
    }
}

