/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.NanoLrsModelSyncable;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiAgentEntity;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLiteSyncable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class XapiAgentManagerOrmLite
extends BaseManagerOrmLiteSyncable
implements XapiAgentManager {
    @Override
    public Class getEntityImplementationClasss() {
        return XapiAgentEntity.class;
    }

    public List<XapiAgent> findAgentByParams(Object dbContext, String mbox, String accountName, String accountHomepage) {
        if (mbox == null && (accountName == null || accountHomepage == null)) {
            throw new IllegalArgumentException("findAgentByParams MUST have at least mbox or accountName and accountHomepage");
        }
        try {
            Object dao = this.persistenceManager.getDao(XapiAgentEntity.class, dbContext);
            QueryBuilder<XapiAgentEntity, String> queryBuilder = XapiAgentManagerOrmLite.makeAgentQuery(dao, mbox, accountName, accountHomepage);
            List results = dao.query(queryBuilder.prepare());
            return results;
        }
        catch (SQLException e) {
            System.err.println("Exception in findAgentByParams");
            e.printStackTrace();
            return null;
        }
    }

    protected static QueryBuilder<XapiAgentEntity, String> makeAgentQuery(Dao<XapiAgentEntity, String> dao, String mbox, String accountName, String accountHomepage) throws SQLException {
        QueryBuilder queryBuilder = dao.queryBuilder();
        Where where = queryBuilder.where();
        if (mbox != null) {
            where.eq("mbox", (Object)mbox);
        }
        if (accountName != null && accountHomepage != null) {
            if (mbox != null) {
                where.and();
            }
            where.and(where.eq("account_name", (Object)accountName), where.eq("account_homepage", (Object)accountHomepage), new Where[0]);
        }
        return queryBuilder;
    }

    public XapiAgent makeNew(Object dbContext) {
        return new XapiAgentEntity();
    }

    public List<NanoLrsModelSyncable> findAllRelatedToUser(Object dbContext, User user) throws SQLException {
        XapiAgentManager agentManager = (XapiAgentManager)PersistenceManager.getInstance().getManager(XapiAgentManager.class);
        List usersCorrespondingAgents = agentManager.findByUser(dbContext, user);
        List usersCorrespondingAgentsSyncable = null;
        Iterator agentIterator = usersCorrespondingAgents.iterator();
        while (agentIterator.hasNext()) {
            usersCorrespondingAgentsSyncable.add((XapiAgent)agentIterator.next());
        }
        if (usersCorrespondingAgents != null && !usersCorrespondingAgents.isEmpty() && usersCorrespondingAgentsSyncable != null) {
            return usersCorrespondingAgentsSyncable;
        }
        return null;
    }

    public PreparedQuery findAllRelatedToUserQuery(Object dbContext, User user) throws SQLException {
        Object dao = this.persistenceManager.getDao(XapiAgentEntity.class, dbContext);
        QueryBuilder qb = dao.queryBuilder();
        QueryBuilder qbSelect = qb.selectColumns(new String[]{"uuid"});
        Where where = qbSelect.where();
        where.eq("user", (Object)user.getUsername());
        PreparedQuery pq = qbSelect.prepare();
        return pq;
    }

    public void createOrUpdate(Object dbContext, XapiAgent data) {
        try {
            this.persist(dbContext, (NanoLrsModel)data);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<XapiAgent> findByUser(Object dbContext, User user) throws SQLException {
        Object dao = this.persistenceManager.getDao(XapiAgentEntity.class, dbContext);
        QueryBuilder qb = dao.queryBuilder();
        Where where = qb.where();
        where.eq("user", (Object)user.getUsername());
        PreparedQuery pq = qb.prepare();
        List agents = dao.query(pq);
        if (agents != null && !agents.isEmpty()) {
            return agents;
        }
        return null;
    }
}

