/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.manager.XapiStatementManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.NanoLrsModelSyncable;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.model.XapiStatement;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.persistence.PersistenceReceiver;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiActivityEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiAgentEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiForwardingStatementEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiStateEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiStatementEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiVerbEntity;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLiteSyncable;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;

public class XapiStatementManagerOrmLite
extends BaseManagerOrmLiteSyncable
implements XapiStatementManager {
    public static Class[] RELATED_ORM_ENTITIES = new Class[]{XapiActivityEntity.class, XapiAgentEntity.class, XapiForwardingStatementEntity.class, XapiStateEntity.class, XapiVerbEntity.class};

    @Override
    public Class getEntityImplementationClasss() {
        return XapiStatementEntity.class;
    }

    public List<NanoLrsModelSyncable> findAllRelatedToUser(Object dbContext, User user) throws SQLException {
        long localSeq = 0L;
        Object thisDao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
        QueryBuilder subQueryQB = thisDao.queryBuilder();
        QueryBuilder subQueryQBColumn = subQueryQB.selectColumns(new String[]{"uuid"});
        Where subQueryColumnWhere = subQueryQBColumn.where();
        subQueryColumnWhere.eq("agent", (Object)user).or().eq("actor", (Object)user);
        subQueryColumnWhere.and().gt("local_sequence", (Object)localSeq);
        PreparedQuery subQueryColumnPQ = subQueryQBColumn.prepare();
        Object xapiActivityDao = this.persistenceManager.getDao(XapiActivityEntity.class, dbContext);
        Object xapiAgentDao = this.persistenceManager.getDao(XapiAgentEntity.class, dbContext);
        Object xapiForwardingStatementDao = this.persistenceManager.getDao(XapiForwardingStatementEntity.class, dbContext);
        Object xapiStateDao = this.persistenceManager.getDao(XapiStateEntity.class, dbContext);
        Object xapiVerbDao = this.persistenceManager.getDao(XapiVerbEntity.class, dbContext);
        QueryBuilder xapiActivityQB = xapiActivityDao.queryBuilder();
        QueryBuilder xapiAgentQB = xapiAgentDao.queryBuilder();
        QueryBuilder xapiForwardingStatementQB = xapiForwardingStatementDao.queryBuilder();
        QueryBuilder xapiStateQB = xapiStateDao.queryBuilder();
        QueryBuilder xapiVerbQB = xapiVerbDao.queryBuilder();
        Where xapiActivityWhere = xapiActivityQB.where();
        Where xapiAgentWhere = xapiAgentQB.where();
        Where xapiForwardingStatementWhere = xapiForwardingStatementQB.where();
        Where xapiStateWhere = xapiStateQB.where();
        Where xapiVerbWhere = xapiVerbQB.where();
        return null;
    }

    public PreparedQuery findAllRelatedToUserQuery(Object dbContext, User user) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
        XapiAgentManager agentManager = (XapiAgentManager)PersistenceManager.getInstance().getManager(XapiAgentManager.class);
        QueryBuilder subQueryQB = thisDao.queryBuilder();
        QueryBuilder subQueryQBColumn = subQueryQB.selectColumns(new String[]{"uuid"});
        Where subQueryColumnWhere = subQueryQBColumn.where();
        List usersCorrespondingAgents = agentManager.findByUser(dbContext, user);
        if (usersCorrespondingAgents == null || usersCorrespondingAgents.isEmpty() || usersCorrespondingAgents.size() != 1) {
            return null;
        }
        XapiAgent userCorrespondingAgent = (XapiAgent)usersCorrespondingAgents.get(0);
        subQueryColumnWhere.eq("agent", (Object)userCorrespondingAgent.getUuid()).or().eq("actor", (Object)userCorrespondingAgent.getUuid());
        PreparedQuery subQueryColumnPQ = subQueryQBColumn.prepare();
        return subQueryColumnPQ;
    }

    public void findByUuid(Object dbContext, int requestId, PersistenceReceiver receiver, String uuid) {
        XapiStatement stmt = this.findByUuidSync(dbContext, uuid);
        if (stmt != null) {
            receiver.onPersistenceSuccess((Object)stmt, requestId);
        } else {
            receiver.onPersistenceFailure(null, requestId);
        }
    }

    public XapiStatement findByUuidSync(Object dbContext, String uuid) {
        XapiStatementEntity result = null;
        try {
            Object dao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
            result = (XapiStatementEntity)dao.queryForId((Object)uuid);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void create(Object dbContext, int requestId, PersistenceReceiver receiver) {
        XapiStatement entity = this.createSync(dbContext);
        if (entity != null) {
            receiver.onPersistenceSuccess((Object)entity, requestId);
        } else {
            receiver.onPersistenceFailure((Object)"err", requestId);
        }
    }

    public XapiStatement createSync(Object dbContext) {
        XapiStatementEntity obj = null;
        try {
            Object dao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
            obj = new XapiStatementEntity();
            obj.setUuid(UUID.randomUUID().toString());
            dao.create((Object)obj);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public void persistSync(Object dbContext, XapiStatement stmt) {
        try {
            super.persist(dbContext, (NanoLrsModel)stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<? extends XapiStatement> findByParams(Object dbContext, String statementid, String voidedStatemendid, XapiAgent agent, String verb, String activity, String registration, boolean relatedActivities, boolean relatedAgents, long since, long until, int limit) {
        try {
            Object dao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
            QueryBuilder queryBuilder = dao.queryBuilder();
            Where where = queryBuilder.where();
            boolean whereHasClauses = false;
            if (statementid != null) {
                where.eq("uuid", (Object)statementid);
                whereHasClauses = true;
            }
            if (agent != null) {
                if (whereHasClauses) {
                    where.and();
                }
                where.eq("agent", (Object)agent.getUuid());
                whereHasClauses = true;
            }
            if (verb != null) {
                if (whereHasClauses) {
                    where.and();
                }
                where.eq("verb", (Object)verb);
                whereHasClauses = true;
            }
            if (activity != null) {
                if (whereHasClauses) {
                    where.and();
                }
                where.eq("activity", (Object)activity);
                whereHasClauses = true;
            }
            if (registration != null) {
                if (whereHasClauses) {
                    where.and();
                }
                where.eq("context_registration", (Object)registration);
                whereHasClauses = true;
            }
            if (since >= 0L) {
                if (whereHasClauses) {
                    where.and();
                }
                where.gt("timestamp", (Object)since);
                whereHasClauses = true;
            }
            if (until >= 0L) {
                if (whereHasClauses) {
                    where.and();
                }
                where.le("timestamp", (Object)until);
                whereHasClauses = true;
            }
            if (limit > 0) {
                queryBuilder.limit(Long.valueOf(limit));
            }
            queryBuilder.orderBy("timestamp", false);
            return dao.query(queryBuilder.prepare());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<? extends XapiStatement> findByProgress(Object dbContext, String[] activityIds, XapiAgent agent, String registration, String[] verbIds, int minProgress) {
        try {
            int i;
            Object dao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
            QueryBuilder queryBuilder = dao.queryBuilder();
            Where where = queryBuilder.where();
            for (i = 0; i < verbIds.length; ++i) {
                where.eq("verb", (Object)verbIds[i]);
            }
            where.or(verbIds.length);
            for (i = 0; i < activityIds.length; ++i) {
                where.like("activity", (Object)(activityIds[i] + "%"));
            }
            where.or(activityIds.length);
            where.eq("agent", (Object)agent.getUuid());
            if (registration != null) {
                where.eq("context_registration", (Object)registration);
            }
            where.gt("result_progress", (Object)minProgress);
            where.and(registration != null ? 5 : 4);
            queryBuilder.orderBy("timestamp", false);
            return dao.query(queryBuilder.prepare());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

