/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.PrimaryKeyAnnotationClass;
import com.ustadmobile.nanolrs.core.manager.ChangeSeqManager;
import com.ustadmobile.nanolrs.core.manager.NanoLrsManagerSyncable;
import com.ustadmobile.nanolrs.core.manager.NodeManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.NanoLrsModelSyncable;
import com.ustadmobile.nanolrs.core.model.Node;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLite;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseManagerOrmLiteSyncable<T extends NanoLrsModelSyncable, P>
extends BaseManagerOrmLite
implements NanoLrsManagerSyncable<T, P> {
    public static String convertCamelCaseNameToUnderscored(String propertyName) {
        String undererScoredName = "";
        for (int i = 0; i < propertyName.length(); ++i) {
            if (Character.isUpperCase(propertyName.charAt(i)) && (i == 0 || Character.isLowerCase(propertyName.charAt(i - 1)))) {
                undererScoredName = undererScoredName + "_";
            }
            undererScoredName = undererScoredName + Character.toLowerCase(propertyName.charAt(i));
        }
        return undererScoredName;
    }

    public String getPrimaryKeyFromEntity(Class syncableEntity) {
        Class<?> syncableProxy = syncableEntity.getInterfaces()[0];
        Method[] allEntityMethods = syncableProxy.getMethods();
        String pkMethod = null;
        String pkField = null;
        for (Method method : allEntityMethods) {
            if (!method.isAnnotationPresent(PrimaryKeyAnnotationClass.class)) continue;
            pkMethod = method.getName();
            break;
        }
        if (pkMethod == null) {
            pkField = "uuid";
        } else {
            int prefixLen = 0;
            if (pkMethod.startsWith("is")) {
                prefixLen = 2;
            } else if (pkMethod.startsWith("get")) {
                prefixLen = 3;
            }
            pkField = Character.toLowerCase(pkMethod.charAt(3)) + pkMethod.substring(prefixLen + 1);
        }
        return BaseManagerOrmLiteSyncable.convertCamelCaseNameToUnderscored(pkField);
    }

    public List<NanoLrsModel> getAllSinceTwoDates(long fromDate, long toDate, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(this.getEntityImplementationClasss(), dbContext);
        QueryBuilder qb = thisDao.queryBuilder();
        Where where = qb.where();
        where.gt("date_created", (Object)fromDate);
        where.and().lt("date_created", (Object)toDate);
        PreparedQuery pq = qb.prepare();
        System.out.println(pq.getStatement());
        List entities = thisDao.query(pq);
        return entities;
    }

    public List<NanoLrsModel> getAllSinceSequenceNumber(User user, Object dbContext, String host, long seqNum) throws SQLException {
        return this.getAllSinceTwoSequenceNumber(user, host, seqNum, -1L, dbContext);
    }

    public List<NanoLrsModel> getAllSinceTwoSequenceNumber(User user, String host, long fromSeqNum, long toSeqNum, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(this.getEntityImplementationClasss(), dbContext);
        ArrayList<String> uuidList = new ArrayList<String>();
        ArrayList<NanoLrsModel> blank = new ArrayList<NanoLrsModel>();
        if (user == null) {
            return blank;
        }
        PreparedQuery<NanoLrsModel> subQueryPQ = this.findAllRelatedToUserQuery(dbContext, user);
        if (subQueryPQ == null) {
            return blank;
        }
        List subQueryColResultSingle = thisDao.queryRaw(subQueryPQ.getStatement(), new String[0]).getResults();
        for (String[] thisEntry : subQueryColResultSingle) {
            if (thisEntry[0] == null) continue;
            uuidList.add(thisEntry[0]);
        }
        if (uuidList.isEmpty()) {
            return blank;
        }
        String pkField = this.getPrimaryKeyFromEntity(this.getEntityImplementationClasss());
        QueryBuilder qbIfMasterSeqNull = thisDao.queryBuilder();
        Where whereMasterSeqNullAndCSGTSN = qbIfMasterSeqNull.where();
        Long to = toSeqNum;
        whereMasterSeqNullAndCSGTSN.lt("master_sequence", (Object)1);
        if (toSeqNum == 0L && fromSeqNum == 0L) {
            whereMasterSeqNullAndCSGTSN.and().gt("local_sequence", (Object)fromSeqNum);
        } else if (to != -1L) {
            whereMasterSeqNullAndCSGTSN.and().gt("local_sequence", (Object)fromSeqNum).and().lt("local_sequence", (Object)toSeqNum);
        } else {
            whereMasterSeqNullAndCSGTSN.and().gt("local_sequence", (Object)fromSeqNum);
        }
        whereMasterSeqNullAndCSGTSN.and().in(pkField, uuidList);
        PreparedQuery getAllWhereMSNullAndCSGTSN = qbIfMasterSeqNull.prepare();
        List foundAllWhereMSNullAndCSGTSN = thisDao.query(getAllWhereMSNullAndCSGTSN);
        if (foundAllWhereMSNullAndCSGTSN.isEmpty()) {
            QueryBuilder qb = thisDao.queryBuilder();
            Where whereNotSent = qb.where();
            whereNotSent.gt("local_sequence", (Object)fromSeqNum);
            whereNotSent.and().in(pkField, uuidList);
            PreparedQuery getAllNewPreparedQuery = qb.prepare();
            List foundNewEntriesListModel = thisDao.query(getAllNewPreparedQuery);
            return foundNewEntriesListModel;
        }
        return foundAllWhereMSNullAndCSGTSN;
    }

    public void persist(Object dbContext, NanoLrsModel data) throws SQLException {
        this.persist(dbContext, data, true);
    }

    public void persist(Object dbContext, NanoLrsModel data, boolean incrementChangeSeq) throws SQLException {
        NanoLrsModelSyncable dataS = (NanoLrsModelSyncable)data;
        ChangeSeqManager changeSeqManager = (ChangeSeqManager)PersistenceManager.getInstance().getManager(ChangeSeqManager.class);
        Object thisDao = this.persistenceManager.getDao(this.getEntityImplementationClasss(), dbContext);
        String tableName = ((BaseDaoImpl)thisDao).getTableInfo().getTableName();
        tableName = tableName.toUpperCase();
        Long dateCreated = dataS.getDateCreated();
        if (dateCreated == null || dataS.getDateCreated() < 1L) {
            dataS.setDateCreated(System.currentTimeMillis());
        }
        NodeManager nodeManager = (NodeManager)PersistenceManager.getInstance().getManager(NodeManager.class);
        Node thisNode = nodeManager.getThisNode(dbContext);
        long setLocalSeq = dataS.getLocalSequence();
        long nextChangeSeq = -1L;
        if (Long.valueOf(setLocalSeq) != null && setLocalSeq > -1L) {
            nextChangeSeq = setLocalSeq + 1L;
        }
        if (incrementChangeSeq) {
            long setThis = changeSeqManager.getNextChangeAddSeqByTableName(tableName, 1, dbContext);
            dataS.setLocalSequence(setThis);
            if (thisNode != null) {
                if (thisNode.isMaster()) {
                    dataS.setMasterSequence(setThis);
                } else if (dataS.getMasterSequence() != -1L) {
                    dataS.setMasterSequence(0L);
                }
            }
        } else if (nextChangeSeq > 0L) {
            changeSeqManager.setNextChangeSeqNumByTableName(tableName, nextChangeSeq, dbContext);
        }
        super.persist(dbContext, dataS);
    }

    public long getLatestMasterSequence(Object dbContext) throws SQLException {
        return 42L;
    }

    public abstract List<NanoLrsModel> findAllRelatedToUser(Object var1, User var2) throws SQLException;

    public abstract PreparedQuery<NanoLrsModel> findAllRelatedToUserQuery(Object var1, User var2) throws SQLException;
}

