/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.manager.SyncStatusManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.SyncStatus;
import com.ustadmobile.nanolrs.ormlite.generated.model.SyncStatusEntity;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLite;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;

public class SyncStatusManagerOrmLite
extends BaseManagerOrmLite
implements SyncStatusManager {
    public void persist(Object dbContext, NanoLrsModel data) throws SQLException {
        super.persist(dbContext, data);
    }

    @Override
    public Class getEntityImplementationClasss() {
        return SyncStatusEntity.class;
    }

    public String convertCamelCaseNameToUnderscored(String propertyName) {
        String undererScoredName = "";
        for (int i = 0; i < propertyName.length(); ++i) {
            if (Character.isUpperCase(propertyName.charAt(i)) && (i == 0 || Character.isLowerCase(propertyName.charAt(i - 1)))) {
                undererScoredName = undererScoredName + "_";
            }
            undererScoredName = undererScoredName + Character.toLowerCase(propertyName.charAt(i));
        }
        return undererScoredName;
    }

    public long getSentStatus(String host, Class entity, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(this.getEntityImplementationClasss(), dbContext);
        String table_name = this.convertCamelCaseNameToUnderscored(Character.toLowerCase(entity.getSimpleName().charAt(0)) + entity.getSimpleName().substring(1));
        table_name = table_name.toUpperCase();
        QueryBuilder qb = thisDao.queryBuilder();
        Where whereHostTableIs = qb.where();
        whereHostTableIs.eq("host", (Object)host).and().eq("table", (Object)table_name);
        PreparedQuery getAllForHostQuery = qb.prepare();
        List syncStatusesForHost = thisDao.query(getAllForHostQuery);
        if (syncStatusesForHost.isEmpty()) {
            SyncStatusEntity newHostForEntity = (SyncStatusEntity)this.makeNew();
            newHostForEntity.setTable(table_name);
            newHostForEntity.setHost(host);
            newHostForEntity.setNotes("First sync");
            newHostForEntity.setSentSeq(0L);
            newHostForEntity.setReceivedSeq(0L);
            newHostForEntity.setUUID(UUID.randomUUID().toString());
            thisDao.createOrUpdate((Object)newHostForEntity);
            return 0L;
        }
        return ((SyncStatus)syncStatusesForHost.get(0)).getSentSeq();
    }

    public boolean updateSyncStatusSeqNum(String host, Class entity, long newSentSeq, long newRecSeq, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(this.getEntityImplementationClasss(), dbContext);
        SyncStatus syncStatus = (SyncStatus)this.getSyncStatus(host, entity, dbContext);
        if (newRecSeq < 0L && newSentSeq > 0L) {
            syncStatus.setSentSeq(newSentSeq);
            thisDao.createOrUpdate((Object)syncStatus);
        } else if (newRecSeq > 0L && newSentSeq < 0L) {
            syncStatus.setReceivedSeq(newRecSeq);
            thisDao.createOrUpdate((Object)syncStatus);
        } else if (newRecSeq > 0L && newSentSeq > 0L) {
            syncStatus.setSentSeq(newSentSeq);
            syncStatus.setReceivedSeq(newRecSeq);
            thisDao.createOrUpdate((Object)syncStatus);
        } else {
            return false;
        }
        return true;
    }

    public NanoLrsModel getSyncStatus(String host, Class entity, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(this.getEntityImplementationClasss(), dbContext);
        String table_name = this.convertCamelCaseNameToUnderscored(Character.toLowerCase(entity.getSimpleName().charAt(0)) + entity.getSimpleName().substring(1));
        table_name = table_name.toUpperCase();
        QueryBuilder qb = thisDao.queryBuilder();
        Where whereHostTableIs = qb.where();
        whereHostTableIs.eq("host", (Object)host).and().eq("table", (Object)table_name);
        PreparedQuery getAllForHostQuery = qb.prepare();
        List syncStatusesForHost = thisDao.query(getAllForHostQuery);
        if (syncStatusesForHost.isEmpty()) {
            SyncStatusEntity newHostForEntity = (SyncStatusEntity)this.makeNew();
            newHostForEntity.setTable(table_name);
            newHostForEntity.setHost(host);
            newHostForEntity.setNotes("First sync");
            newHostForEntity.setSentSeq(0L);
            newHostForEntity.setReceivedSeq(0L);
            newHostForEntity.setUUID(UUID.randomUUID().toString());
            thisDao.createOrUpdate((Object)newHostForEntity);
            return newHostForEntity;
        }
        return (NanoLrsModel)syncStatusesForHost.get(0);
    }
}

