/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.NanoLrsModelSyncable;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.util.AeSimpleSHA1;
import com.ustadmobile.nanolrs.ormlite.generated.model.UserEntity;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLiteSyncable;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.List;

public class UserManagerOrmLite
extends BaseManagerOrmLiteSyncable
implements UserManager {
    @Override
    public Class getEntityImplementationClasss() {
        return UserEntity.class;
    }

    public List<NanoLrsModelSyncable> findAllRelatedToUser(Object dbContext, User user) throws SQLException {
        return null;
    }

    @Override
    public void persist(Object dbContext, NanoLrsModel data) throws SQLException {
        User user = (User)data;
        String givenUsername = user.getUsername();
        String newUsername = null;
        User existingUser = this.findByUsername(dbContext, givenUsername);
        if (existingUser == null) {
            User usersWithSameUsername = this.findByUsername(dbContext, givenUsername);
            if (usersWithSameUsername != null) {
                newUsername = givenUsername + (int)Math.floor(Math.random() * 101.0);
                ((User)data).setUsername(newUsername);
                super.persist(dbContext, data);
            }
        } else {
            System.out.println("\nUser getting an update.\n\n");
        }
        super.persist(dbContext, data);
    }

    public PreparedQuery findAllRelatedToUserQuery(Object dbContext, User user) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(UserEntity.class, dbContext);
        QueryBuilder subQueryQB = thisDao.queryBuilder();
        QueryBuilder subQueryQBColumn = subQueryQB.selectColumns(new String[]{"username"});
        Where subQueryColumnWhere = subQueryQBColumn.where();
        subQueryColumnWhere.eq("username", (Object)user.getUsername());
        PreparedQuery subQueryColumnPQ = subQueryQBColumn.prepare();
        return subQueryColumnPQ;
    }

    public User createSync(Object dbContext, String id) {
        UserEntity created = new UserEntity();
        created.setUuid(id);
        return created;
    }

    public User findById(Object dbContext, String id) {
        try {
            Object dao = this.persistenceManager.getDao(UserEntity.class, dbContext);
            return (User)dao.queryForId((Object)id);
        }
        catch (SQLException e) {
            System.err.println("Exception findById");
            e.printStackTrace();
            return null;
        }
    }

    public User findByUsername(Object dbContext, String username) {
        try {
            Object dao = this.persistenceManager.getDao(UserEntity.class, dbContext);
            return (User)dao.queryForId((Object)username);
        }
        catch (Exception e) {
            System.err.println("Exception findByUsername");
            e.printStackTrace();
            return null;
        }
    }

    public void delete(Object dbContext, User data) {
        try {
            Object dao = this.persistenceManager.getDao(UserEntity.class, dbContext);
            dao.delete((Object)((UserEntity)data));
        }
        catch (SQLException e) {
            System.err.println("exception deleting");
            e.printStackTrace();
        }
    }

    public boolean authenticate(Object dbContext, String username, String password) {
        User user = this.findByUsername(dbContext, username);
        if (user == null) {
            return false;
        }
        if (user.getUsername() == null || password == null) {
            return false;
        }
        if (user.getPassword() == null || password == null) {
            return false;
        }
        return user.getPassword().equals(password);
    }

    public boolean updatePassword(String password, User user, Object dbContext) throws UnsupportedEncodingException, NoSuchAlgorithmException, SQLException {
        if (password != null && !password.isEmpty()) {
            String hashPassword = AeSimpleSHA1.SHA1((String)password);
            user.setPassword(hashPassword);
            this.persist(dbContext, (NanoLrsModel)user);
            return true;
        }
        return false;
    }

    public boolean updateUsername(String newUsername, User user, Object dbContext) throws SQLException {
        XapiAgentManager agentManager = (XapiAgentManager)PersistenceManager.getInstance().getManager(XapiAgentManager.class);
        user.setUsername(newUsername);
        this.persist(dbContext, (NanoLrsModel)user);
        User newUser = this.findByUsername(dbContext, newUsername);
        List usersAgents = agentManager.findByUser(dbContext, user);
        XapiAgent usersAgent = (XapiAgent)usersAgents.get(0);
        usersAgent.setUser(newUser);
        agentManager.persist(dbContext, (NanoLrsModel)usersAgent);
        return true;
    }
}

