/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.manager.NodeManager;
import com.ustadmobile.nanolrs.core.model.Node;
import com.ustadmobile.nanolrs.ormlite.generated.model.NodeEntity;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLite;
import java.sql.SQLException;
import java.util.List;

public class NodeManagerOrmLite
extends BaseManagerOrmLite
implements NodeManager {
    @Override
    public Class getEntityImplementationClasss() {
        return NodeEntity.class;
    }

    public List<Node> getNodesByRoleName(Object dbContext, String role_name) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(NodeEntity.class, dbContext);
        QueryBuilder qb = thisDao.queryBuilder();
        List allNodes = thisDao.query(qb.where().eq("role", (Object)role_name).prepare());
        return allNodes;
    }

    public List<Node> getProxys(Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(NodeEntity.class, dbContext);
        List<Node> proxyNodes = this.getNodesByRoleName(dbContext, "proxy");
        if (proxyNodes != null && !proxyNodes.isEmpty()) {
            return proxyNodes;
        }
        return null;
    }

    public List<Node> getClients(Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(NodeEntity.class, dbContext);
        List<Node> clientNodes = this.getNodesByRoleName(dbContext, "client");
        if (clientNodes != null && !clientNodes.isEmpty()) {
            return clientNodes;
        }
        return null;
    }

    public Node getThisNode(Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(NodeEntity.class, dbContext);
        List<Node> thisNodes = this.getNodesByRoleName(dbContext, "this_node");
        if (thisNodes != null && !thisNodes.isEmpty()) {
            return thisNodes.get(0);
        }
        return null;
    }

    public Node createThisDeviceNode(String uuid, String thisNodeName, String thisHostName, String endpointUrl, boolean isMaster, boolean isProxy, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(NodeEntity.class, dbContext);
        Node thisNode = this.getThisNode(dbContext);
        if (thisNode == null) {
            thisNode = (Node)this.makeNew();
            thisNode.setUrl(endpointUrl);
            thisNode.setUUID(uuid);
            thisNode.setName(thisNodeName);
            thisNode.setStoredDate(System.currentTimeMillis());
            thisNode.setHost(thisHostName);
            thisNode.setNotes("this_node");
            thisNode.setRole("this_node");
            thisNode.setMaster(isMaster);
            thisNode.setProxy(isProxy);
            thisDao.createOrUpdate((Object)thisNode);
        }
        if (thisNode.getHost() == null || thisNode.getHost().startsWith("host:")) {
            thisNode.setHost(thisHostName);
            thisDao.createOrUpdate((Object)thisNode);
            thisNode = this.getThisNode(dbContext);
        }
        return thisNode;
    }

    public List<Node> getAllMainNodes(Object dbContext) throws SQLException {
        QueryBuilder qb;
        Object thisDao = this.persistenceManager.getDao(NodeEntity.class, dbContext);
        List allMainNodes = thisDao.query((qb = thisDao.queryBuilder()).where().eq("master", (Object)true).prepare());
        if (allMainNodes != null && !allMainNodes.isEmpty()) {
            return allMainNodes;
        }
        return null;
    }

    public Node getMainNode(String host_name, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(NodeEntity.class, dbContext);
        QueryBuilder qb3 = thisDao.queryBuilder();
        Where where3 = qb3.where();
        where3.eq("master", (Object)true).and().eq("host", (Object)host_name);
        PreparedQuery pq3 = qb3.prepare();
        List allMainNodes = thisDao.query(pq3);
        if (allMainNodes != null && !allMainNodes.isEmpty()) {
            return (Node)allMainNodes.get(0);
        }
        return null;
    }

    public boolean doesThisMainNodeExist(String host_name, Object dbContext) throws SQLException {
        Node mainNode = this.getMainNode(host_name, dbContext);
        return mainNode != null && mainNode.isMaster();
    }
}

