/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.manager.UserCustomFieldsManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.UserCustomFields;
import com.ustadmobile.nanolrs.ormlite.generated.model.UserCustomFieldsEntity;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLiteSyncable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class UserCustomFieldsManagerOrmLite
extends BaseManagerOrmLiteSyncable
implements UserCustomFieldsManager {
    @Override
    public Class getEntityImplementationClasss() {
        return UserCustomFieldsEntity.class;
    }

    @Override
    public List<NanoLrsModel> findAllRelatedToUser(Object dbContext, User user) throws SQLException {
        return null;
    }

    @Override
    public PreparedQuery<NanoLrsModel> findAllRelatedToUserQuery(Object dbContext, User user) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(UserCustomFieldsEntity.class, dbContext);
        QueryBuilder qb = thisDao.queryBuilder();
        QueryBuilder qbSelect = qb.selectColumns(new String[]{"uuid"});
        Where where = qbSelect.where();
        where.eq("user", (Object)user.getUsername());
        PreparedQuery pq = qbSelect.prepare();
        List ucfs = thisDao.query(qbSelect.prepare());
        return pq;
    }

    public void createUserCustom(Map<Integer, String> map, User user, Object dbContext) throws SQLException {
        Set<Map.Entry<Integer, String>> es = map.entrySet();
        for (Map.Entry<Integer, String> e : es) {
            int key = e.getKey();
            String value = e.getValue();
            UserCustomFields uce = (UserCustomFields)this.makeNew();
            uce.setUuid(UUID.randomUUID().toString());
            if (user != null) {
                uce.setUser(user);
            }
            uce.setFieldName(key);
            uce.setFieldValue(value);
            this.persist(dbContext, (NanoLrsModel)uce);
        }
    }

    public List<UserCustomFields> findByUser(User user, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(UserCustomFieldsEntity.class, dbContext);
        QueryBuilder qb = thisDao.queryBuilder();
        Where where = qb.where();
        where.eq("user", (Object)user.getUsername());
        List ucfs = thisDao.query(qb.prepare());
        return ucfs;
    }

    public String getUserField(User user, int field, Object dbContext) throws SQLException {
        Object thisDao = this.persistenceManager.getDao(UserCustomFieldsEntity.class, dbContext);
        QueryBuilder qb = thisDao.queryBuilder();
        Where where = qb.where();
        where.eq("user", (Object)user.getUsername()).and().eq("field_name", (Object)field);
        List ucfs = thisDao.query(qb.prepare());
        if (ucfs != null && !ucfs.isEmpty()) {
            UserCustomFields ucf = (UserCustomFields)ucfs.get(0);
            return ucf.getFieldValue();
        }
        return "";
    }

    public void updateUserCustom(Map<Integer, String> map, User user, Object dbContext) throws SQLException {
        Set<Map.Entry<Integer, String>> es = map.entrySet();
        Iterator<Map.Entry<Integer, String>> it = es.iterator();
        List<UserCustomFields> userFields = this.findByUser(user, dbContext);
        while (it.hasNext()) {
            Map.Entry<Integer, String> e = it.next();
            int key = e.getKey();
            String value = e.getValue();
            boolean fieldExists = false;
            UserCustomFields uce = null;
            for (UserCustomFields customField : userFields) {
                if (customField.getFieldName() != key) continue;
                uce = customField;
                fieldExists = true;
                uce.setFieldValue(value);
                break;
            }
            if (!fieldExists) {
                uce = (UserCustomFields)this.makeNew();
                uce.setUuid(UUID.randomUUID().toString());
                if (user != null) {
                    uce.setUser(user);
                }
                uce.setFieldName(key);
                uce.setFieldValue(value);
            }
            this.persist(dbContext, (NanoLrsModel)uce);
        }
    }
}

