/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.manager.XapiActivityManager;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.NanoLrsModelSyncable;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiActivity;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiActivityEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiStatementEntity;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLiteSyncable;
import com.ustadmobile.nanolrs.ormlite.manager.XapiStatementManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.persistence.PersistenceManagerORMLite;
import java.sql.SQLException;
import java.util.List;

public class XapiActivityManagerOrmLite
extends BaseManagerOrmLiteSyncable
implements XapiActivityManager {
    @Override
    public Class getEntityImplementationClasss() {
        return XapiActivityEntity.class;
    }

    public XapiActivity findByActivityId(Object dbContext, String activityId) {
        XapiActivity result = null;
        try {
            Object dao = this.persistenceManager.getDao(XapiActivityEntity.class, dbContext);
            result = (XapiActivity)dao.queryForId((Object)activityId);
        }
        catch (SQLException e) {
            System.err.println("Exception findorcreatebyid");
            e.printStackTrace();
        }
        return result;
    }

    public XapiActivity makeNew(Object dbContext) {
        XapiActivityEntity entity = new XapiActivityEntity();
        return entity;
    }

    public List<NanoLrsModelSyncable> findAllRelatedToUser(Object dbContext, User user) throws SQLException {
        Object xapiActivityDao = this.persistenceManager.getDao(XapiActivityEntity.class, dbContext);
        QueryBuilder xapiActivityQB = xapiActivityDao.queryBuilder();
        Where xapiActivityWhere = xapiActivityQB.where();
        Object xapistatementDao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
        QueryBuilder xapiStatementQB = xapistatementDao.queryBuilder();
        QueryBuilder xapiStatementSelect = xapiStatementQB.selectColumns(new String[]{"activity"});
        Where xapiStatementWhere = xapiStatementSelect.where();
        xapiStatementWhere.eq("agent", (Object)user).or().eq("actor", (Object)user);
        XapiStatementManagerOrmLite xapiStatementManager = (XapiStatementManagerOrmLite)PersistenceManagerORMLite.getInstance().getManager(XapiStatementManagerOrmLite.class);
        PreparedQuery xapiStatementPQ = xapiStatementManager.findAllRelatedToUserQuery(dbContext, user);
        return null;
    }

    public PreparedQuery findAllRelatedToUserQuery(Object dbContext, User user) throws SQLException {
        XapiAgentManager agentManager = (XapiAgentManager)PersistenceManager.getInstance().getManager(XapiAgentManager.class);
        Object xapiActivityDao = this.persistenceManager.getDao(XapiActivityEntity.class, dbContext);
        QueryBuilder xapiActivityQB = xapiActivityDao.queryBuilder();
        Where xapiActivityWhere = xapiActivityQB.where();
        List usersCorrespondingAgents = agentManager.findByUser(dbContext, user);
        if (usersCorrespondingAgents == null || usersCorrespondingAgents.isEmpty() || usersCorrespondingAgents.size() != 1) {
            return null;
        }
        XapiAgent userCorrespondingAgent = (XapiAgent)usersCorrespondingAgents.get(0);
        Object xapiStatementDao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
        QueryBuilder xapiStatementQB = xapiStatementDao.queryBuilder();
        QueryBuilder xapiStatementSelect = xapiStatementQB.selectColumns(new String[]{"activity"});
        Where xapiStatementWhere = xapiStatementSelect.where();
        xapiStatementWhere.eq("agent", (Object)userCorrespondingAgent.getUuid()).or().eq("actor", (Object)userCorrespondingAgent.getUuid());
        PreparedQuery xapiStatementPQ = xapiStatementSelect.prepare();
        List res = xapiStatementDao.query(xapiStatementPQ);
        return xapiStatementPQ;
    }

    public void createOrUpdate(Object dbContext, XapiActivity data) {
        try {
            super.persist(dbContext, (NanoLrsModel)data);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteByActivityId(Object dbContext, String activityId) {
        try {
            Object dao = this.persistenceManager.getDao(XapiActivityEntity.class, dbContext);
            dao.deleteById((Object)activityId);
        }
        catch (SQLException e) {
            System.err.println("Exception deleteById");
            e.printStackTrace();
        }
    }

    public List<XapiActivity> findByAuthority(Object dbContext, XapiAgent agent) throws SQLException {
        Object dao = this.persistenceManager.getDao(XapiActivity.class, dbContext);
        QueryBuilder qb = dao.queryBuilder();
        Where where = qb.where();
        where.eq("authority", (Object)agent.getUuid());
        List activities = dao.query(qb.prepare());
        if (activities != null && !activities.isEmpty()) {
            return activities;
        }
        return null;
    }

    @Override
    public void persist(Object dbContext, NanoLrsModel data) throws SQLException {
        super.persist(dbContext, data);
    }
}

