/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.manager;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.manager.XapiStateManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModelSyncable;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.model.XapiState;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiActivityEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiAgentEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiStateEntity;
import com.ustadmobile.nanolrs.ormlite.generated.model.XapiStatementEntity;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLiteSyncable;
import com.ustadmobile.nanolrs.ormlite.manager.XapiAgentManagerOrmLite;
import java.sql.SQLException;
import java.util.List;

public class XapiStateManagerOrmLite
extends BaseManagerOrmLiteSyncable
implements XapiStateManager {
    @Override
    public Class getEntityImplementationClasss() {
        return XapiStateEntity.class;
    }

    public List<NanoLrsModelSyncable> findAllRelatedToUser(Object dbContext, User user) throws SQLException {
        return null;
    }

    public PreparedQuery findAllRelatedToUserQuery(Object dbContext, User user) throws SQLException {
        XapiAgentManager agentManager = (XapiAgentManager)PersistenceManager.getInstance().getManager(XapiAgentManager.class);
        List usersCorrespondingAgents = agentManager.findByUser(dbContext, user);
        if (usersCorrespondingAgents == null || usersCorrespondingAgents.isEmpty() || usersCorrespondingAgents.size() != 1) {
            return null;
        }
        XapiAgent userCorrespondingAgent = (XapiAgent)usersCorrespondingAgents.get(0);
        Object xapiStateDao = this.persistenceManager.getDao(XapiStateEntity.class, dbContext);
        QueryBuilder xapiStateQB = xapiStateDao.queryBuilder();
        QueryBuilder xapiStateSelectQB = xapiStateQB.selectColumns(new String[]{"uuid"});
        Where xapiStateWhere = xapiStateSelectQB.where();
        xapiStateWhere.eq("agent", (Object)userCorrespondingAgent.getUuid());
        PreparedQuery pq = xapiStateSelectQB.prepare();
        Object xapiStatementDao = this.persistenceManager.getDao(XapiStatementEntity.class, dbContext);
        QueryBuilder xapiStatementQB = xapiStatementDao.queryBuilder();
        QueryBuilder xapiStatementSelect = xapiStatementQB.selectColumns(new String[]{"activity"});
        Where xapiStatementWhere = xapiStatementSelect.where();
        xapiStatementWhere.eq("agent", (Object)userCorrespondingAgent.getUuid()).or().eq("actor", (Object)userCorrespondingAgent.getUuid());
        PreparedQuery xapiStatementPQ = xapiStatementSelect.prepare();
        List res = xapiStatementDao.query(xapiStatementPQ);
        return pq;
    }

    public XapiState makeNew(Object dbContext) {
        return new XapiStateEntity();
    }

    public void persist(Object dbContext, XapiState data) {
        try {
            this.persistenceManager.getDao(XapiStateEntity.class, dbContext).createOrUpdate((Object)((XapiStateEntity)data));
        }
        catch (SQLException e) {
            System.err.println("state manager persist exception");
            e.printStackTrace();
        }
    }

    public XapiState findByActivityAndAgent(Object dbContext, String activityId, String agentMbox, String agentAccountName, String agentAccountHomepage, String registrationUuid, String stateId) {
        try {
            Object dao = this.persistenceManager.getDao(XapiStateEntity.class, dbContext);
            QueryBuilder query = dao.queryBuilder();
            Object agentDao = this.persistenceManager.getDao(XapiAgentEntity.class, dbContext);
            QueryBuilder<XapiAgentEntity, String> agentQuery = XapiAgentManagerOrmLite.makeAgentQuery(agentDao, agentMbox, agentAccountName, agentAccountHomepage);
            query.leftJoin(agentQuery);
            Where where = query.where();
            XapiActivityEntity activity = new XapiActivityEntity();
            activity.setActivityId(activityId);
            where.eq("activity", (Object)activity);
            where.eq("state_id", (Object)stateId);
            if (registrationUuid != null) {
                where.eq("registration", (Object)registrationUuid);
            } else {
                where.isNull("registration");
            }
            where.and(3);
            return (XapiState)dao.queryForFirst(query.prepare());
        }
        catch (SQLException e) {
            System.err.println("Exception in findByActivityAndAgent");
            e.printStackTrace();
            return null;
        }
    }

    public boolean delete(Object dbContext, XapiState data) {
        try {
            Object dao = this.persistenceManager.getDao(XapiStateEntity.class, dbContext);
            dao.delete((Object)((XapiStateEntity)data));
            return true;
        }
        catch (SQLException e) {
            System.err.println("Exception in XapiStateManagerOrmLite delete");
            e.printStackTrace();
            return false;
        }
    }
}

