/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.ormlite.persistence;

import com.j256.ormlite.dao.Dao;
import com.ustadmobile.nanolrs.core.manager.ChangeSeqManager;
import com.ustadmobile.nanolrs.core.manager.NanoLrsManager;
import com.ustadmobile.nanolrs.core.manager.NodeManager;
import com.ustadmobile.nanolrs.core.manager.SyncStatusManager;
import com.ustadmobile.nanolrs.core.manager.UserCustomFieldsManager;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.manager.XapiActivityManager;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.manager.XapiForwardingStatementManager;
import com.ustadmobile.nanolrs.core.manager.XapiStateManager;
import com.ustadmobile.nanolrs.core.manager.XapiStatementManager;
import com.ustadmobile.nanolrs.core.manager.XapiVerbManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.ormlite.manager.BaseManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.ChangeSeqManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.NodeManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.SyncStatusManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.UserCustomFieldsManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.UserManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.XapiActivityManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.XapiAgentManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.XapiForwardingStatementManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.XapiStateManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.XapiStatementManagerOrmLite;
import com.ustadmobile.nanolrs.ormlite.manager.XapiVerbManagerOrmLite;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.WeakHashMap;

public abstract class PersistenceManagerORMLite
extends PersistenceManager {
    protected WeakHashMap<Class, BaseManagerOrmLite> managersCache = new WeakHashMap();
    public static HashMap<Class, Class<? extends BaseManagerOrmLite>> MANAGER_IMPL_MAP = new HashMap();

    public abstract <D extends Dao<T, ?>, T> D getDao(Class<T> var1, Object var2) throws SQLException;

    public static void registerManagerImplementation(Class coreManager, Class implementation) {
        MANAGER_IMPL_MAP.put(coreManager, implementation);
    }

    public <M extends NanoLrsManager<? extends NanoLrsModel, ?>> M getManager(Class<M> managerType) {
        BaseManagerOrmLite manager = this.managersCache.get(managerType);
        if (manager == null) {
            try {
                manager = MANAGER_IMPL_MAP.get(managerType).newInstance();
                manager.setPersistenceManager(this);
                this.managersCache.put(managerType, manager);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return (M)manager;
    }

    static {
        PersistenceManagerORMLite.registerManagerImplementation(XapiActivityManager.class, XapiActivityManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(XapiAgentManager.class, XapiAgentManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(XapiForwardingStatementManager.class, XapiForwardingStatementManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(XapiStateManager.class, XapiStateManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(XapiStatementManager.class, XapiStatementManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(UserManager.class, UserManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(XapiVerbManager.class, XapiVerbManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(ChangeSeqManager.class, ChangeSeqManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(SyncStatusManager.class, SyncStatusManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(NodeManager.class, NodeManagerOrmLite.class);
        PersistenceManagerORMLite.registerManagerImplementation(UserCustomFieldsManager.class, UserCustomFieldsManagerOrmLite.class);
    }
}

