/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class NanoLrsContextListener
implements ServletContextListener {
    public static final String ATTR_CONNECTION_SOURCE = "connectionSource";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        File webInfDir = new File(context.getRealPath("/WEB-INF"));
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(new File(webInfDir, "buildconfig.default.properties")));
            File localProperties = new File(webInfDir, "buildconfig.local.properties");
            if (localProperties.exists()) {
                props.load(new FileInputStream(localProperties));
            }
            String jdbcUrl = props.getProperty("JDBCURL");
            JdbcPooledConnectionSource connectionSource = new JdbcPooledConnectionSource(jdbcUrl);
            context.setAttribute(ATTR_CONNECTION_SOURCE, (Object)connectionSource);
        }
        catch (Exception e) {
            System.err.println("Exception!");
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

