/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.j256.ormlite.support.ConnectionSource;
import com.ustadmobile.nanolrs.core.endpoints.XapiStateEndpoint;
import com.ustadmobile.nanolrs.core.model.XapiState;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Scanner;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StateServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.getServletContext().log("init() called");
    }

    private String getFirstParamVal(HttpServletRequest request, String paramName) {
        return request.getParameter(paramName);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getServletContext().log("service() called");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String activityId = this.getFirstParamVal(request, "activityId");
        String agentJson = this.getFirstParamVal(request, "agent");
        String registration = this.getFirstParamVal(request, "registration");
        String stateId = this.getFirstParamVal(request, "stateId");
        ConnectionSource dbContext = (ConnectionSource)request.getServletContext().getAttribute("connectionSource");
        XapiState stateProxy = XapiStateEndpoint.getState((Object)dbContext, (String)activityId, (String)agentJson, (String)registration, (String)stateId);
        if (stateProxy == null) {
            response.sendError(404);
            response.setStatus(404);
        } else {
            byte[] stateData = stateProxy.getContent();
            int length = stateData.length;
            response.setContentType(stateProxy.getContentType());
            response.setContentLength(stateData.length);
            ServletOutputStream sos = response.getOutputStream();
            sos.write(stateData);
            sos.close();
            response.setStatus(200);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.putPost(request, response);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String activityId = this.getFirstParamVal(request, "activityId");
        String agentJson = this.getFirstParamVal(request, "agent");
        String registration = this.getFirstParamVal(request, "registration");
        String stateId = this.getFirstParamVal(request, "stateId");
        ConnectionSource dbContext = (ConnectionSource)request.getServletContext().getAttribute("connectionSource");
        XapiStateEndpoint.delete((Object)dbContext, (String)activityId, (String)agentJson, (String)registration, (String)stateId);
        response.setStatus(200);
        response.setContentType("application/json");
    }

    protected void putPost(HttpServletRequest request, HttpServletResponse response) throws SQLException, IOException {
        String activityId = this.getFirstParamVal(request, "activityId");
        String agentJson = this.getFirstParamVal(request, "agent");
        String registration = this.getFirstParamVal(request, "registration");
        String stateId = this.getFirstParamVal(request, "stateId");
        if (activityId == null || agentJson == null || stateId == null) {
            response.sendError(404);
        }
        byte[] stateData = StateServlet.extractPostRequestBody(request).getBytes();
        ConnectionSource dbContext = (ConnectionSource)request.getServletContext().getAttribute("connectionSource");
        XapiStateEndpoint.createOrUpdateState((Object)dbContext, (String)request.getMethod().toString(), (String)request.getHeader("content-type"), (String)activityId, (String)agentJson, (String)registration, (String)stateId, (byte[])stateData);
        response.setContentType("application/json");
        response.setStatus(200);
    }

    public void destroy() {
        this.getServletContext().log("destroy() called");
    }

    static String extractPostRequestBody(HttpServletRequest request) throws IOException {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            Scanner s = new Scanner((InputStream)request.getInputStream(), "UTF-8").useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        return "";
    }
}

