/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.j256.ormlite.support.ConnectionSource;
import com.ustadmobile.nanolrs.core.endpoints.XapiStatementsEndpoint;
import com.ustadmobile.nanolrs.core.util.LrsIoUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class StatementsServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String stmtId = request.getParameter("id");
        Closeable fin = null;
        try {
            byte[] requestContent = StatementsServlet.extractPostRequestBody(request).getBytes();
            JSONObject stmtObj = new JSONObject(new String(requestContent, "UTF-8"));
            ConnectionSource dbContext2 = (ConnectionSource)request.getServletContext().getAttribute("connectionSource");
            String storeId = XapiStatementsEndpoint.putStatement((JSONObject)stmtObj, (Object)dbContext2);
            response.setContentType("application/json");
            response.setStatus(200);
        }
        catch (IOException e) {
            response.setContentType("text/plain");
            response.sendError(500, e.getMessage());
        }
        catch (JSONException j) {
            response.setContentType("text/plain");
            response.sendError(500, "JSON Parse exception: " + j.getMessage());
        }
        finally {
            LrsIoUtils.closeQuietly(fin);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getServletContext().log("service() called");
        if (request.getMethod() == "GET" || request.getMethod() == "PUT" || request.getMethod() == "POST") {
            // empty if block
        }
    }

    public void destroy() {
        this.getServletContext().log("destroy() called");
    }

    static String extractPostRequestBody(HttpServletRequest request) throws IOException {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            Scanner s = new Scanner((InputStream)request.getInputStream(), "UTF-8").useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        if ("PUT".equalsIgnoreCase(request.getMethod())) {
            Scanner s = new Scanner((InputStream)request.getInputStream(), "UTF-8").useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            // empty if block
        }
        return "";
    }
}

