/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.ustadmobile.nanolrs.core.manager.UserCustomFieldsManager;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.manager.XapiStatementManager;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.util.MappingValues;
import com.ustadmobile.nanolrs.util.Module;
import com.ustadmobile.nanolrs.util.ServletUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CompletionReportServlet
extends HttpServlet {
    public static final String UNIVERSITY_FILTER_NAME = "universities_filter_names[]";

    public CompletionReportServlet() {
        System.out.println("In CompletionReportServlet()..");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("In CompletionReportServlet.doGet()..");
        LinkedHashMap<String, String> table_headers_html = new LinkedHashMap<String, String>();
        table_headers_html.put("fullname", "Name");
        table_headers_html.put("username", "Username");
        table_headers_html.put("university", "University");
        table_headers_html.put("tazkira_id", "Tazkira ID");
        table_headers_html.put("gender", "Gender");
        for (Module everyModule : MappingValues.ALL_MODULES) {
            table_headers_html.put(everyModule.getShortID(), everyModule.getName());
        }
        table_headers_html.put("all_completed", "All Completed");
        HttpSession session = request.getSession();
        String sessionAdmin = (String)session.getAttribute("admin");
        if (sessionAdmin != null) {
            if (sessionAdmin.equals("admin")) {
                request.setAttribute("table_headers_html", table_headers_html);
                request.setAttribute("static", (Object)"/syncendpoint/");
                request.setAttribute("universities", (Object)MappingValues.universities);
                request.getSession().setAttribute("table_headers_html", table_headers_html);
                request.getSession().setAttribute("static", (Object)"/syncendpoint/");
                request.getSession().setAttribute("universities", (Object)MappingValues.universities);
                System.out.println("Forwarding..");
                request.getRequestDispatcher("../CompletionReport.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect("../../Login.jsp");
            }
        } else {
            response.sendRedirect("../../Login.jsp");
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    public boolean agentModulePresentInStatement(XapiAgent agent, String verb, List<String> activities, Object dbContext) {
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        XapiStatementManager statementManager = (XapiStatementManager)pm.getManager(XapiStatementManager.class);
        XapiAgentManager agentManager = (XapiAgentManager)pm.getManager(XapiAgentManager.class);
        UserCustomFieldsManager ucfManager = (UserCustomFieldsManager)pm.getManager(UserCustomFieldsManager.class);
        if (agent == null) {
            return false;
        }
        Iterator<String> activitiesIterator = activities.iterator();
        boolean result = false;
        while (activitiesIterator.hasNext()) {
            String activity = activitiesIterator.next();
            List statements = statementManager.findByParams(dbContext, null, null, agent, verb, activity, null, false, false, -1L, -1L, -1);
            if (statements.isEmpty()) continue;
            result = true;
        }
        return result;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("In CompletionReportServlet.doPost()..");
        Object dbContext = this.getServletContext().getAttribute("connectionSource");
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        XapiAgentManager agentManager = (XapiAgentManager)pm.getManager(XapiAgentManager.class);
        UserCustomFieldsManager ucfManager = (UserCustomFieldsManager)pm.getManager(UserCustomFieldsManager.class);
        List allUsers = null;
        String jsonToReturn = "";
        XapiAgent agent = null;
        JSONArray userEnrollmentJSONArray = new JSONArray();
        String[] uni_names = req.getParameterValues(UNIVERSITY_FILTER_NAME);
        try {
            allUsers = userManager.getAllEntities(dbContext);
            ArrayList<String> allChoosenUniNames = new ArrayList<String>();
            if (uni_names != null && uni_names.length > 0) {
                for (int k = 0; k < uni_names.length; ++k) {
                    String choosenUniName = uni_names[k];
                    allChoosenUniNames.add(choosenUniName);
                }
            }
            for (User user : allUsers) {
                String username = user.getUsername();
                if (username.equals("admin") || user.getNotes() != null && user.getNotes().equals("testing")) continue;
                List agents = agentManager.findByUser(dbContext, user);
                agent = agents != null && !agents.isEmpty() ? (XapiAgent)agents.get(0) : null;
                JSONObject userInfoJSON = ServletUtil.getUserInfo(user, dbContext);
                boolean allCompleted = true;
                String user_university = ucfManager.getUserField(user, MappingValues.custom_fields_map.get("university").intValue(), dbContext);
                boolean iWantToBreakFree = ServletUtil.shouldIShowThisUserWithFilter(user_university, allChoosenUniNames);
                if (iWantToBreakFree) continue;
                for (Module everyModule : MappingValues.ALL_MODULES) {
                    boolean completed = this.agentModulePresentInStatement(agent, "http://adlnet.gov/expapi/verbs/passed", everyModule.getIds(), dbContext);
                    if (!completed) {
                        allCompleted = false;
                    }
                    userInfoJSON.put(everyModule.getShortID(), (Object)String.valueOf(completed));
                }
                if (allCompleted) {
                    userInfoJSON.put("all_completed", (Object)"true");
                } else {
                    userInfoJSON.put("all_completed", (Object)"false");
                }
                userEnrollmentJSONArray.put((Object)userInfoJSON);
            }
            jsonToReturn = userEnrollmentJSONArray.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println("EXCEPTION!");
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().write(jsonToReturn);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }
}

