/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.ustadmobile.nanolrs.core.manager.UserCustomFieldsManager;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.manager.XapiStatementManager;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.model.XapiStatement;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.util.MappingValues;
import com.ustadmobile.nanolrs.util.Module;
import com.ustadmobile.nanolrs.util.ServletUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CourseUsageReportServlet
extends HttpServlet {
    public static final String UNIVERSITY_FILTER_NAME = "universities_filter_names[]";
    public static final String MODULES_FILTER_NAME = "modules_filter_names[]";
    public static final String LEGACY_MODE_FILTER_NAME = "legacy_mode";
    public static final String MODULES_ONLY_NAME = "modules_only_mode";
    public static final String PASSED_STRING = "PASSED";
    public static final String FAILED_STRING = "FAILED";
    public static final String NA_STRING = "N/A";

    public CourseUsageReportServlet() {
        System.out.println("In CourseUsageReportServlet()..");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public static Map.Entry<Map, Map> appendModuleIdtoQuestionMap(String moduleID, Map<String, String> questionMap) {
        Map.Entry<String, String> entry2;
        LinkedHashMap<String, String> questionWithModuleIDMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> questionWithModuleIDMapClass = new LinkedHashMap<String, String>();
        LinkedHashMap<LinkedHashMap<String, String>, LinkedHashMap<String, String>> returnThis = new LinkedHashMap<LinkedHashMap<String, String>, LinkedHashMap<String, String>>();
        for (Map.Entry<String, String> entry2 : questionMap.entrySet()) {
            questionWithModuleIDMap.put(moduleID.trim() + '/' + entry2.getKey(), ServletUtil.stringToHTMLString("Q: " + entry2.getValue()));
            questionWithModuleIDMapClass.put(moduleID.trim() + '/' + entry2.getKey(), "question");
            questionWithModuleIDMap.put(moduleID.trim() + '/' + entry2.getKey() + "_duration", "(Duration)");
            questionWithModuleIDMapClass.put(moduleID.trim() + '/' + entry2.getKey() + "_duration", "question_duration");
            questionWithModuleIDMap.put(moduleID.trim() + '/' + entry2.getKey() + "_noattempts", "(No. of Attempts)");
            questionWithModuleIDMapClass.put(moduleID.trim() + '/' + entry2.getKey() + "_noattempts", "question_attempts");
        }
        returnThis.put(questionWithModuleIDMap, questionWithModuleIDMapClass);
        entry2 = returnThis.entrySet().iterator().next();
        return entry2;
    }

    public Map<String, String> putThisInThis(Map<String, String> fillMe, Map<String, String> pourMe) {
        for (Map.Entry<String, String> pourThis : pourMe.entrySet()) {
            fillMe.put(pourThis.getKey(), pourThis.getValue());
        }
        return fillMe;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("In CourseUsageReportServlet.doGet()..");
        Map<String, String> table_headers_html = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> table_headers_class = new LinkedHashMap<String, String>();
        Map<String, String> table_headers_class2 = new LinkedHashMap<String, String>();
        Map<String, String> table_headers_html2 = new LinkedHashMap<String, String>();
        table_headers_html.put("fullname", "Name");
        table_headers_html2.put("fullname", "");
        table_headers_class.put("fullname", "sticky");
        table_headers_html.put("username", "Username");
        table_headers_html2.put("username", "");
        table_headers_class.put("username", "sticky");
        table_headers_html.put("tazkira_id", "Tazkira ID");
        table_headers_html2.put("tazkira_id", "");
        table_headers_html.put("gender", "Gender");
        table_headers_html2.put("gender", "");
        table_headers_html.put("blankspace", " ");
        table_headers_html2.put("blankspace", " ");
        int moduleIterator = 0;
        for (Module everyModule : MappingValues.ALL_MODULES) {
            if (everyModule.getIds().size() <= 0) continue;
            table_headers_html.put(everyModule.getShortID() + "_result", "Module " + ++moduleIterator + ": " + everyModule.getName() + " " + "Result");
            table_headers_html.put(everyModule.getShortID() + "_score", "Score");
            table_headers_html.put(everyModule.getShortID() + "_duration", "Duration");
            table_headers_html.put(everyModule.getShortID() + "_attempt", "Attempt");
            table_headers_html.put(everyModule.getShortID() + "_registration", "Registration");
            Map.Entry<Map, Map> questionMapWithClass = CourseUsageReportServlet.appendModuleIdtoQuestionMap(everyModule.getIds().get(0), everyModule.getQuestionMap());
            Map questionMap = questionMapWithClass.getKey();
            Map questionMapClass = questionMapWithClass.getValue();
            LinkedHashMap<String, String> questionMapJustQuestion = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> questionMapWithoutQuestionText = new LinkedHashMap<String, String>();
            for (Map.Entry entry : questionMap.entrySet()) {
                if (((String)entry.getValue()).startsWith("Q: ")) {
                    questionMapWithoutQuestionText.put((String)entry.getKey(), "Score");
                    questionMapJustQuestion.put((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                questionMapWithoutQuestionText.put((String)entry.getKey(), (String)entry.getValue());
            }
            table_headers_html = this.putThisInThis(table_headers_html, questionMapJustQuestion);
            table_headers_class2 = this.putThisInThis(table_headers_class2, questionMapClass);
            table_headers_html.put("blankspace", " ");
            table_headers_html2.put(everyModule.getShortID() + "_result", "");
            table_headers_html2.put(everyModule.getShortID() + "_score", "");
            table_headers_html2.put(everyModule.getShortID() + "_duration", "");
            table_headers_html2.put(everyModule.getShortID() + "_attempt", "");
            table_headers_html2.put(everyModule.getShortID() + "_registration", "");
            table_headers_html2 = this.putThisInThis(table_headers_html2, questionMapWithoutQuestionText);
            table_headers_html2.put("blankspace", " ");
        }
        HttpSession session = request.getSession();
        String sessionAdmin = (String)session.getAttribute("admin");
        if (sessionAdmin != null) {
            if (sessionAdmin.equals("admin")) {
                request.setAttribute("table_headers_html", table_headers_html);
                request.setAttribute("table_headers_html2", table_headers_html2);
                request.setAttribute("table_headers_class2", table_headers_class2);
                request.setAttribute("static", (Object)"/syncendpoint/");
                request.setAttribute("universities", (Object)MappingValues.universities);
                request.setAttribute("modules", MappingValues.ALL_MODULES);
                request.getSession().setAttribute("table_headers_html", table_headers_html);
                request.getSession().setAttribute("table_headers_html2", table_headers_html2);
                request.getSession().setAttribute("table_headers_class2", table_headers_class2);
                request.getSession().setAttribute("table_headers_class", table_headers_class);
                request.getSession().setAttribute("static", (Object)"/syncendpoint/");
                request.getSession().setAttribute("universities", (Object)MappingValues.universities);
                request.getSession().setAttribute("modules", MappingValues.ALL_MODULES);
                request.getRequestDispatcher("../CourseUsageReport.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect("../../Login.jsp");
            }
        } else {
            response.sendRedirect("../../Login.jsp");
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    public static List<XapiStatement> findStatements(XapiAgent agent, String verb, List<String> activities, String statementId, String registration, Object dbContext) {
        PersistenceManager pm = PersistenceManager.getInstance();
        XapiStatementManager statementManager = (XapiStatementManager)pm.getManager(XapiStatementManager.class);
        if (agent == null) {
            return null;
        }
        Iterator<String> activitiesIterator = activities.iterator();
        LinkedList<XapiStatement> relevantStatements = new LinkedList<XapiStatement>();
        while (activitiesIterator.hasNext()) {
            String activity = activitiesIterator.next();
            List stmts = statementManager.findByParams(dbContext, statementId, null, agent, verb, activity, registration, false, false, -1L, -1L, -1);
            for (XapiStatement st : stmts) {
                relevantStatements.add(st);
            }
        }
        Collections.sort(relevantStatements, new Comparator<XapiStatement>(){

            @Override
            public int compare(XapiStatement s1, XapiStatement s2) {
                return Long.compare(s1.getTimestamp(), s2.getTimestamp());
            }
        });
        return relevantStatements;
    }

    public boolean agentModulePresentInStatementAgents(List<XapiAgent> agents, String verb, List<String> activities, Object dbContext) {
        boolean result = false;
        for (XapiAgent agent : agents) {
            boolean thisAgentResult = this.agentModulePresentInStatement(agent, verb, activities, dbContext);
            if (!thisAgentResult) continue;
            return true;
        }
        return result;
    }

    public boolean agentModulePresentInStatement(XapiAgent agent, String verb, List<String> activities, Object dbContext) {
        PersistenceManager pm = PersistenceManager.getInstance();
        XapiStatementManager statementManager = (XapiStatementManager)pm.getManager(XapiStatementManager.class);
        if (agent == null) {
            return false;
        }
        Iterator<String> activitiesIterator = activities.iterator();
        boolean result = false;
        while (activitiesIterator.hasNext()) {
            String activity = activitiesIterator.next();
            List statements = statementManager.findByParams(dbContext, null, null, agent, verb, activity, null, false, false, -1L, -1L, -1);
            if (statements.isEmpty()) continue;
            result = true;
        }
        return result;
    }

    public static String getDurationBreakdown(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Duration must be greater than zero!");
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        sb.append(days);
        sb.append(" d ");
        sb.append(hours);
        sb.append(" h ");
        sb.append(minutes);
        sb.append(" m ");
        sb.append(seconds);
        sb.append(" s");
        return sb.toString();
    }

    public static Map<String, String> getQuestionResult(String questionId, XapiAgent agent, String registrationId, Object dbContext) {
        float score = 0.0f;
        Long duration = 0L;
        String agentUUID = "";
        if (agent != null) {
            agentUUID = agent.getUuid();
        }
        LinkedHashMap<String, String> questionResultMap = new LinkedHashMap<String, String>();
        LinkedList<String> questionList = new LinkedList<String>();
        questionList.add(questionId);
        List<XapiStatement> statements = CourseUsageReportServlet.findStatements(agent, "http://adlnet.gov/expapi/verbs/answered", questionList, null, registrationId, dbContext);
        for (XapiStatement statement : statements) {
            if (statement.getResultScoreScaled() != 0.0f) {
                score = statement.getResultScoreScaled();
            }
            duration = duration + statement.getResultDuration();
        }
        int noAttempts = statements.size();
        Long durationSeconds = duration / 1000L;
        questionResultMap.put(questionId, String.valueOf(score));
        questionResultMap.put(questionId + "_duration", String.valueOf(durationSeconds));
        questionResultMap.put(questionId + "_noattempts", String.valueOf(noAttempts));
        return questionResultMap;
    }

    public static Map<String, String> getScoresForAgents(List<XapiAgent> agents, Module module, String registrationId, Object dbContext) {
        LinkedHashMap<String, String> scoreMap = new LinkedHashMap<String, String>();
        for (XapiAgent agent : agents) {
            Map<Object, Object> thisAgentScoreMap = new LinkedHashMap();
            thisAgentScoreMap = CourseUsageReportServlet.getScores(agent, module, registrationId, dbContext);
            for (Map.Entry<Object, Object> agentResult : thisAgentScoreMap.entrySet()) {
                scoreMap.put((String)agentResult.getKey(), (String)agentResult.getValue());
            }
        }
        return scoreMap;
    }

    public static Map<String, String> getScores(XapiAgent agent, Module module, String registrationId, Object dbContext) {
        HashMap<String, String> scoreMap = new HashMap<String, String>();
        Map<String, String> questions = module.getQuestionMap();
        for (Map.Entry<String, String> entry : questions.entrySet()) {
            String questionID = module.getIds().get(0).trim() + '/' + entry.getKey();
            Map<String, String> questionResultMap = CourseUsageReportServlet.getQuestionResult(questionID, agent, registrationId, dbContext);
            for (Map.Entry<String, String> questionResult : questionResultMap.entrySet()) {
                scoreMap.put(questionResult.getKey(), questionResult.getValue());
            }
        }
        return scoreMap;
    }

    public static Map<String, Long> getAllRegistrations(XapiAgent agent, Module module, Object dbContext) {
        return CourseUsageReportServlet.getAllRegistrations(agent, module, false, dbContext);
    }

    public static Map<String, Long> getAllRegistrationsForAgents(List<XapiAgent> agents, Module module, Object dbContext) {
        return CourseUsageReportServlet.getAllRegistrationsForAgents(agents, module, false, dbContext);
    }

    public static Map<String, Long> getAllRegistrationsForAgents(List<XapiAgent> agents, Module module, boolean legacyMode, Object dbContext) {
        LinkedHashMap<String, Long> allRegistrations = new LinkedHashMap<String, Long>();
        for (XapiAgent agent : agents) {
            Map<String, Long> agentRegistrations = CourseUsageReportServlet.getAllRegistrations(agent, module, legacyMode, dbContext);
            for (Map.Entry<String, Long> entry : agentRegistrations.entrySet()) {
                allRegistrations.put(entry.getKey(), entry.getValue());
            }
        }
        return allRegistrations;
    }

    public static Map<String, Long> getAllRegistrations(XapiAgent agent, Module module, boolean legacyMode, Object dbContext) {
        LinkedList<String> allRegistrations = new LinkedList<String>();
        LinkedHashMap<String, Long> allRegistrationsMap = new LinkedHashMap<String, Long>();
        List<XapiStatement> userStatements = legacyMode ? CourseUsageReportServlet.findStatements(agent, "http://adlnet.gov/expapi/verbs/launched", module.getIds(), null, null, dbContext) : CourseUsageReportServlet.findStatements(agent, "http://adlnet.gov/expapi/verbs/initialized", module.getIds(), null, null, dbContext);
        if (userStatements == null) {
            return allRegistrationsMap;
        }
        for (XapiStatement statement : userStatements) {
            if (statement.getContextRegistration() == null || statement.getContextRegistration().trim().equals("")) continue;
            allRegistrations.add(statement.getContextRegistration());
            allRegistrationsMap.put(statement.getContextRegistration(), statement.getTimestamp());
        }
        return allRegistrationsMap;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("In CourseUsageReportServlet.doPost()..");
        Object dbContext = this.getServletContext().getAttribute("connectionSource");
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        XapiAgentManager agentManager = (XapiAgentManager)pm.getManager(XapiAgentManager.class);
        UserCustomFieldsManager ucfManager = (UserCustomFieldsManager)pm.getManager(UserCustomFieldsManager.class);
        List allUsers = null;
        String jsonToReturn = "";
        XapiAgent agent = null;
        JSONArray userEnrollmentJSONArray = new JSONArray();
        String[] uni_names = req.getParameterValues(UNIVERSITY_FILTER_NAME);
        String[] mod_names = req.getParameterValues(MODULES_FILTER_NAME);
        String legacyMode = req.getParameter(LEGACY_MODE_FILTER_NAME);
        String modulesOnly = req.getParameter(MODULES_ONLY_NAME);
        try {
            allUsers = userManager.getAllEntities(dbContext);
            ArrayList<String> allChoosenUniNames = new ArrayList<String>();
            if (uni_names != null && uni_names.length > 0) {
                for (int k = 0; k < uni_names.length; ++k) {
                    String choosenUniName = uni_names[k];
                    allChoosenUniNames.add(choosenUniName);
                }
            }
            ArrayList<String> allChoosenModuleNames = new ArrayList<String>();
            if (mod_names != null && mod_names.length > 0) {
                for (int m = 0; m < mod_names.length; ++m) {
                    String choosenModName = mod_names[m];
                    allChoosenModuleNames.add(choosenModName);
                }
            }
            for (User user : allUsers) {
                String username = user.getUsername();
                if (username.equals("admin") || user.getNotes() != null && user.getNotes().equals("testing")) continue;
                List agents = agentManager.findByUser(dbContext, user);
                agent = agents != null && !agents.isEmpty() ? (XapiAgent)agents.get(0) : null;
                JSONObject userInfoJSON = ServletUtil.getUserInfo(user, dbContext);
                userInfoJSON.put("blankspace", (Object)"");
                String user_university = ucfManager.getUserField(user, MappingValues.custom_fields_map.get("university").intValue(), dbContext);
                boolean iWantToBreakFree = ServletUtil.shouldIShowThisUserWithFilter(user_university, allChoosenUniNames);
                if (iWantToBreakFree) continue;
                LinkedHashMap<String, JSONObject> userAttempt = new LinkedHashMap<String, JSONObject>();
                for (Module everyModule : MappingValues.ALL_MODULES) {
                    if (allChoosenModuleNames.contains(everyModule.getShortID())) continue;
                    String moduleResult = NA_STRING;
                    String moduleScore = "";
                    Long moduleDuration = null;
                    boolean moduleStarted = this.agentModulePresentInStatement(agent, "http://adlnet.gov/expapi/verbs/launched", everyModule.getIds(), dbContext);
                    boolean modulePassed = false;
                    if (moduleStarted) {
                        modulePassed = this.agentModulePresentInStatement(agent, "http://adlnet.gov/expapi/verbs/passed", everyModule.getIds(), dbContext);
                        moduleResult = modulePassed ? PASSED_STRING : FAILED_STRING;
                    }
                    userInfoJSON.put(everyModule.getShortID() + "_result", (Object)moduleResult);
                    boolean legacyModeBoolean = false;
                    if (legacyMode != null && !legacyMode.isEmpty() && legacyMode.equals("true")) {
                        legacyMode = "true";
                        legacyModeBoolean = true;
                    }
                    boolean modulesOnlyBoolean = false;
                    if (modulesOnly != null && !modulesOnly.isEmpty() && modulesOnly.equals("true")) {
                        modulesOnly = "true";
                        modulesOnlyBoolean = true;
                    }
                    Map<String, Long> allRegistrationsMap = CourseUsageReportServlet.getAllRegistrations(agent, everyModule, legacyModeBoolean, dbContext);
                    int regIteration = 0;
                    boolean gotLatest = false;
                    for (Map.Entry<String, Long> regEntry : allRegistrationsMap.entrySet()) {
                        String registrationId = regEntry.getKey();
                        Long registrationTime = regEntry.getValue();
                        Date registrationDate = new Date(registrationTime);
                        SimpleDateFormat df = new SimpleDateFormat("dd MMMMM yyyy HH:mm:ss");
                        String registrationDateString = df.format(registrationDate);
                        Long regTotalDuration = 0L;
                        ++regIteration;
                        JSONObject userRegEntry = new JSONObject();
                        userRegEntry.put("blankspace", (Object)("blankspace-UM:" + user.getUsername()));
                        Map<String, String> scoreMap = CourseUsageReportServlet.getScores(agent, everyModule, registrationId, dbContext);
                        Iterator<Map.Entry<String, String>> scoreMapIterator = scoreMap.entrySet().iterator();
                        String appendThis = "";
                        while (scoreMapIterator.hasNext()) {
                            Map.Entry<String, String> entry = scoreMapIterator.next();
                            appendThis = "";
                            if (entry.getKey().endsWith("_duration")) {
                                appendThis = "s";
                            }
                            if (entry.getKey().endsWith("_score")) {
                                // empty if block
                            }
                            userRegEntry.put(entry.getKey(), (Object)(entry.getValue() + appendThis));
                            if (!entry.getKey().endsWith("_duration")) continue;
                            Long thisDuration = Long.parseLong(entry.getValue());
                            regTotalDuration = regTotalDuration + thisDuration;
                        }
                        List<XapiStatement> regPassed = CourseUsageReportServlet.findStatements(agent, "http://adlnet.gov/expapi/verbs/passed", everyModule.getIds(), null, registrationId, dbContext);
                        List<XapiStatement> regFailed = CourseUsageReportServlet.findStatements(agent, "http://adlnet.gov/expapi/verbs/failed", everyModule.getIds(), null, registrationId, dbContext);
                        String regTotalScore = !regPassed.isEmpty() ? String.valueOf(regPassed.get(0).getResultScoreScaled() * 100.0f) + "%" : (!regFailed.isEmpty() ? String.valueOf(regFailed.get(0).getResultScoreScaled() * 100.0f) + "%" : "-");
                        userRegEntry.put(everyModule.getShortID() + "_attempt", (Object)registrationDateString);
                        String regTotalDurationReadable = CourseUsageReportServlet.getDurationBreakdown(regTotalDuration * 1000L);
                        userRegEntry.put(everyModule.getShortID() + "_duration", (Object)String.valueOf(regTotalDurationReadable));
                        userRegEntry.put(everyModule.getShortID() + "_score", (Object)regTotalScore);
                        userRegEntry.put(everyModule.getShortID() + "_registration", (Object)registrationId);
                        if (userAttempt.get("r" + regIteration) != null) {
                            JSONObject existingEntry = (JSONObject)userAttempt.get("r" + regIteration);
                            for (String key : JSONObject.getNames((JSONObject)userRegEntry)) {
                                if (!existingEntry.isNull(key)) {
                                    System.out.println("WARNING > VALUE: " + key + " ALREADY EXIST!");
                                }
                                existingEntry.put(key, userRegEntry.get(key));
                            }
                            userAttempt.put("r" + regIteration, existingEntry);
                        } else {
                            userAttempt.put("r" + regIteration, userRegEntry);
                        }
                        if (gotLatest) continue;
                        gotLatest = true;
                        moduleDuration = regTotalDuration;
                        moduleScore = regTotalScore;
                    }
                    if (allRegistrationsMap.size() > 0) {
                        userInfoJSON.put(everyModule.getShortID() + "_result", (Object)moduleResult);
                    } else {
                        userInfoJSON.put(everyModule.getShortID() + "_result", (Object)NA_STRING);
                    }
                    if (moduleDuration == null) {
                        userInfoJSON.put(everyModule.getShortID() + "_duration", (Object)"");
                    } else {
                        String regTotalDurationReadable = CourseUsageReportServlet.getDurationBreakdown(moduleDuration * 1000L);
                        userInfoJSON.put(everyModule.getShortID() + "_duration", (Object)String.valueOf(regTotalDurationReadable));
                    }
                    if (moduleScore == null) {
                        moduleScore = "";
                    }
                    userInfoJSON.put(everyModule.getShortID() + "_score", (Object)moduleScore);
                }
                userEnrollmentJSONArray.put((Object)userInfoJSON);
                for (Map.Entry attemptEntry : userAttempt.entrySet()) {
                    userEnrollmentJSONArray.put(attemptEntry.getValue());
                }
            }
            jsonToReturn = userEnrollmentJSONArray.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println("EXCEPTION!");
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().write(jsonToReturn);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }
}

