/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.ustadmobile.nanolrs.core.manager.UserCustomFieldsManager;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.manager.XapiStatementManager;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.util.MappingValues;
import com.ustadmobile.nanolrs.util.ServletUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class EnrollmentReportServlet
extends HttpServlet {
    public EnrollmentReportServlet() {
        System.out.println("In EnrollmentReportView()..");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("In EnrollmentReportView.doGet()..");
        HashMap<String, String> table_headers_html = new HashMap<String, String>();
        table_headers_html.put("username", "Username");
        table_headers_html.put("name", "Name");
        table_headers_html.put("university", "uid");
        table_headers_html.put("university_name", "University");
        table_headers_html.put("enrolled", "Status");
        HttpSession session = request.getSession();
        String sessionAdmin = (String)session.getAttribute("admin");
        if (sessionAdmin != null) {
            if (sessionAdmin.equals("admin")) {
                request.setAttribute("table_headers_html", table_headers_html);
                request.setAttribute("static", (Object)"/syncendpoint/");
                request.setAttribute("universities", (Object)MappingValues.universities);
                request.getSession().setAttribute("universities", (Object)MappingValues.universities);
                request.getRequestDispatcher("../EnrollmentReport.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect("../../Login.jsp");
            }
        } else {
            response.sendRedirect("../../Login.jsp");
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("In ErollmentReportServlet.doPOST()..");
        Object dbContext = this.getServletContext().getAttribute("connectionSource");
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        XapiStatementManager statementManager = (XapiStatementManager)pm.getManager(XapiStatementManager.class);
        XapiAgentManager agentManager = (XapiAgentManager)pm.getManager(XapiAgentManager.class);
        UserCustomFieldsManager ucfManager = (UserCustomFieldsManager)pm.getManager(UserCustomFieldsManager.class);
        List allUsers = null;
        String jsonToReturn = "";
        XapiAgent agent = null;
        ArrayList<User> enrolledUsers = new ArrayList<User>();
        ArrayList enrolledUsersString = new ArrayList();
        JSONArray userEnrollmentJSONArray = new JSONArray();
        try {
            allUsers = userManager.getAllEntities(dbContext);
            if (allUsers != null && !allUsers.isEmpty()) {
                for (User user : allUsers) {
                    List allStatements;
                    List allAgents = agentManager.findByUser(dbContext, user);
                    if (allAgents == null || allAgents.isEmpty() || (allStatements = statementManager.findByParams(dbContext, null, null, agent = (XapiAgent)allAgents.get(0), null, null, null, false, false, -1L, -1L, 0)) == null || allStatements.isEmpty()) continue;
                    enrolledUsers.add(user);
                }
            }
            HashMap<String, Integer> uni_map = new HashMap<String, Integer>();
            uni_map.put("Kabul University", 23);
            uni_map.put("Kabul Polytechnic University", 24);
            uni_map.put("Kabul Education University", 25);
            HashMap<String, Integer> custom_fields_map = new HashMap<String, Integer>();
            custom_fields_map.put("university", 980);
            custom_fields_map.put("fullname", 981);
            custom_fields_map.put("gender", 983);
            custom_fields_map.put("email", 982);
            custom_fields_map.put("phonenumber", 984);
            custom_fields_map.put("faculty", 985);
            String[] uni_names = req.getParameterValues("university_names[]");
            ArrayList<String> allChoosenUniNames = new ArrayList<String>();
            if (uni_names != null && uni_names.length > 0) {
                for (int k = 0; k < uni_names.length; ++k) {
                    String choosenUniName = uni_names[k];
                    allChoosenUniNames.add(choosenUniName);
                }
            }
            for (User user : allUsers) {
                JSONObject userInfoJSON;
                block14: {
                    String username = user.getUsername();
                    if (username.equals("admin") || user.getNotes() != null && user.getNotes().equals("testing")) continue;
                    userInfoJSON = ServletUtil.getUserInfo(user, dbContext);
                    String user_university = ucfManager.getUserField(user, ((Integer)custom_fields_map.get("university")).intValue(), dbContext);
                    boolean iWantToBreakFree = false;
                    System.out.println("Checking if: " + user_university + " is in: " + uni_names);
                    if (!allChoosenUniNames.isEmpty() && !allChoosenUniNames.contains("ALL")) {
                        if (allChoosenUniNames.contains("Other") || allChoosenUniNames.contains("I don't know")) {
                            if (user_university.contains("Other") || user_university.contains("I don't know")) {
                                System.out.println("Selected Other/I don't know. User's uni is also that. Allowing..");
                                break block14;
                            } else {
                                iWantToBreakFree = true;
                                continue;
                            }
                        }
                        if (!allChoosenUniNames.contains(user_university)) {
                            iWantToBreakFree = true;
                            System.out.println("YES");
                            continue;
                        }
                    }
                }
                System.out.println("NO");
                if (enrolledUsers.contains(user)) {
                    userInfoJSON.put("enrolled", (Object)"true");
                } else {
                    userInfoJSON.put("enrolled", (Object)"false");
                }
                userEnrollmentJSONArray.put((Object)userInfoJSON);
            }
            jsonToReturn = userEnrollmentJSONArray.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println("EXCEPTION!");
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().write(jsonToReturn);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }
}

