/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class NanoLrsContextListener
implements ServletContextListener {
    public static final String ATTR_CONNECTION_SOURCE = "connectionSource";

    public void contextInitialized(ServletContextEvent sce) {
        System.out.println("In Context Listener : contextInitialized..");
        ServletContext context = sce.getServletContext();
        File webInfDir = new File(context.getRealPath("/WEB-INF"));
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(new File(webInfDir, "buildconfig.default.properties")));
            File localProperties = new File(webInfDir, "buildconfig.local.properties");
            if (localProperties.exists()) {
                props.load(new FileInputStream(localProperties));
            }
            String jdbcUrlHost = props.getProperty("JDBCURL");
            String jdbcUsername = props.getProperty("DATABASE_USER");
            String jdbcPassword = props.getProperty("DATABASE_PASS");
            String jdbcUrl = "";
            jdbcUrl = !jdbcUsername.isEmpty() && !jdbcPassword.isEmpty() ? jdbcUrlHost + "?user=" + jdbcUsername + "&password=" + jdbcPassword : jdbcUrlHost;
            System.out.println("Got JDBC URL : " + jdbcUrl);
            JdbcPooledConnectionSource connectionSource = new JdbcPooledConnectionSource(jdbcUrl);
            context.setAttribute(ATTR_CONNECTION_SOURCE, (Object)connectionSource);
        }
        catch (Exception e) {
            System.err.println("Exception!");
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

