/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.util.ServletUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StatementsServlet
extends HttpServlet {
    public static final String XAPI_HEADER_AUTH = "Authorization";
    public static final String XAPI_HEADER_VER = "X-Experience-API-Version";

    public StatementsServlet() {
        System.out.println("In StatementsServlet()..");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Statements doGet()..");
        Object dbContext = this.getServletContext().getAttribute("connectionSource");
        UserManager userManager = (UserManager)PersistenceManager.getInstance().getManager(UserManager.class);
        System.out.println("StatementsServlet: Authentication started..");
        String authString = ServletUtil.getHeaderVal(request, XAPI_HEADER_AUTH);
        String xapiVersionString = ServletUtil.getHeaderVal(request, XAPI_HEADER_VER);
        boolean badRequest = false;
        boolean forbiddenRequest = false;
        if (authString == null || authString.isEmpty()) {
            System.out.println("StatementsServlet: Null Auth String..");
            badRequest = true;
        }
        if (xapiVersionString == null || xapiVersionString.isEmpty()) {
            System.out.println("StatementsServlet: Null Headers..");
            badRequest = true;
        }
        if (ServletUtil.getCredentialStringFromBasicAuth(request) == null) {
            System.out.println("StatementsServlet: Null Credential String..");
            badRequest = true;
        }
        if (badRequest) {
            System.out.println("StatementServlet: BAD request");
            response.setContentType("text/plain");
            response.setStatus(403);
        } else {
            String password;
            String username = ServletUtil.getUsernameFromBasicAuth(request);
            boolean correctLogin = userManager.authenticate(dbContext, username, password = ServletUtil.getPasswordFromBasicAuth(request), true);
            if (correctLogin) {
                System.out.println("StatementsServlet: Login OK");
                response.setContentType("text/plain");
                response.setStatus(200);
            } else {
                System.out.println("StatementsServlet: Login FAIL");
                response.setContentType("text/plain");
                response.setStatus(403);
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    static String extractPostRequestBody(HttpServletRequest request) throws IOException {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            Scanner s = new Scanner((InputStream)request.getInputStream(), "UTF-8").useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        if ("PUT".equalsIgnoreCase(request.getMethod())) {
            Scanner s = new Scanner((InputStream)request.getInputStream(), "UTF-8").useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            // empty if block
        }
        return "";
    }
}

