/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.ustadmobile.nanolrs.core.manager.UserCustomFieldsManager;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.manager.XapiAgentManager;
import com.ustadmobile.nanolrs.core.manager.XapiStatementManager;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.model.XapiAgent;
import com.ustadmobile.nanolrs.core.model.XapiStatement;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.servlet.CourseUsageReportServlet;
import com.ustadmobile.nanolrs.util.MappingValues;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class SummaryReportServlet
extends HttpServlet {
    public static final String UNIVERSITY_FILTER_NAME = "universities_filter_names[]";
    public static final String LEGACY_MODE_FILTER_NAME = "legacy_mode";
    public static final String PASSED_STRING = "PASSED";
    public static final String FAILED_STRING = "FAILED";
    public static final String NA_STRING = "N/A";
    public static final int DEFAULT_DAYS_TO_LOOK_BACK = 7;

    public SummaryReportServlet() {
        System.out.println("In SummaryReportServlet()..");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("In SummaryReportServlet.doGet()..");
        LinkedHashMap<String, String> table_headers_html = new LinkedHashMap<String, String>();
        LinkedHashMap table_headers_class = new LinkedHashMap();
        table_headers_html.put("title", "");
        table_headers_html.put("no_females", MappingValues.custom_fields_label.get("no_females"));
        table_headers_html.put("no_males", MappingValues.custom_fields_label.get("no_males"));
        table_headers_html.put("total", MappingValues.custom_fields_label.get("total"));
        HttpSession session = request.getSession();
        String sessionAdmin = (String)session.getAttribute("admin");
        if (sessionAdmin != null) {
            if (sessionAdmin.equals("admin")) {
                request.setAttribute("table_headers_html", table_headers_html);
                request.setAttribute("static", (Object)"/syncendpoint/");
                request.setAttribute("days", (Object)7);
                request.setAttribute("universities", (Object)MappingValues.universities);
                request.getSession().setAttribute("table_headers_html", table_headers_html);
                request.getSession().setAttribute("table_headers_class", table_headers_class);
                request.getSession().setAttribute("static", (Object)"/syncendpoint/");
                request.getSession().setAttribute("days", (Object)7);
                request.getSession().setAttribute("universities", (Object)MappingValues.universities);
                request.getRequestDispatcher("../SummaryReport.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect("../../Login.jsp");
            }
        } else {
            response.sendRedirect("../../Login.jsp");
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    public long getDateBeforeDays(int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -days);
        Date fromDateDate = cal.getTime();
        long pastDate = fromDateDate.getTime();
        return pastDate;
    }

    public SummaryResult getSummaryResult(long fromDate, long toDate, Object dbContext) throws SQLException {
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        XapiAgentManager agentManager = (XapiAgentManager)pm.getManager(XapiAgentManager.class);
        List allUsers = userManager.getAllEntities(dbContext);
        List enrolledUsers = userManager.getAllSinceTwoDates(fromDate, toDate, dbContext);
        LinkedList<User> activeUsers = new LinkedList<User>();
        LinkedList<User> completedUsers = new LinkedList<User>();
        LinkedHashMap<String, Long> durationMap = new LinkedHashMap<String, Long>();
        Iterator iterator = allUsers.iterator();
        while (iterator.hasNext()) {
            List<XapiStatement> statementsCompleted;
            User user;
            List agents = agentManager.findByUser(dbContext, user = (User)iterator.next());
            XapiAgent agent = agents != null && !agents.isEmpty() ? (XapiAgent)agents.get(0) : null;
            List<XapiStatement> statements = this.getStatementsInTimeRange(user, agent, fromDate, toDate, null, dbContext);
            if (statements.size() > 0) {
                activeUsers.add(user);
            }
            if ((statementsCompleted = this.getStatementsInTimeRange(user, agent, fromDate, toDate, "http://adlnet.gov/expapi/verbs/completed", dbContext)).size() > 0) {
                completedUsers.add(user);
            }
            long duration = 0L;
            List<XapiStatement> statementsDuration = this.getStatementsInTimeRange(user, agent, fromDate, toDate, "http://adlnet.gov/expapi/verbs/answered", dbContext);
            for (XapiStatement statement : statementsDuration) {
                long thisDuration = statement.getResultDuration();
                duration += thisDuration;
            }
            durationMap.put(user.getUsername(), duration);
        }
        SummaryResult result = new SummaryResult(enrolledUsers, activeUsers, completedUsers, durationMap);
        return result;
    }

    public List<XapiStatement> getStatementsInTimeRange(User user, XapiAgent agent, long fromDate, long toDate, String verb, Object dbContext) throws SQLException {
        PersistenceManager pm = PersistenceManager.getInstance();
        XapiStatementManager statementManager = (XapiStatementManager)pm.getManager(XapiStatementManager.class);
        List statements = statementManager.findByParams(dbContext, null, null, agent, verb, null, null, false, false, fromDate, toDate, 0);
        return statements;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("In SummaryReportServlet.doPost()..");
        Object dbContext = this.getServletContext().getAttribute("connectionSource");
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        UserCustomFieldsManager ucfManager = (UserCustomFieldsManager)pm.getManager(UserCustomFieldsManager.class);
        List allUsers = null;
        JSONArray reportJSONArray = new JSONArray();
        String jsonToReturn = "";
        String[] uni_names = req.getParameterValues(UNIVERSITY_FILTER_NAME);
        try {
            int i;
            allUsers = userManager.getAllEntities(dbContext);
            ArrayList<Object> allChoosenUniNames = new ArrayList<Object>();
            if (uni_names != null && uni_names.length > 0) {
                for (int k = 0; k < uni_names.length; ++k) {
                    String choosenUniName = uni_names[k];
                    allChoosenUniNames.add(choosenUniName);
                }
            }
            LinkedHashMap<String, List> userToUniMap = new LinkedHashMap<String, List>();
            for (User user : allUsers) {
                if (user.getNotes() != null && user.getNotes().equals("testing")) continue;
                String userUniversity = ucfManager.getUserField(user, MappingValues.custom_fields_map.get("university").intValue(), dbContext);
                if (userUniversity == null || userUniversity.isEmpty()) {
                    userUniversity = "Other";
                }
                if (userToUniMap.containsKey(userUniversity)) {
                    List thisUniUsers = (List)userToUniMap.get(userUniversity);
                    thisUniUsers.add(user);
                    userToUniMap.put(userUniversity, thisUniUsers);
                    continue;
                }
                LinkedList<User> newUniUsers = new LinkedList<User>();
                newUniUsers.add(user);
                userToUniMap.put(userUniversity, newUniUsers);
            }
            JSONArray enrollmentRows = new JSONArray();
            JSONObject enrollmentRowHeader = new JSONObject();
            JSONObject enrollmentRowTotal = new JSONObject();
            JSONArray activeRows = new JSONArray();
            JSONObject activeRowHeader = new JSONObject();
            JSONObject activeRowTotal = new JSONObject();
            JSONArray completedRows = new JSONArray();
            JSONObject completedRowHeader = new JSONObject();
            JSONObject completedRowTotal = new JSONObject();
            JSONArray timeRows = new JSONArray();
            JSONObject timeRowHeader = new JSONObject();
            JSONObject timeRowTotal = new JSONObject();
            int totalMaleEnrollments = 0;
            int totalFemaleEnrollments = 0;
            int totalEnrollments = 0;
            int totalMaleActiveUsers = 0;
            int totalFemaleActiveUsers = 0;
            int totalActiveUsers = 0;
            int totalMaleCompleted = 0;
            int totalFemaleCompleted = 0;
            int totalCompleted = 0;
            long totalMaleTime = 0L;
            long totalFemaleTime = 0L;
            long totalTime = 0L;
            String daysString = req.getParameter("days");
            String from = req.getParameter("from");
            String to = req.getParameter("to");
            int days = 0;
            try {
                days = Integer.parseInt(daysString);
            }
            catch (Exception e) {
                days = 0;
            }
            if (days < 1) {
                days = 7;
            }
            System.out.println("Days given: " + days);
            Long fromDate = this.getDateBeforeDays(days);
            Long toDate = System.currentTimeMillis();
            System.out.println("From date: " + fromDate + " , to date: " + toDate);
            SummaryResult result = this.getSummaryResult(fromDate, toDate, dbContext);
            LinkedList<String> enrolledUsersUsername = new LinkedList<String>();
            for (User user : result.getEnrolled()) {
                enrolledUsersUsername.add(user.getUsername());
            }
            LinkedList<String> activeUsersUsername = new LinkedList<String>();
            for (User user : result.getActive()) {
                activeUsersUsername.add(user.getUsername());
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            for (User u : result.getCompleted()) {
                linkedList.add(u.getUsername());
            }
            Map<String, Long> map = result.getDurationMap();
            for (Map.Entry uniUsers : userToUniMap.entrySet()) {
                String university = (String)uniUsers.getKey();
                List users = (List)uniUsers.getValue();
                JSONObject enrollment = new JSONObject();
                enrollment.put("title", (Object)university);
                enrollment.put("no_females", 0);
                enrollment.put("no_males", 0);
                enrollment.put("total", 0);
                JSONObject active = new JSONObject();
                active.put("title", (Object)university);
                active.put("no_females", 0);
                active.put("no_males", 0);
                active.put("total", 0);
                JSONObject completed = new JSONObject();
                completed.put("title", (Object)university);
                completed.put("no_females", 0);
                completed.put("no_males", 0);
                completed.put("total", 0);
                JSONObject time = new JSONObject();
                time.put("title", (Object)university);
                time.put("no_females", 0);
                time.put("no_males", 0);
                time.put("total", 0);
                for (User user : users) {
                    String userGender = ucfManager.getUserField(user, MappingValues.custom_fields_map.get("gender").intValue(), dbContext).toLowerCase();
                    if (enrolledUsersUsername.contains(user.getUsername())) {
                        if (userGender.contains("male")) {
                            ++totalMaleEnrollments;
                            enrollment.put("no_males", (Integer)enrollment.get("no_males") + 1);
                        }
                        if (userGender.contains("female")) {
                            ++totalFemaleEnrollments;
                            enrollment.put("no_males", (Integer)enrollment.get("no_males") + 1);
                        }
                        ++totalEnrollments;
                        enrollment.put("total", (Integer)enrollment.get("total") + 1);
                    }
                    if (activeUsersUsername.contains(user.getUsername())) {
                        if (userGender.contains("male")) {
                            ++totalMaleActiveUsers;
                            active.put("no_males", (Integer)active.get("no_males") + 1);
                        }
                        if (userGender.contains("female")) {
                            ++totalFemaleActiveUsers;
                            active.put("no_males", (Integer)active.get("no_males") + 1);
                        }
                        ++totalActiveUsers;
                        active.put("total", (Integer)active.get("total") + 1);
                    }
                    if (linkedList.contains(user.getUsername())) {
                        if (userGender.contains("male")) {
                            ++totalMaleCompleted;
                            completed.put("no_males", (Integer)completed.get("no_males") + 1);
                        }
                        if (userGender.contains("female")) {
                            ++totalFemaleCompleted;
                            completed.put("no_males", (Integer)completed.get("no_males") + 1);
                        }
                        ++totalCompleted;
                        completed.put("total", (Integer)completed.get("total") + 1);
                    }
                    if (!map.containsKey(user.getUsername())) continue;
                    long duration = map.get(user.getUsername());
                    long durationSeconds = duration / 1000L;
                    if (userGender.contains("male")) {
                        totalMaleTime += durationSeconds;
                        long currentMaleTime = time.getLong("no_males");
                        time.put("no_males", currentMaleTime + durationSeconds);
                    }
                    if (userGender.contains("female")) {
                        long currentFemaleTime = time.getLong("no_females");
                        totalFemaleTime += durationSeconds;
                        time.put("no_females", currentFemaleTime + durationSeconds);
                    }
                    long currentTotal = time.getLong("total");
                    totalTime += durationSeconds;
                    time.put("total", currentTotal + durationSeconds);
                }
                String uniMaleTimeReadable = CourseUsageReportServlet.getDurationBreakdown(time.getLong("no_males") * 1000L);
                String uniFemaleTimeReadable = CourseUsageReportServlet.getDurationBreakdown(time.getLong("no_females") * 1000L);
                String uniTimeReadable = CourseUsageReportServlet.getDurationBreakdown(time.getLong("total") * 1000L);
                time.put("no_males", (Object)uniMaleTimeReadable);
                time.put("no_females", (Object)uniFemaleTimeReadable);
                time.put("total", (Object)uniTimeReadable);
                enrollmentRows.put((Object)enrollment);
                activeRows.put((Object)active);
                completedRows.put((Object)completed);
                timeRows.put((Object)time);
            }
            enrollmentRowHeader.put("title", (Object)"<b>Number of enrollments</b>");
            enrollmentRowTotal.put("title", (Object)"<b>TOTAL</b>");
            enrollmentRowTotal.put("no_males", totalMaleEnrollments);
            enrollmentRowTotal.put("no_females", totalFemaleEnrollments);
            enrollmentRowTotal.put("total", totalEnrollments);
            activeRowHeader.put("title", (Object)"<b>Number of active users</b>");
            activeRowTotal.put("title", (Object)"<b>TOTAL</b>");
            activeRowTotal.put("no_males", totalMaleActiveUsers);
            activeRowTotal.put("no_females", totalFemaleActiveUsers);
            activeRowTotal.put("total", totalActiveUsers);
            completedRowHeader.put("title", (Object)"<b>Number of students who completed all modules</b>");
            completedRowTotal.put("title", (Object)"<b>TOTAL</b>");
            completedRowTotal.put("no_males", totalMaleCompleted);
            completedRowTotal.put("no_females", totalFemaleCompleted);
            completedRowTotal.put("total", totalCompleted);
            timeRowHeader.put("title", (Object)"<b>Total time spent</b>");
            String totalMaleTimeReadable = CourseUsageReportServlet.getDurationBreakdown(totalMaleTime * 1000L);
            String totalFemaleTimeReadable = CourseUsageReportServlet.getDurationBreakdown(totalFemaleTime * 1000L);
            String totalTimeReadable = CourseUsageReportServlet.getDurationBreakdown(totalTime * 1000L);
            timeRowTotal.put("title", (Object)"<b>TOTAL</b>");
            timeRowTotal.put("no_males", (Object)totalMaleTimeReadable);
            timeRowTotal.put("no_females", (Object)totalFemaleTimeReadable);
            timeRowTotal.put("total", (Object)totalTimeReadable);
            reportJSONArray.put((Object)enrollmentRowHeader);
            for (i = 0; i < enrollmentRows.length(); ++i) {
                reportJSONArray.put(enrollmentRows.get(i));
            }
            reportJSONArray.put((Object)enrollmentRowTotal);
            reportJSONArray.put((Object)new JSONObject());
            reportJSONArray.put((Object)activeRowHeader);
            for (i = 0; i < activeRows.length(); ++i) {
                reportJSONArray.put(activeRows.get(i));
            }
            reportJSONArray.put((Object)activeRowTotal);
            reportJSONArray.put((Object)new JSONObject());
            reportJSONArray.put((Object)completedRowHeader);
            for (i = 0; i < completedRows.length(); ++i) {
                reportJSONArray.put(completedRows.get(i));
            }
            reportJSONArray.put((Object)completedRowTotal);
            reportJSONArray.put((Object)new JSONObject());
            reportJSONArray.put((Object)timeRowHeader);
            for (i = 0; i < timeRows.length(); ++i) {
                reportJSONArray.put(timeRows.get(i));
            }
            reportJSONArray.put((Object)timeRowTotal);
            reportJSONArray.put((Object)new JSONObject());
            jsonToReturn = reportJSONArray.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println("EXCEPTION!");
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().write(jsonToReturn);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    public class SummaryResult {
        private List<User> enrolled;
        private List<User> active;
        private List<User> completed;
        private Map<String, Long> durationMap;

        public SummaryResult(List<User> enrolled, List<User> active, List<User> completed, Map<String, Long> durationMap) {
            this.enrolled = enrolled;
            this.active = active;
            this.completed = completed;
            this.durationMap = durationMap;
        }

        public List<User> getEnrolled() {
            return this.enrolled;
        }

        public void setEnrolled(List<User> enrolled) {
            this.enrolled = enrolled;
        }

        public List<User> getActive() {
            return this.active;
        }

        public void setActive(List<User> active) {
            this.active = active;
        }

        public List<User> getCompleted() {
            return this.completed;
        }

        public void setCompleted(List<User> completed) {
            this.completed = completed;
        }

        public Map<String, Long> getDurationMap() {
            return this.durationMap;
        }

        public void setDurationMap(Map<String, Long> durationMap) {
            this.durationMap = durationMap;
        }
    }
}

