/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.ustadmobile.nanolrs.core.manager.NodeManager;
import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.model.NanoLrsModel;
import com.ustadmobile.nanolrs.core.model.Node;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.core.sync.UMSyncEndpoint;
import com.ustadmobile.nanolrs.core.sync.UMSyncResult;
import com.ustadmobile.nanolrs.util.ServletUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UMSyncServlet
extends HttpServlet {
    public UMSyncServlet() {
        System.out.println("In UMSyncServlet()..");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("In UMSyncServlet.doGet()..");
        response.sendRedirect("home/");
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        User existingUser;
        Object dbContext = this.getServletContext().getAttribute("connectionSource");
        String userUuid = ServletUtil.getHeaderVal(req, "X-UM-useruuid");
        String username = ServletUtil.getHeaderVal(req, "X-UM-username");
        String password = ServletUtil.getHeaderVal(req, "X-UM-password");
        String isNewUser = ServletUtil.getHeaderVal(req, "X-UM-isnewuser");
        String nodeUuid = ServletUtil.getHeaderVal(req, "X-UM-nodeuuid");
        String nodetHostName = ServletUtil.getHeaderVal(req, "X-UM-nodehost");
        String nodeHostUrl = ServletUtil.getHeaderVal(req, "X-UM-nodeurl");
        String nodeRole = ServletUtil.getHeaderVal(req, "X-UM-noderole");
        String basicAuth = ServletUtil.getHeaderVal(req, "Authorization");
        String syncStatus = ServletUtil.getHeaderVal(req, "X-UM-syncstatus");
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        String authUsername = ServletUtil.getUsernameFromBasicAuth(req);
        String authPassword = ServletUtil.getPasswordFromBasicAuth(req);
        if (authUsername != null && authPassword != null) {
            username = authUsername;
            password = authPassword;
        }
        if (!userManager.authenticate(dbContext, username, password, true) && (existingUser = userManager.findByUsername(dbContext, username)) == null && isNewUser.equals("true")) {
            try {
                User newUser = (User)userManager.makeNew();
                newUser.setUuid(userUuid);
                newUser.setUsername(username);
                if (password != null && !password.isEmpty()) {
                    try {
                        password = userManager.hashPassword(password);
                    }
                    catch (NoSuchAlgorithmException e) {
                        System.out.println("Cannot hash password.: " + e);
                        e.printStackTrace();
                    }
                }
                newUser.setPassword(password);
                userManager.persist(dbContext, (NanoLrsModel)newUser);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        NodeManager nodeManager = (NodeManager)pm.getManager(NodeManager.class);
        Node node = null;
        try {
            node = (Node)nodeManager.findByPrimaryKey(dbContext, (Object)nodeUuid);
            if (node == null) {
                node = (Node)nodeManager.makeNew();
                node.setUUID(nodeUuid);
                node.setUrl(nodeHostUrl);
                node.setName(nodetHostName);
                node.setHost(nodetHostName);
                node.setRole(nodeRole);
                if (nodeRole.equals("proxy")) {
                    node.setProxy(true);
                }
                if (nodeRole.equals("main")) {
                    node.setMaster(true);
                }
                nodeManager.persist(dbContext, (NanoLrsModel)node);
            } else if (!node.getHost().equals(nodeHostUrl)) {
                node.setHost(nodeHostUrl);
                nodeManager.persist(dbContext, (NanoLrsModel)node);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("X-UM-useruuid", userUuid);
        reqHeaders.put("X-UM-username", username);
        reqHeaders.put("X-UM-password", password);
        reqHeaders.put("X-UM-isnewuser", isNewUser);
        reqHeaders.put("X-UM-nodeuuid", nodeUuid);
        reqHeaders.put("X-UM-nodehost", nodetHostName);
        reqHeaders.put("X-UM-nodeurl", nodeHostUrl);
        reqHeaders.put("X-UM-noderole", nodeRole);
        reqHeaders.put("X-UM-syncstatus", syncStatus);
        reqHeaders.put("Authorization", basicAuth);
        HashMap reqParams = new HashMap();
        ServletInputStream reqInputStream = req.getInputStream();
        UMSyncResult result = null;
        try {
            result = UMSyncEndpoint.handleIncomingSync((InputStream)reqInputStream, (Node)node, reqHeaders, reqParams, (Object)dbContext);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String statusMessage = "";
        switch (result.getStatus()) {
            case 200: {
                if (UMSyncEndpoint.getHeader((Map)result.getHeaders(), (String)"X-UM-syncstatus").equals("OK")) {
                    System.out.println("UMSyncServlet: Incoming Sync OK. Updating SyncStatus");
                    resp.setHeader("X-UM-syncstatus", "OK");
                    try {
                        UMSyncEndpoint.updateSyncStatus((UMSyncResult)result, (Node)node, (Object)dbContext);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                statusMessage.equals("OK");
                break;
            }
            default: {
                statusMessage.equals("INTERNAL ERROR");
            }
        }
        resp.setStatus(result.getStatus());
        resp.setContentType("application/json");
        resp.setHeader("key", "value");
        resp.setContentLength((int)result.getResponseLength());
        ServletOutputStream sos = resp.getOutputStream();
        String responseDataString = ServletUtil.convertStreamToString(result.getResponseData(), "UTF-8");
        byte[] responseDataBytes = responseDataString.getBytes();
        sos.write(responseDataBytes);
        sos.close();
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }
}

