/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.servlet;

import com.ustadmobile.nanolrs.core.manager.UserManager;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.util.MappingValues;
import com.ustadmobile.nanolrs.util.ServletUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserInfoReportServlet
extends HttpServlet {
    public static final String UNIVERSITY_FILTER_NAME = "universities_filter_names[]";
    public static final String LEGACY_MODE_FILTER_NAME = "legacy_mode";
    public static final String PASSED_STRING = "PASSED";
    public static final String FAILED_STRING = "FAILED";
    public static final String NA_STRING = "N/A";

    public UserInfoReportServlet() {
        System.out.println("In UserInfoReportServlet()..");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("In UserInfoReportServlet.doGet()..");
        LinkedHashMap<String, String> table_headers_html = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> table_headers_class = new LinkedHashMap<String, String>();
        table_headers_html.put("fullname", "Name");
        table_headers_class.put("fullname", "sticky");
        table_headers_html.put("username", "Username");
        table_headers_class.put("username", "sticky");
        table_headers_html.put("university", "University");
        table_headers_class.put("university", "sticky");
        table_headers_html.put("tazkira_id", "Tazkira ID");
        table_headers_html.put("gender", "Gender");
        HttpSession session = request.getSession();
        String sessionAdmin = (String)session.getAttribute("admin");
        if (sessionAdmin != null) {
            if (sessionAdmin.equals("admin")) {
                request.setAttribute("table_headers_html", table_headers_html);
                request.setAttribute("static", (Object)"/syncendpoint/");
                request.setAttribute("universities", (Object)MappingValues.universities);
                request.getSession().setAttribute("table_headers_html", table_headers_html);
                request.getSession().setAttribute("table_headers_class", table_headers_class);
                request.getSession().setAttribute("static", (Object)"/syncendpoint/");
                request.getSession().setAttribute("universities", (Object)MappingValues.universities);
                request.getRequestDispatcher("../UserInfoReport.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect("../../Login.jsp");
            }
        } else {
            response.sendRedirect("../../Login.jsp");
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("In UserInfoReportServlet.doPost()..");
        Object dbContext = this.getServletContext().getAttribute("connectionSource");
        PersistenceManager pm = PersistenceManager.getInstance();
        UserManager userManager = (UserManager)pm.getManager(UserManager.class);
        String jsonToReturn = "";
        JSONArray userEnrollmentJSONArray = new JSONArray();
        try {
            String username = req.getParameter("username");
            System.out.println("Username is: " + username);
            User user = userManager.findByUsername(dbContext, username);
            if (user != null) {
                JSONObject userInfoJSON = ServletUtil.getUserInfo(user, dbContext);
                userInfoJSON.put("blankspace", (Object)"");
                userEnrollmentJSONArray.put((Object)userInfoJSON);
                jsonToReturn = userEnrollmentJSONArray.toString();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println("EXCEPTION!");
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().write(jsonToReturn);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }
}

