/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.nanolrs.util;

import com.ustadmobile.nanolrs.core.manager.UserCustomFieldsManager;
import com.ustadmobile.nanolrs.core.model.User;
import com.ustadmobile.nanolrs.core.persistence.PersistenceManager;
import com.ustadmobile.nanolrs.util.Base64Coder;
import com.ustadmobile.nanolrs.util.MappingValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.io.FileUtils;
import org.json.CDL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServletUtil {
    public static String REPORT_FILE_EXTENSION = ".csv";
    public static String excel_file_location;

    public static String getUsernameFromBasicAuth(HttpServletRequest request) {
        String[] credentials = ServletUtil.getCredentialStringFromBasicAuth(request);
        if (credentials != null && credentials.length > 0) {
            return credentials[0];
        }
        return null;
    }

    public static String getPasswordFromBasicAuth(HttpServletRequest request) {
        String[] credentials = ServletUtil.getCredentialStringFromBasicAuth(request);
        if (credentials != null && credentials.length > 0) {
            return credentials[1];
        }
        return null;
    }

    public static String[] getCredentialStringFromBasicAuth(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            String base64Credentials = authorization.substring("Basic".length()).trim();
            String credentials = Base64Coder.decodeString(base64Credentials);
            String[] values = credentials.split(":", 2);
            return values;
        }
        return null;
    }

    public static String getHeaderVal(HttpServletRequest request, String headerName) {
        String oldHeaderName = null;
        if (headerName.startsWith("X-UM-")) {
            oldHeaderName = headerName.substring("X-UM-".length(), headerName.length());
        }
        if (request.getHeader(headerName) == null) {
            String value = request.getHeader(oldHeaderName);
            return value;
        }
        return request.getHeader(headerName);
    }

    public static String getParamVal(HttpServletRequest request, String paramName) {
        return request.getParameter(paramName);
    }

    public static Map<String, String> getHeadersFromRequest(HttpServletRequest request) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames != null && headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            requestHeaders.put(headerName, ServletUtil.getHeaderVal(request, headerName));
        }
        if (headerNames == null) {
            return null;
        }
        return requestHeaders;
    }

    public static Map<String, String> getParamsFromRequest(HttpServletRequest request) {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        Enumeration parameterNames = request.getHeaderNames();
        while (parameterNames != null && parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            requestParameters.put(paramName, ServletUtil.getHeaderVal(request, paramName));
        }
        if (parameterNames == null) {
            return null;
        }
        return requestParameters;
    }

    public static String convertStreamToString(InputStream is, String encoding) throws IOException {
        int rsz;
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, encoding);
        while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
            out.append(buffer, 0, rsz);
        }
        return out.toString();
    }

    public static String encodeBasicAuth(String username, String password) {
        return "Basic " + Base64Coder.encodeString(username + ':' + password);
    }

    public static JSONObject getUserInfo(User user, Object dbContext) throws SQLException {
        UserCustomFieldsManager userCustomFieldsManager = (UserCustomFieldsManager)PersistenceManager.getInstance().getManager(UserCustomFieldsManager.class);
        JSONObject userInfo = new JSONObject();
        String[] stringArray = MappingValues.USER_COLUMN_FIELDS;
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String field;
            switch (field = stringArray[i]) {
                case "gender": {
                    String gender = userCustomFieldsManager.getUserField(user, MappingValues.custom_fields_map.get("gender").intValue(), dbContext);
                    userInfo.put("gender", (Object)gender);
                    continue block14;
                }
                case "tazkira_id": {
                    String tazkira_id = userCustomFieldsManager.getUserField(user, MappingValues.custom_fields_map.get("tazkira_id").intValue(), dbContext);
                    userInfo.put("tazkira_id", (Object)tazkira_id);
                    continue block14;
                }
                case "fullname": {
                    String fullname = userCustomFieldsManager.getUserField(user, MappingValues.custom_fields_map.get("fullname").intValue(), dbContext);
                    userInfo.put("fullname", (Object)fullname);
                    continue block14;
                }
                case "username": {
                    String usernameField = user.getUsername();
                    usernameField = "<a href=\"/syncendpoint/reports/userinfo/?username=" + usernameField + "\">" + usernameField + "</a>";
                    userInfo.put("username", (Object)usernameField);
                    continue block14;
                }
                case "university": {
                    String university = userCustomFieldsManager.getUserField(user, MappingValues.custom_fields_map.get("university").intValue(), dbContext);
                    if (university == null) {
                        university = "";
                    }
                    userInfo.put("university", (Object)university);
                    if (MappingValues.uni_map.containsKey(university)) {
                        userInfo.put("university", (Object)MappingValues.uni_map.get(university));
                        continue block14;
                    }
                    userInfo.put("university", (Object)"");
                    continue block14;
                }
            }
        }
        return userInfo;
    }

    public static JSONObject getUserColumnMap(User user, Object dbContext) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeExcelReport(JSONArray data, String reportName, String[] columnsInOrder) {
        Date date = new Date();
        long unixTime = date.getTime() / 1000L;
        excel_file_location = "report_" + unixTime + ".xls";
        WritableWorkbook myFirstWbook = null;
        try {
            myFirstWbook = Workbook.createWorkbook((File)new File(excel_file_location));
            WritableSheet excelSheet = myFirstWbook.createSheet(reportName, 0);
            Label[] headers = new Label[columnsInOrder.length];
            myFirstWbook.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (myFirstWbook != null) {
                try {
                    myFirstWbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (WriteException e) {
                    e.printStackTrace();
                }
            }
        }
        return excel_file_location;
    }

    public static LinkedHashMap<String, String> getLinkedMapFromString(String value) {
        value = value.substring(1, value.length() - 1);
        String[] keyValuePairs = value.split(",");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String pair : keyValuePairs) {
            String[] entry = pair.split("=");
            if (entry.length <= 1 || entry[0].trim().isEmpty()) continue;
            map.put(entry[0].trim(), entry[1].trim());
        }
        return map;
    }

    public static String jsonArrayToStringInOrder(JSONArray ja, LinkedHashMap<String, String> table_headers_html_map) throws JSONException {
        JSONArray orderedNames = new JSONArray();
        JSONArray orderedLabels = new JSONArray();
        for (Map.Entry<String, String> e : table_headers_html_map.entrySet()) {
            String name = e.getKey();
            orderedNames.put((Object)name);
            String label = e.getValue();
            orderedLabels.put((Object)label);
        }
        JSONObject jo = ja.optJSONObject(0);
        if (jo != null) {
            JSONArray names = jo.names();
            if (orderedNames != null) {
                return CDL.rowToString((JSONArray)orderedLabels) + CDL.toString((JSONArray)orderedNames, (JSONArray)ja);
            }
        }
        return null;
    }

    public static File jsonToReportFile(JSONArray data, LinkedHashMap<String, String> table_headers_html_map) {
        Date date = new Date();
        long unixTime = date.getTime() / 1000L;
        excel_file_location = "report_" + unixTime + REPORT_FILE_EXTENSION;
        try {
            File dir = new File("reports");
            dir.mkdir();
            File file = new File(dir, excel_file_location);
            System.out.println("File path : " + file.getAbsolutePath());
            String csv = ServletUtil.jsonArrayToStringInOrder(data, table_headers_html_map);
            FileUtils.writeStringToFile((File)file, (String)csv);
            return file;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean shouldIShowThisUserWithFilter(String user_variable, ArrayList filters) {
        boolean iWantToBreakFree = false;
        if (!filters.isEmpty() && !filters.contains("ALL")) {
            if (filters.contains("Other") || filters.contains("I don't know")) {
                if (!(user_variable.contains("Other") || user_variable.contains("I don't know") || user_variable == null || user_variable.isEmpty() || user_variable.trim().isEmpty())) {
                    iWantToBreakFree = true;
                }
            } else if (!filters.contains(user_variable)) {
                iWantToBreakFree = true;
            }
        }
        return iWantToBreakFree;
    }

    public static String stringToHTMLString(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastWasBlankChar = true;
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\n') {
                sb.append("&lt;br/&gt;");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(new Integer(ci).toString());
            sb.append(';');
        }
        return sb.toString();
    }
}

